/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin;

import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.plugin.Rewards;
import de.themoep.rewards.plugin.gui.TrackGui;
import de.themoep.rewards.plugin.gui.TracksGui;
import java.util.ArrayList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RewardsCommand
implements CommandExecutor {
    private final Rewards plugin;

    public RewardsCommand(Rewards plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                ArrayList<Track> availableTracks = new ArrayList<Track>();
                for (Track track : this.plugin.getTracks()) {
                    if (!track.canAccess(sender)) continue;
                    availableTracks.add(track);
                }
                if (availableTracks.isEmpty()) {
                    this.plugin.sendMessage(sender, "error.no-tracks-available", new String[0]);
                    return true;
                }
                this.plugin.runAsync(() -> {
                    UserData userData = this.plugin.getUserStorage().getData((Player)sender);
                    this.plugin.runSync(() -> {
                        if (((Player)sender).isOnline()) {
                            if (availableTracks.size() == 1) {
                                new TrackGui(this.plugin, (Player)sender, userData, (Track)availableTracks.iterator().next());
                            } else {
                                new TracksGui(this.plugin, (Player)sender, userData, availableTracks);
                            }
                        }
                    });
                });
                return true;
            }
            return false;
        }
        if ("reload".equalsIgnoreCase(args[0]) && sender.hasPermission("rewards.command.reload")) {
            this.plugin.loadConfig();
            this.plugin.sendMessage(sender, "config-reloaded", new String[0]);
        } else if ("grant".equalsIgnoreCase(args[0]) && sender.hasPermission("rewards.command.grant")) {
            Player target;
            if (args.length < 2) {
                return false;
            }
            Track track = this.plugin.getTrack(args[1]);
            if (track == null) {
                this.plugin.sendMessage(sender, "error.track-not-found", "track", args[1]);
                return true;
            }
            if (args.length > 2 && sender.hasPermission("rewards.command.grant.others")) {
                target = this.plugin.getServer().getPlayer(args[2]);
                if (target == null) {
                    this.plugin.sendMessage(sender, "error.player-not-found", "player", args[2]);
                    return true;
                }
            } else if (sender instanceof Player) {
                target = (Player)sender;
            } else {
                this.plugin.sendMessage(sender, "error.console-no-player", new String[0]);
                return false;
            }
            int points = 1;
            if (args.length > 3) {
                try {
                    points = Integer.parseInt(args[3]);
                    if (points <= 0) {
                        this.plugin.sendMessage(sender, "error.invalid-points", "points", args[3]);
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    this.plugin.sendMessage(sender, "error.invalid-points", "points", args[3]);
                    return true;
                }
            }
            this.plugin.trigger(target, track, points);
            this.plugin.sendMessage(sender, "command.track-triggered", "track", track.getId(), "player", target.getName(), "points", String.valueOf(points));
        }
        return true;
    }
}

