/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.plugin;

import de.themoep.rewards.api.RewardsPlugin;
import de.themoep.rewards.api.track.Reward;
import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.trigger.Trigger;
import de.themoep.rewards.api.trigger.TriggerData;
import de.themoep.rewards.api.user.UserData;
import de.themoep.rewards.api.user.UserStorage;
import de.themoep.rewards.integrations.votifier.VoteTrigger;
import de.themoep.rewards.lib.lang.LanguageConfig;
import de.themoep.rewards.lib.lang.bukkit.BukkitLanguageConfig;
import de.themoep.rewards.lib.lang.bukkit.LanguageManager;
import de.themoep.rewards.lib.minedown.MineDown;
import de.themoep.rewards.lib.minedown.Replacer;
import de.themoep.rewards.plugin.RewardsCommand;
import de.themoep.rewards.plugin.managers.TrackManager;
import de.themoep.rewards.plugin.managers.TriggerManager;
import de.themoep.rewards.plugin.storage.MysqlStorage;
import de.themoep.rewards.plugin.storage.StorageCache;
import de.themoep.rewards.plugin.storage.YamlStorage;
import de.themoep.rewards.plugin.triggers.BlockBreakTrigger;
import de.themoep.rewards.plugin.triggers.BlockPlaceTrigger;
import de.themoep.rewards.plugin.triggers.DeathTrigger;
import de.themoep.rewards.plugin.triggers.ExpPickupTrigger;
import de.themoep.rewards.plugin.triggers.ItemDropTrigger;
import de.themoep.rewards.plugin.triggers.ItemPickupTrigger;
import de.themoep.rewards.plugin.triggers.JoinTrigger;
import de.themoep.rewards.plugin.triggers.LevelTrigger;
import de.themoep.rewards.plugin.triggers.MobKillTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.scheduler.BukkitTask;

public final class Rewards
extends RewardsPlugin
implements Listener {
    private NamespacedKey pdcId;
    private LanguageManager lang;
    private TrackManager trackManager;
    private TriggerManager triggerManager;
    private UserStorage userStorage;
    private Economy economy;
    private boolean debug;

    public void onEnable() {
        this.pdcId = new NamespacedKey((Plugin)this, "id");
        plugin = this;
        if (!this.setupEconomy()) {
            this.getLogger().log(Level.WARNING, "No economy plugin found yet!");
        }
        this.triggerManager = new TriggerManager(this);
        this.triggerManager.registerTrigger(new BlockBreakTrigger());
        this.triggerManager.registerTrigger(new BlockPlaceTrigger());
        this.triggerManager.registerTrigger(new DeathTrigger());
        this.triggerManager.registerTrigger(new ExpPickupTrigger());
        this.triggerManager.registerTrigger(new ItemDropTrigger());
        this.triggerManager.registerTrigger(new ItemPickupTrigger());
        this.triggerManager.registerTrigger(new JoinTrigger());
        this.triggerManager.registerTrigger(new LevelTrigger());
        this.triggerManager.registerTrigger(new MobKillTrigger());
        if (this.getServer().getPluginManager().isPluginEnabled("Votifier") || this.getServer().getPluginManager().isPluginEnabled("NuVotifier")) {
            this.registerTrigger(new VoteTrigger());
        }
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("rewards").setExecutor((CommandExecutor)new RewardsCommand(this));
    }

    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        if (event.getProvider().getProvider() instanceof Economy) {
            this.logDebug("Plugin " + event.getProvider().getPlugin().getName() + " registered an economy service!");
            this.setupEconomy();
        }
    }

    @EventHandler
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        if (event.getProvider().getProvider() instanceof Economy) {
            this.logDebug("Plugin " + event.getProvider().getPlugin().getName() + " unregistered an economy service!");
            this.setupEconomy();
        }
    }

    @EventHandler
    public void onPlayerAsyncPreLogin(AsyncPlayerPreLoginEvent event) {
        if (this.userStorage instanceof StorageCache) {
            this.userStorage.getData(event.getUniqueId(), event.getName());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.userStorage instanceof StorageCache) {
            ((StorageCache)this.userStorage).invalidate(event.getPlayer());
        }
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        this.logDebug("Found economy " + this.economy.getName() + "!");
        return true;
    }

    void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.debug = this.getConfig().getBoolean("debug");
        this.lang = new LanguageManager((Plugin)this, this.getConfig().getString("lang"), new BukkitLanguageConfig[0]);
        this.trackManager = new TrackManager(this);
        this.userStorage = "mysql".equalsIgnoreCase(this.getConfig().getString("storage")) ? new MysqlStorage(this) : new YamlStorage(this);
        if (this.getConfig().getLong("user-cache-duration") > 0L) {
            this.userStorage = new StorageCache(this, this.userStorage);
        }
    }

    public void onDisable() {
        for (Trigger trigger : this.triggerManager.getTriggers()) {
            trigger.shutdown();
        }
    }

    public LanguageManager getLang() {
        return this.lang;
    }

    @Override
    public NamespacedKey getPdcId() {
        return this.pdcId;
    }

    @Override
    public void registerTrigger(Trigger trigger) throws IllegalArgumentException {
        this.triggerManager.registerTrigger(trigger);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return this.triggerManager.getTriggers();
    }

    @Override
    public Trigger.Response trigger(Player player, String trigger, TriggerData data) {
        return this.triggerManager.trigger(player, trigger.toLowerCase(), data);
    }

    @Override
    public Track getTrack(String trackId) {
        return this.trackManager.getTrack(trackId);
    }

    @Override
    public Collection<Track> getTracks() {
        return this.trackManager.getTracks();
    }

    @Override
    public void trigger(Player player, Track track, int points) {
        this.runAsync(() -> this.trackManager.trigger(player, this.getUserStorage().getData(player), track, points));
    }

    public void trigger(Player player, UserData userData, Track track, int points) {
        this.trackManager.trigger(player, userData, track, points);
    }

    @Override
    public void rewardPlayer(UUID playerId, List<Reward> rewards) {
        this.runSync(() -> {
            Player player = this.getServer().getPlayer(playerId);
            for (Reward reward : rewards) {
                this.give(player, reward);
            }
        });
    }

    private void give(Player player, Reward reward) {
        this.logDebug("Player " + player.getName() + " received " + reward);
        if (reward.getMoney() > 0.0) {
            this.economy.depositPlayer((OfflinePlayer)player, reward.getMoney());
        }
        if (reward.getItem() != null) {
            for (ItemStack rest : player.getInventory().addItem(new ItemStack[]{reward.getItem()}).values()) {
                player.getLocation().getWorld().dropItem(player.getLocation(), rest).setOwner(player.getUniqueId());
            }
        }
        for (String command : reward.getCommands()) {
            this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), new Replacer().replace("player", player.getName()).replaceIn(command));
        }
    }

    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public UserStorage getUserStorage() {
        return this.userStorage;
    }

    public boolean logDebug(String message) {
        if (this.debug) {
            this.getLogger().log(Level.INFO, message);
        }
        return this.debug;
    }

    public BukkitTask runSync(Runnable runnable) {
        return this.getServer().getScheduler().runTask((Plugin)this, runnable);
    }

    public BukkitTask runAsync(Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            return this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, runnable);
        }
        runnable.run();
        return null;
    }

    public void sendMessage(CommandSender sender, String key, String ... replacements) {
        sender.spigot().sendMessage(this.getMessage(sender, key, replacements));
    }

    private String getLang(CommandSender sender, String key) {
        if (!key.contains("|")) {
            return this.getLang().getConfig(sender).get(key);
        }
        LanguageConfig config = this.getLang().getConfig(sender);
        ArrayList<StringBuilder> keyList = new ArrayList<StringBuilder>();
        for (String k : key.split("\\.")) {
            if (k.contains("|")) {
                String[] parts = k.split("\\|");
                if (keyList.isEmpty()) {
                    for (String p : parts) {
                        keyList.add(new StringBuilder(p));
                    }
                    continue;
                }
                ArrayList<StringBuilder> newKeyList = new ArrayList<StringBuilder>();
                for (StringBuilder kb : keyList) {
                    for (String p : parts) {
                        newKeyList.add(new StringBuilder(kb).append('.').append(p));
                    }
                }
                keyList = newKeyList;
                continue;
            }
            if (keyList.isEmpty()) {
                keyList.add(new StringBuilder(k));
                continue;
            }
            for (StringBuilder kb : keyList) {
                kb.append('.').append(k);
            }
        }
        for (StringBuilder sb : keyList) {
            String k = sb.toString();
            if (!config.contains(k)) continue;
            return config.get(k);
        }
        return config.get(String.join((CharSequence)".", key));
    }

    public BaseComponent[] getMessage(CommandSender sender, String key, String ... replacements) {
        return MineDown.parse(this.getLang(sender, key), replacements);
    }

    public String getText(CommandSender sender, String key, String ... replacements) {
        return TextComponent.toLegacyText((BaseComponent[])this.getMessage(sender, key, replacements));
    }
}

