/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.lib.lang.bukkit;

import de.themoep.rewards.lib.lang.LangLogger;
import de.themoep.rewards.lib.lang.LanguageManagerCore;
import de.themoep.rewards.lib.lang.bukkit.BukkitLanguageConfig;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LanguageManager
extends LanguageManagerCore<CommandSender, FileConfiguration> {
    private final Plugin plugin;

    public LanguageManager(Plugin plugin, String defaultLocale, BukkitLanguageConfig ... configs) {
        this(plugin, "languages", defaultLocale, configs);
    }

    public LanguageManager(Plugin plugin, String defaultLocale, boolean saveFiles, BukkitLanguageConfig ... configs) {
        this(plugin, "languages", "languages", defaultLocale, saveFiles, configs);
    }

    public LanguageManager(Plugin plugin, String folder, String defaultLocale, BukkitLanguageConfig ... configs) {
        this(plugin, folder, folder, defaultLocale, configs);
    }

    public LanguageManager(Plugin plugin, String resourceFolder, String folder, String defaultLocale, BukkitLanguageConfig ... configs) {
        this(plugin, resourceFolder, folder, defaultLocale, true, configs);
    }

    public LanguageManager(Plugin plugin, String resourceFolder, String folder, String defaultLocale, boolean saveFiles, BukkitLanguageConfig ... configs) {
        super(defaultLocale, resourceFolder, new File(plugin.getDataFolder(), folder), (S sender) -> {
            if (sender instanceof Player) {
                try {
                    return ((Player)sender).getLocale();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            return null;
        }, "lang.", ".yml", saveFiles, configs);
        this.plugin = plugin;
        this.loadConfigs();
    }

    @Override
    public void loadConfigs() {
        this.loadConfigs(this.plugin.getClass(), new LangLogger(){

            @Override
            public void log(Level level, String message) {
                LanguageManager.this.plugin.getLogger().log(level, message);
            }

            @Override
            public void log(Level level, String message, Throwable e) {
                LanguageManager.this.plugin.getLogger().log(level, message, e);
            }
        }, locale -> new BukkitLanguageConfig(this.plugin, this.getResourceFolder(), new File(this.getFolder(), this.filePrefix + locale + this.fileSuffix), (String)locale, this.saveFiles));
    }
}

