/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.integrations.votifier;

import com.vexsoftware.votifier.model.Vote;
import com.vexsoftware.votifier.model.VotifierEvent;
import de.themoep.rewards.api.trigger.Trigger;
import de.themoep.rewards.api.trigger.TriggerData;
import de.themoep.rewards.api.trigger.TriggerInfo;
import de.themoep.rewards.api.user.VoteData;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@TriggerInfo(args={"site", "address", "timestamp", "local-timestamp"})
public class VoteTrigger
extends Trigger
implements Listener {
    private final long offlineCacheDuration;

    public VoteTrigger() {
        this.offlineCacheDuration = this.plugin.getConfig().getLong("vote-cache-duration");
    }

    @EventHandler
    public void onVotifierEvent(VotifierEvent event) {
        VoteData voteData = this.createVoteData(event.getVote());
        Player player = this.plugin.getServer().getPlayer(voteData.getUsername());
        if (player != null) {
            this.trigger(player, voteData);
        } else if (this.offlineCacheDuration > 0L && this.isNotTimedOut(voteData)) {
            this.plugin.getUserStorage().addVoteData(voteData);
        }
    }

    private VoteData createVoteData(Vote vote) {
        return new VoteData(vote.getServiceName(), vote.getUsername(), vote.getAddress(), vote.getTimeStamp(), vote.getLocalTimestamp());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        List<VoteData> offlineVotes = this.plugin.getUserStorage().getAndRemoveVoteData(event.getPlayer().getName());
        for (VoteData vote : offlineVotes) {
            if (!this.isNotTimedOut(vote)) continue;
            this.trigger(event.getPlayer(), vote);
        }
    }

    private Trigger.Response trigger(Player player, VoteData vote) {
        return this.trigger(player, new TriggerData("site", vote.getServiceName(), "address", vote.getAddress(), "timestamp", vote.getTimeStamp(), "local-timestamp", String.valueOf(vote.getLocalTimestamp())));
    }

    private boolean isNotTimedOut(VoteData vote) {
        return this.offlineCacheDuration == -1L || System.currentTimeMillis() - this.offlineCacheDuration * 1000L < vote.getLocalTimestamp();
    }
}

