/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.utils;

import de.themoep.rewards.api.RewardsPlugin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemUtils {
    public static ItemStack glow(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta.getEnchants().isEmpty()) {
            meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
        return item;
    }

    public static Map<String, String> getData(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type", itemStack.getType().toString());
        data.put("name", itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : "");
        data.put("durability", meta instanceof Damageable ? String.valueOf(((Damageable)meta).getDamage()) : "");
        data.put("model", meta.hasCustomModelData() ? String.valueOf(meta.getCustomModelData()) : "");
        data.put("id", meta.getPersistentDataContainer().has(RewardsPlugin.getPlugin().getPdcId(), PersistentDataType.STRING) ? (String)meta.getPersistentDataContainer().get(RewardsPlugin.getPlugin().getPdcId(), PersistentDataType.STRING) : "");
        data.put("amount", String.valueOf(itemStack.getAmount()));
        for (NamespacedKey key : meta.getPersistentDataContainer().getKeys()) {
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
                data.put(key.toString(), (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING));
                continue;
            }
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.INTEGER)) {
                data.put(key.toString(), String.valueOf(meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER)));
                continue;
            }
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.LONG)) {
                data.put(key.toString(), String.valueOf(meta.getPersistentDataContainer().get(key, PersistentDataType.LONG)));
                continue;
            }
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.BYTE)) {
                data.put(key.toString(), String.valueOf(meta.getPersistentDataContainer().get(key, PersistentDataType.BYTE)));
                continue;
            }
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.SHORT)) {
                data.put(key.toString(), String.valueOf(meta.getPersistentDataContainer().get(key, PersistentDataType.SHORT)));
                continue;
            }
            data.put(key.toString(), "true");
        }
        return data;
    }

    public static ItemStack buildItem(Object itemDefinition) {
        if (itemDefinition instanceof String) {
            boolean glow = false;
            if (((String)itemDefinition).endsWith("+glow")) {
                glow = true;
                itemDefinition = ((String)itemDefinition).substring(0, ((String)itemDefinition).indexOf(43));
            }
            String[] parts = ((String)itemDefinition).split(":");
            Material mat = Material.valueOf((String)parts[0].toUpperCase());
            ItemStack item = new ItemStack(mat);
            if (parts.length > 1) {
                Damageable damageable = (Damageable)item.getItemMeta();
                damageable.setDamage(Integer.parseInt(parts[1]));
                item.setItemMeta((ItemMeta)damageable);
            }
            if (glow) {
                item = ItemUtils.glow(item);
            }
            return item;
        }
        if (itemDefinition instanceof Map) {
            return ItemUtils.fromMap((Map)itemDefinition);
        }
        if (itemDefinition instanceof ConfigurationSection) {
            return ItemUtils.fromMap(((ConfigurationSection)itemDefinition).getValues(false));
        }
        if (itemDefinition instanceof ItemStack) {
            return (ItemStack)itemDefinition;
        }
        throw new IllegalArgumentException("Unparsable config option for item " + itemDefinition);
    }

    private static ItemStack fromMap(Map<?, ?> itemSection) {
        if (itemSection.get("raw") instanceof ItemStack) {
            return (ItemStack)itemSection.get("raw");
        }
        if (itemSection.get("type") instanceof String) {
            Material mat = Material.matchMaterial((String)((String)itemSection.get("type")));
            if (mat != null) {
                ItemStack item = new ItemStack(mat);
                if (itemSection.get("amount") instanceof Integer) {
                    item.setAmount(((Integer)itemSection.get("amount")).intValue());
                }
                if (itemSection.get("durability") instanceof Integer && item.getItemMeta() instanceof Damageable) {
                    Damageable damageable = (Damageable)item.getItemMeta();
                    damageable.setDamage(((Integer)itemSection.get("damage")).intValue());
                    item.setItemMeta((ItemMeta)damageable);
                }
                if (itemSection.get("model-data") instanceof Integer) {
                    ItemMeta meta = item.getItemMeta();
                    meta.setCustomModelData((Integer)itemSection.get("model-data"));
                    item.setItemMeta(meta);
                }
                if (itemSection.get("pdc") instanceof ConfigurationSection) {
                    PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
                    ConfigurationSection pdcSection = (ConfigurationSection)itemSection.get("pdc");
                    for (String keyString : pdcSection.getKeys(false)) {
                        NamespacedKey key;
                        if (keyString.contains(":")) {
                            String[] parts = keyString.split(":", 1);
                            key = new NamespacedKey(parts[0], parts[1]);
                        } else {
                            key = new NamespacedKey((Plugin)RewardsPlugin.getPlugin(), keyString);
                        }
                        if (pdcSection.isString(keyString)) {
                            pdc.set(key, PersistentDataType.STRING, (Object)pdcSection.getString(keyString));
                            continue;
                        }
                        if (pdcSection.isInt(keyString)) {
                            pdc.set(key, PersistentDataType.INTEGER, (Object)pdcSection.getInt(keyString));
                            continue;
                        }
                        if (pdcSection.isDouble(keyString)) {
                            pdc.set(key, PersistentDataType.DOUBLE, (Object)pdcSection.getDouble(keyString));
                            continue;
                        }
                        if (pdcSection.isLong(keyString)) {
                            pdc.set(key, PersistentDataType.LONG, (Object)pdcSection.getLong(keyString));
                            continue;
                        }
                        if (pdcSection.isBoolean(keyString)) {
                            pdc.set(key, PersistentDataType.BYTE, (Object)(pdcSection.getBoolean(keyString) ? (byte)0 : 1));
                            continue;
                        }
                        throw new IllegalArgumentException("Cannot set pdc to '" + pdcSection.get(keyString, null) + "' for key " + keyString);
                    }
                }
                return item;
            }
            throw new IllegalArgumentException("Unknown material " + itemSection.get("type") + " for item type");
        }
        throw new IllegalArgumentException("Unparsable material " + itemSection.get("type") + " for item type");
    }
}

