/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.utils;

import de.themoep.rewards.api.utils.Holiday;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeParseException;

public class DateTimeUtils {
    public static LocalDate parseDate(String dateString) throws DateTimeParseException {
        LocalDate today = LocalDate.now();
        Holiday holiday = Holiday.get(dateString);
        if (holiday != null) {
            return holiday.getDate(today.getYear());
        }
        return MonthDay.parse(dateString.startsWith("--") ? dateString : "--" + dateString).atYear(today.getYear());
    }

    public static boolean isInRange(String start, String end) throws DateTimeParseException {
        LocalDate today;
        LocalDate startDate = DateTimeUtils.parseDate(start);
        LocalDate endDate = DateTimeUtils.parseDate(end);
        if (endDate.isBefore(startDate)) {
            endDate = endDate.withYear(startDate.getYear() + 1);
        }
        return !startDate.isAfter(today = LocalDate.now()) && !endDate.isBefore(today);
    }
}

