/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.trigger;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.themoep.rewards.api.RewardsPlugin;
import de.themoep.rewards.api.track.Track;
import de.themoep.rewards.api.trigger.TriggerData;
import org.bukkit.entity.Player;

public abstract class Trigger {
    protected final RewardsPlugin plugin = RewardsPlugin.getPlugin();
    private final String name;

    public Trigger() {
        String simpleName = this.getClass().getSimpleName();
        this.name = simpleName.endsWith("Trigger") ? simpleName.substring(0, simpleName.length() - "Trigger".length()) : simpleName;
    }

    protected Response trigger(Player player, TriggerData data) {
        return this.plugin.trigger(player, this.getName(), data);
    }

    public String getName() {
        return this.name;
    }

    public void shutdown() {
    }

    public static class Response {
        private Table<String, String, Track> responses = HashBasedTable.create();

        public void add(Track track, String type, String value) {
            this.responses.put((Object)type, (Object)value, (Object)track);
        }

        public boolean has(String type, String value) {
            return this.responses.contains((Object)type, (Object)value);
        }
    }
}

