/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.utils;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;

public enum Holiday {
    NEW_YEAR(Month.JANUARY, 1, new String[0]),
    EPIPHANY(Month.JANUARY, 6, "three kings day"),
    VALENTINES_DAY(Month.JANUARY, 14, new String[0]),
    GOOD_FRIDAY(year -> Holiday.getEasterSunday(year).minusDays(2L), "holy friday", "great friday", "black friday"),
    EASTER_SUNDAY(Holiday::getEasterSunday, "easter", "pasha", "resurrection sunday"),
    EASTER_MONDAY(year -> Holiday.getEasterSunday(year).plusDays(1L), new String[0]),
    TALK_LIKE_A_PIRATE_DAY(Month.SEPTEMBER, 19, new String[0]),
    CAPS_LOCK_DAY(Month.OCTOBER, 2, new String[0]),
    REFORMATION_DAY(Month.OCTOBER, 31, new String[0]),
    HALLOWEEN(Month.OCTOBER, 31, new String[0]),
    FALL_OF_THE_BERLIN_WALL(Month.NOVEMBER, 9, new String[0]),
    SAINT_NICHOLAS(Month.DECEMBER, 6, new String[0]),
    CHRISTMAS_EVE(Month.DECEMBER, 24, new String[0]),
    CHRISTMAS(Month.DECEMBER, 25, new String[0]),
    BOXING_DAY(Month.DECEMBER, 26, new String[0]),
    NEW_YEARS_EVE(Month.DECEMBER, 31, new String[0]);

    private final Function<Integer, LocalDate> function;
    private final Set<String> aliases;

    private Holiday(Month month, int day, String ... aliases) {
        this((Integer year) -> MonthDay.of(month, day).atYear((int)year), aliases);
    }

    private Holiday(Function<Integer, LocalDate> function, String ... aliases) {
        this.function = function;
        this.aliases = new HashSet<String>(Arrays.asList(aliases));
    }

    public LocalDate getDate(int year) {
        return this.function.apply(year);
    }

    public static Holiday get(String input) {
        try {
            return Holiday.valueOf(input.toUpperCase(Locale.ROOT).replace(' ', '_'));
        }
        catch (IllegalArgumentException e) {
            for (Holiday holiday : Holiday.values()) {
                if (!holiday.aliases.contains(input.toLowerCase(Locale.ROOT).replace('_', ' '))) continue;
                return holiday;
            }
            return null;
        }
    }

    private static LocalDate getEasterSunday(int year) {
        int a = (int)Math.floor(year % 19);
        int b = (int)Math.floor((double)year / 100.0);
        int c = (int)Math.floor(year % 100);
        int d = (int)Math.floor((double)b / 4.0);
        int e = (int)Math.floor(b % 4);
        int f = (int)Math.floor((double)(b + 8) / 25.0);
        int g = (int)Math.floor((double)(b - f + 1) / 3.0);
        int h = (int)Math.floor((19 * a + b - d - g + 15) % 30);
        int i = (int)Math.floor((double)c / 4.0);
        int k = (int)Math.floor(c % 4);
        int l = (int)Math.floor((32 + 2 * e + 2 * i - h - k) % 7);
        int m = (int)Math.floor((double)(a + 11 * h + 22 * l) / 451.0);
        int n = h + l - 7 * m + 114;
        int month = (int)Math.floor((double)n / 31.0);
        int day = (int)Math.floor(n % 31 + 1);
        return LocalDate.of(year, month, day);
    }
}

