/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.trigger;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class TriggerArgument {
    private String rawArgument;
    private Pattern pattern;

    public TriggerArgument(String argumentString) {
        this.rawArgument = argumentString;
        try {
            this.pattern = Pattern.compile(argumentString);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public boolean matches(String providedValue) {
        if (providedValue.equalsIgnoreCase(this.rawArgument)) {
            return true;
        }
        return this.isRegex() && this.pattern.matcher(providedValue).matches();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isRegex() {
        return this.pattern != null;
    }

    public String getRawArgument() {
        return this.rawArgument;
    }

    public String toString() {
        return "TriggerArgument{rawArgument='" + this.rawArgument + '\'' + ", pattern=" + this.pattern + '}';
    }
}

