/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.track;

import de.themoep.rewards.api.track.Reward;
import de.themoep.rewards.api.utils.ItemUtils;
import de.themoep.rewards.api.utils.SoundInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class TrackLevel {
    private final int id;
    private final ItemStack icon;
    private final int required;
    private final List<Reward> rewards = new ArrayList<Reward>();
    private final SoundInfo sound;

    public TrackLevel() {
        this.id = 0;
        this.required = 0;
        this.icon = null;
        this.sound = null;
    }

    public TrackLevel(int id, ConfigurationSection config) {
        this.id = id;
        this.icon = config.contains("icon", true) ? ItemUtils.buildItem(config.get("icon")) : null;
        this.sound = config.contains("reward-sound", true) ? (config.isConfigurationSection("reward-sound") ? new SoundInfo(config.getString("reward-sound.sound"), (float)config.getDouble("reward-sound.volume", 1.0), (float)config.getDouble("reward-sound.pitch", 1.0)) : new SoundInfo(config.getString("reward-sound"))) : null;
        this.required = config.getInt("required", id);
        for (Map map : config.getMapList("rewards")) {
            this.rewards.add(new Reward(map));
        }
    }

    public int getId() {
        return this.id;
    }

    public SoundInfo getSound() {
        return this.sound;
    }

    public int getRequired() {
        return this.required;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public ItemStack getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        for (Reward reward : this.getRewards()) {
            if (reward.getIcon() == null) continue;
            return reward.getIcon();
        }
        return null;
    }

    public String toString() {
        return "TrackLevel{id=" + this.id + ", icon=" + this.icon + ", required=" + this.required + ", rewards=" + this.rewards + ", sound=" + this.sound + '}';
    }
}

