/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.track;

import de.themoep.minedown.Replacer;
import de.themoep.rewards.api.RewardsPlugin;
import de.themoep.rewards.api.track.TrackLevel;
import de.themoep.rewards.api.trigger.TriggerArgument;
import de.themoep.rewards.api.trigger.TriggerData;
import de.themoep.rewards.api.utils.DateTimeUtils;
import de.themoep.rewards.api.utils.ItemUtils;
import de.themoep.rewards.api.utils.SoundInfo;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class Track {
    private final String id;
    private final String permission;
    private final ItemStack icon;
    private final SoundInfo sound;
    private final boolean reset;
    private final String start;
    private final String end;
    private final Map<String, TriggerConfig> triggers = new HashMap<String, TriggerConfig>();
    private final List<TrackLevel> levels = new ArrayList<TrackLevel>();

    public Track(String id, ConfigurationSection config) throws IllegalArgumentException {
        this.id = id.toLowerCase(Locale.ROOT);
        this.permission = "rewards.track." + this.id;
        this.reset = config.getBoolean("reset", false);
        this.start = config.getString("start", "");
        this.end = config.getString("end", "");
        this.icon = config.contains("icon", true) ? ItemUtils.buildItem(config.get("icon")) : null;
        this.sound = config.contains("reward-sound", true) ? (config.isConfigurationSection("reward-sound") ? new SoundInfo(config.getString("reward-sound.sound"), (float)config.getDouble("reward-sound.volume", 1.0), (float)config.getDouble("reward-sound.pitch", 1.0)) : new SoundInfo(config.getString("reward-sound"))) : null;
        if (!config.contains("triggers", true)) {
            throw new IllegalArgumentException("No triggers set!");
        }
        if (config.isConfigurationSection("triggers")) {
            ConfigurationSection triggersSection = config.getConfigurationSection("triggers");
            for (String trigger : triggersSection.getKeys(false)) {
                if (!triggersSection.isConfigurationSection(trigger)) continue;
                ConfigurationSection triggerSection = triggersSection.getConfigurationSection(trigger);
                if (triggerSection.contains("type", true)) {
                    Map<String, String> responses;
                    Map<String, TriggerArgument> triggerArgs;
                    String triggerType = triggerSection.getString("type").toLowerCase();
                    if (triggerSection.contains("args", true) && triggerSection.isConfigurationSection("args")) {
                        triggerArgs = new HashMap();
                        ConfigurationSection argsSection = triggerSection.getConfigurationSection("args");
                        for (Object key : argsSection.getKeys(false)) {
                            triggerArgs.put(((String)key).toLowerCase(Locale.ROOT), new TriggerArgument(argsSection.getString((String)key)));
                        }
                    } else {
                        triggerArgs = Collections.emptyMap();
                    }
                    if (triggerSection.contains("responses", true) && triggerSection.isConfigurationSection("responses")) {
                        Object key;
                        responses = new HashMap();
                        ConfigurationSection argsSection = triggerSection.getConfigurationSection("responses");
                        key = argsSection.getKeys(false).iterator();
                        while (key.hasNext()) {
                            String key2 = (String)key.next();
                            responses.put(key2.toLowerCase(Locale.ROOT), argsSection.getString(key2));
                        }
                    } else {
                        responses = Collections.emptyMap();
                    }
                    String frequency = "";
                    if (triggerSection.contains("frequency", true) && triggerSection.isString("frequency")) {
                        frequency = triggerSection.getString("frequency").toLowerCase(Locale.ROOT);
                    }
                    String at = "";
                    if (triggerSection.contains("at", true) && triggerSection.isString("at")) {
                        at = triggerSection.getString("at").toLowerCase(Locale.ROOT);
                    }
                    String start = "";
                    if (triggerSection.contains("start", true) && triggerSection.isString("start")) {
                        start = triggerSection.getString("start").toLowerCase(Locale.ROOT);
                    }
                    String end = "";
                    if (triggerSection.contains("end", true) && triggerSection.isString("end")) {
                        end = triggerSection.getString("end").toLowerCase(Locale.ROOT);
                    }
                    String points = "";
                    if (triggerSection.contains("points", true)) {
                        points = triggerSection.getString("points");
                    }
                    this.triggers.put(triggerType, new TriggerConfig(triggerArgs, responses, frequency, at, start, end, points));
                    continue;
                }
                throw new IllegalArgumentException("No type for trigger " + trigger + " set!");
            }
        } else {
            throw new IllegalArgumentException("No triggers set!");
        }
        if (!config.contains("levels", true) || !config.isConfigurationSection("levels")) {
            throw new IllegalArgumentException("No levels set!");
        }
        ConfigurationSection rewardsSection = config.getConfigurationSection("levels");
        int i = 1;
        while (rewardsSection.contains("level" + i, true)) {
            this.levels.add(new TrackLevel(i, rewardsSection.getConfigurationSection("level" + i)));
            ++i;
        }
    }

    public String toString() {
        return "Track{id='" + this.id + '\'' + ", permission='" + this.permission + '\'' + ", icon=" + this.icon + ", sound=" + this.sound + ", reset=" + this.reset + ", start=" + this.start + ", end=" + this.end + ", triggers=" + this.triggers + ", levels=" + this.levels + '}';
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Map<String, TriggerConfig> getTriggers() {
        return this.triggers;
    }

    public TriggerConfig getTriggerConfig(String triggerId) {
        return this.getTriggers().get(triggerId.toLowerCase());
    }

    public int getPoints(String triggerId, TriggerData data) {
        TriggerConfig config = this.getTriggerConfig(triggerId);
        if (config != null && config.getPoints() != null && !config.getPoints().isEmpty()) {
            String points = new Replacer().replace(data.asMap()).replace(new String[]{"points", String.valueOf(data.getPoints())}).replaceIn(config.getPoints());
            try {
                return Integer.parseInt(points);
            }
            catch (NumberFormatException e) {
                RewardsPlugin.getPlugin().getLogger().log(Level.WARNING, "Track " + this.getId() + " has a wrong points configuration for trigger " + triggerId + ": " + e.getMessage());
            }
        }
        return data.getPoints();
    }

    public String getId() {
        return this.id;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public boolean canAccess(CommandSender sender) {
        if (!sender.hasPermission(this.getPermission())) {
            return false;
        }
        if (this.getStart() != null && !this.getStart().isEmpty() && this.getEnd() != null && !this.getEnd().isEmpty()) {
            try {
                if (!DateTimeUtils.isInRange(this.getStart(), this.getEnd())) {
                    return false;
                }
            }
            catch (DateTimeParseException e) {
                RewardsPlugin.getPlugin().getLogger().log(Level.SEVERE, "Start or End dates are not a valid MonthDay in track " + this.id + "! Config: " + this.toString(), e);
            }
        }
        return true;
    }

    public boolean isTriggered(String triggerId, Map<String, String> argsMap) {
        TriggerConfig triggerConfig = this.getTriggerConfig(triggerId);
        if (triggerConfig != null) {
            if (!argsMap.keySet().containsAll(triggerConfig.triggerArgs.keySet())) {
                return false;
            }
            if (triggerConfig.getAt() != null && !triggerConfig.getAt().isEmpty()) {
                boolean matches = false;
                for (String at : triggerConfig.getAt().split(",")) {
                    try {
                        LocalDate date = DateTimeUtils.parseDate(at);
                        LocalDate today = LocalDate.now();
                        if (!date.isEqual(today)) continue;
                        matches = true;
                        break;
                    }
                    catch (DateTimeParseException e) {
                        RewardsPlugin.getPlugin().getLogger().log(Level.SEVERE, "At date " + at + " is not a valid MonthDay in trigger " + triggerId + "! Config: " + triggerConfig, e);
                    }
                }
                if (!matches) {
                    return false;
                }
            }
            if (triggerConfig.getStart() != null && !triggerConfig.getStart().isEmpty() && triggerConfig.getEnd() != null && !triggerConfig.getEnd().isEmpty()) {
                try {
                    if (!DateTimeUtils.isInRange(triggerConfig.getStart(), triggerConfig.getEnd())) {
                        return false;
                    }
                }
                catch (DateTimeParseException e) {
                    RewardsPlugin.getPlugin().getLogger().log(Level.SEVERE, "Start or End dates are not a valid MonthDay in trigger " + triggerId + "! Config: " + triggerConfig, e);
                }
            }
            for (Map.Entry arg : triggerConfig.triggerArgs.entrySet()) {
                if (((TriggerArgument)arg.getValue()).matches(argsMap.get(arg.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<TrackLevel> getLevels() {
        return this.levels;
    }

    public TrackLevel getLevel(int points) {
        TrackLevel previous = null;
        for (TrackLevel level : this.getLevels()) {
            if (level.getRequired() > points) {
                return previous;
            }
            previous = level;
        }
        return previous;
    }

    public ItemStack getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        for (TrackLevel level : this.getLevels()) {
            ItemStack icon = level.getIcon();
            if (icon == null) continue;
            return icon;
        }
        return new ItemStack(Material.DIAMOND);
    }

    public SoundInfo getSound() {
        if (this.sound != null) {
            return this.sound;
        }
        for (TrackLevel level : this.getLevels()) {
            SoundInfo sound = level.getSound();
            if (sound == null) continue;
            return sound;
        }
        return null;
    }

    public static class TriggerConfig {
        private Map<String, TriggerArgument> triggerArgs;
        private final Map<String, String> responses;
        private final String frequency;
        private final String at;
        private final String start;
        private final String end;
        private final String points;

        private TriggerConfig(Map<String, TriggerArgument> triggerArgs, Map<String, String> responses, String frequency, String at, String start, String end, String points) {
            this.triggerArgs = triggerArgs;
            this.responses = responses;
            this.frequency = frequency;
            this.at = at;
            this.start = start;
            this.end = end;
            this.points = points;
        }

        public String getFrequency() {
            return this.frequency;
        }

        public String getAt() {
            return this.at;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public String getPoints() {
            return this.points;
        }

        public Map<String, String> getResponses() {
            return this.responses;
        }

        public String toString() {
            return "TriggerConfig{triggerArgs=" + this.triggerArgs + ", responses=" + this.responses + ", frequency='" + this.frequency + '\'' + ", at='" + this.at + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", points='" + this.points + '\'' + '}';
        }
    }
}

