/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.rewards.api.track;

import de.themoep.rewards.api.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class Reward {
    private final double money;
    private final ItemStack item;
    private final ItemStack icon;
    private final List<String> commands = new ArrayList<String>();
    private String permission = null;
    private String unlock = null;

    public Reward(Map<?, ?> config) throws IllegalArgumentException {
        this.icon = config.containsKey("icon") ? ItemUtils.buildItem(config.get("icon")) : null;
        this.item = config.containsKey("item") ? ItemUtils.buildItem(config.get("item")) : null;
        if (config.get("command") instanceof String) {
            this.commands.add((String)config.get("command"));
        }
        if (config.get("commands") instanceof List) {
            this.commands.addAll((Collection)config.get("commands"));
        }
        this.money = config.get("money") instanceof Double ? (Double)config.get("money") : 0.0;
        if (config.get("requires") instanceof Map) {
            Map requirements = (Map)config.get("requires");
            if (requirements.get("permission") instanceof String) {
                this.permission = (String)requirements.get("permission");
            }
            if (requirements.get("unlock") instanceof String) {
                this.unlock = (String)requirements.get("unlock");
            }
        }
    }

    public double getMoney() {
        return this.money;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getIcon() {
        return this.icon != null ? this.icon : this.item;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getUnlock() {
        return this.unlock;
    }

    public String toString() {
        return "Reward{money=" + this.money + ", item=" + this.item + ", icon=" + this.icon + ", commands=" + this.commands + ", permission='" + this.permission + '\'' + ", unlock='" + this.unlock + '\'' + '}';
    }
}

