/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.listeners;

import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuthHandler {
    private final WorldResourcepacks plugin;

    public AuthHandler(WorldResourcepacks plugin) {
        this.plugin = plugin;
    }

    public void onAuth(Player player, boolean sendToProxy) {
        if (!this.plugin.isEnabled() || player == null) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("use-auth-plugin", this.plugin.getConfig().getBoolean("useauth", false))) {
            long sendDelay = this.plugin.getPackManager().getAssignment(player.getWorld().getName()).getSendDelay();
            if (sendDelay < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            this.plugin.logDebug(player.getName() + " authenticated! Sending pack in " + sendDelay + " ticks...");
            ResourcepacksPlayer rpPlayer = this.plugin.getPlayer(player);
            if (sendDelay > 0L) {
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getPackManager().applyPack(rpPlayer, player.getWorld().getName()), sendDelay);
            } else {
                this.plugin.getPackManager().applyPack(rpPlayer, player.getWorld().getName());
            }
        }
        if (sendToProxy) {
            this.plugin.getMessageChannelHandler().sendMessage(player, "authLogin", out -> {
                out.writeUTF(player.getName());
                out.writeUTF(player.getUniqueId().toString());
            });
        }
    }
}

