/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity;

import de.themoep.resourcepacksplugin.velocity.VelocityResourcepacks;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class PluginConfig {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final VelocityResourcepacks plugin;
    private final File configFile;
    private final String defaultFile;
    private final YamlConfigurationLoader configLoader;
    private ConfigurationNode config;
    private ConfigurationNode defaultConfig;

    public PluginConfig(VelocityResourcepacks plugin, File configFile) {
        this(plugin, configFile, configFile.getName());
    }

    public PluginConfig(VelocityResourcepacks plugin, File configFile, String defaultFile) {
        this.plugin = plugin;
        this.configFile = configFile;
        this.defaultFile = defaultFile;
        this.configLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).path(configFile.toPath())).nodeStyle(NodeStyle.BLOCK).build();
    }

    public boolean load() {
        try {
            this.config = this.configLoader.load();
            if (this.defaultFile != null) {
                this.defaultConfig = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).source(() -> new BufferedReader(new InputStreamReader(this.plugin.getResourceAsStream(this.defaultFile))))).build().load();
                if (this.config.empty()) {
                    this.config = this.defaultConfig.copy();
                }
            }
            this.plugin.log(Level.INFO, "Loaded " + this.configFile.getName());
            return true;
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "Unable to load configuration file " + this.configFile.getName(), e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createDefaultConfig() throws IOException {
        block14: {
            try (InputStream in = this.plugin.getResourceAsStream(this.defaultFile);){
                if (in == null) {
                    this.plugin.log(Level.WARNING, "No default config '" + this.defaultFile + "' found in " + this.plugin.getName() + "!");
                    boolean bl = false;
                    return bl;
                }
                if (this.configFile.exists()) break block14;
                File parent = this.configFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.log(Level.SEVERE, "Could not save " + this.configFile.getName() + " to " + String.valueOf(this.configFile), ex);
                }
            }
            catch (IOException ex) {
                this.plugin.log(Level.SEVERE, "Could not load default config from " + this.defaultFile, ex);
            }
        }
        return false;
    }

    public void save() {
        try {
            this.configLoader.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object set(String path, Object value) {
        ConfigurationNode node = this.config.node(PluginConfig.splitPath(path));
        Object prev = node.raw();
        try {
            node.set(value);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return prev;
    }

    public ConfigurationNode remove(String path) {
        ConfigurationNode node = this.config.node(PluginConfig.splitPath(path));
        try {
            return node.virtual() ? node : node.set(null);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationNode getRawConfig() {
        return this.config;
    }

    public ConfigurationNode getRawConfig(String path) {
        return this.getRawConfig().node(PluginConfig.splitPath(path));
    }

    public boolean has(String path) {
        return !this.getRawConfig(path).virtual();
    }

    public boolean isSection(String path) {
        return !this.getRawConfig(path).childrenMap().isEmpty();
    }

    public Map<String, Object> getSection(String key) {
        return PluginConfig.getConfigMap(this.getRawConfig(key));
    }

    public int getInt(String path) {
        return this.getInt(path, this.defaultConfig != null ? this.defaultConfig.node(PluginConfig.splitPath(path)).getInt() : 0);
    }

    public int getInt(String path, int def) {
        return this.getRawConfig(path).getInt(def);
    }

    public double getDouble(String path) {
        return this.getDouble(path, this.defaultConfig != null ? this.defaultConfig.node(PluginConfig.splitPath(path)).getDouble() : 0.0);
    }

    public double getDouble(String path, double def) {
        return this.getRawConfig(path).getDouble(def);
    }

    public String getString(String path) {
        return this.getString(path, this.defaultConfig != null ? this.defaultConfig.node(PluginConfig.splitPath(path)).getString() : null);
    }

    public String getString(String path, String def) {
        ConfigurationNode node = this.getRawConfig(path);
        if (def != null) {
            return node.getString(def);
        }
        return node.getString();
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, this.defaultConfig != null && this.defaultConfig.node(PluginConfig.splitPath(path)).getBoolean());
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getRawConfig(path).getBoolean(def);
    }

    private static Object[] splitPath(String key) {
        return PATH_PATTERN.split(key);
    }

    public static Map<String, Object> getConfigMap(Object configuration) {
        if (configuration instanceof Map) {
            return PluginConfig.getValues((Map)configuration);
        }
        if (configuration instanceof ConfigurationNode) {
            return PluginConfig.getValues((ConfigurationNode)configuration);
        }
        return null;
    }

    private static Map<String, Object> getValues(ConfigurationNode config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : config.childrenMap().entrySet()) {
            String key = String.valueOf(entry.getKey());
            ConfigurationNode value = (ConfigurationNode)entry.getValue();
            if (value.isMap()) {
                map.put(key, PluginConfig.getValues(value));
                continue;
            }
            map.put(key, value.raw());
        }
        return map;
    }

    private static Map<String, Object> getValues(Map<?, ?> map) {
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (entry.getValue() instanceof Map) {
                returnMap.put(key, PluginConfig.getValues((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof ConfigurationNode) {
                returnMap.put(key, PluginConfig.getValues((ConfigurationNode)entry.getValue()));
                continue;
            }
            returnMap.put(key, entry.getValue());
        }
        return returnMap;
    }
}

