/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.listeners;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.velocity.VelocityResourcepacks;
import java.util.concurrent.TimeUnit;

public class AuthHandler {
    protected final VelocityResourcepacks plugin;

    public AuthHandler(VelocityResourcepacks plugin) {
        this.plugin = plugin;
    }

    public void onAuth(Player player) {
        if (!this.plugin.isEnabled() || player == null) {
            return;
        }
        this.plugin.setAuthenticated(player.getUniqueId(), true);
        if (!this.plugin.hasBackend(player.getUniqueId()) && this.plugin.getConfig().getBoolean("use-auth-plugin", this.plugin.getConfig().getBoolean("useauth", false))) {
            long sendDelay;
            String serverName = "";
            if (player.getCurrentServer().isPresent()) {
                serverName = ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName();
            }
            if ((sendDelay = this.plugin.getPackManager().getAssignment(serverName).getSendDelay()) < 0L) {
                sendDelay = this.plugin.getPackManager().getGlobalAssignment().getSendDelay();
            }
            this.plugin.logDebug(player.getUsername() + " authenticated on the backend server " + serverName + "! Sending pack in " + sendDelay + " ticks...");
            ResourcepacksPlayer rpPlayer = this.plugin.getPlayer(player);
            if (sendDelay > 0L) {
                String finalServerName = serverName;
                this.plugin.getProxy().getScheduler().buildTask((Object)this.plugin, () -> this.plugin.getPackManager().applyPack(rpPlayer, finalServerName)).delay(sendDelay * 20L, TimeUnit.MILLISECONDS).schedule();
            } else {
                this.plugin.getPackManager().applyPack(rpPlayer, serverName);
            }
        }
    }
}

