/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity;

import com.google.common.io.ByteArrayDataOutput;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.ProxyVersion;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.PlatformType;
import de.themoep.resourcepacksplugin.core.PluginLogger;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResetPackCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResourcepacksPluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.UsePackCommandExecutor;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import de.themoep.resourcepacksplugin.libs.minedown.adventure.MineDown;
import de.themoep.resourcepacksplugin.velocity.ForwardingCommand;
import de.themoep.resourcepacksplugin.velocity.PluginConfig;
import de.themoep.resourcepacksplugin.velocity.VelocityPluginLogger;
import de.themoep.resourcepacksplugin.velocity.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.velocity.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.velocity.integrations.FloodgateIntegration;
import de.themoep.resourcepacksplugin.velocity.integrations.GeyserIntegration;
import de.themoep.resourcepacksplugin.velocity.integrations.ViaVersionIntegration;
import de.themoep.resourcepacksplugin.velocity.libs.lang.LangLogger;
import de.themoep.resourcepacksplugin.velocity.libs.lang.LanguageConfig;
import de.themoep.resourcepacksplugin.velocity.libs.lang.velocity.LanguageManager;
import de.themoep.resourcepacksplugin.velocity.libs.lang.velocity.Languaged;
import de.themoep.resourcepacksplugin.velocity.libs.lang.velocity.VelocityLanguageConfig;
import de.themoep.resourcepacksplugin.velocity.listeners.AuthMeVelocityListener;
import de.themoep.resourcepacksplugin.velocity.listeners.ConnectListener;
import de.themoep.resourcepacksplugin.velocity.listeners.CurrentServerTracker;
import de.themoep.resourcepacksplugin.velocity.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.velocity.listeners.JPremiumListener;
import de.themoep.resourcepacksplugin.velocity.listeners.LibreLoginListener;
import de.themoep.resourcepacksplugin.velocity.listeners.LibrePremiumListener;
import de.themoep.resourcepacksplugin.velocity.listeners.NLoginListener;
import de.themoep.resourcepacksplugin.velocity.listeners.PluginMessageListener;
import de.themoep.resourcepacksplugin.velocity.listeners.ServerSwitchListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.slf4j.Logger;

public class VelocityResourcepacks
implements ResourcepacksPlugin,
Languaged {
    private final ProxyServer proxy;
    private final VelocityPluginLogger logger;
    private final File dataFolder;
    private PluginContainer ownContainer = null;
    private PluginConfig config;
    private PluginConfig storedPacks;
    private PackManager pm = new PackManager(this);
    private UserManager um;
    private LanguageManager lm;
    private Level loglevel = Level.INFO;
    protected ResourcepacksPluginCommandExecutor pluginCommand;
    private Map<UUID, Boolean> backendPackedPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private Set<UUID> authenticatedPlayers = new HashSet<UUID>();
    private boolean enabled = false;
    private ViaVersionIntegration viaApi;
    private GeyserIntegration geyser;
    private FloodgateIntegration floodgate;
    private PluginMessageListener messageChannelHandler;
    private CurrentServerTracker serverTracker;

    @Inject
    public VelocityResourcepacks(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = new VelocityPluginLogger(logger);
        this.dataFolder = dataFolder.toFile();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        block9: {
            block8: {
                try {
                    Class.forName("org.spongepowered.configurate.ConfigurationNode");
                }
                catch (ClassNotFoundException e) {
                    ProxyVersion version = this.getProxy().getVersion();
                    this.log(Level.SEVERE, "\nYou are running an outdated version of Velocity! Update to at least Velocity 3.3.0!\n");
                    this.log(Level.SEVERE, this.getName() + " " + this.getVersion() + " is not compatible with " + version.getName() + " " + version.getVersion() + "!\n");
                    this.log(Level.SEVERE, "Disabling plugin!");
                    return;
                }
                boolean firstStart = !this.getDataFolder().exists();
                this.messageChannelHandler = new PluginMessageListener(this);
                if (!this.loadConfig()) {
                    return;
                }
                this.setEnabled(true);
                this.pluginCommand = new ResourcepacksPluginCommandExecutor(this);
                this.registerCommand(this.pluginCommand);
                this.registerCommand(new UsePackCommandExecutor(this));
                this.registerCommand(new ResetPackCommandExecutor(this));
                this.getProxy().getPluginManager().getPlugin("viaversion").ifPresent(c -> {
                    try {
                        this.viaApi = new ViaVersionIntegration(this, (PluginContainer)c);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " hook", e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("geyser").ifPresent(c -> {
                    try {
                        this.geyser = new GeyserIntegration(this, (PluginContainer)c);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " hook", e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("floodgate").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        this.floodgate = new FloodgateIntegration(this, (PluginContainer)c);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " hook", e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("authmevelocity").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        this.getProxy().getEventManager().register((Object)this, (Object)new AuthMeVelocityListener(this));
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""), e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("nlogin").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        this.getProxy().getEventManager().register((Object)this, (Object)new NLoginListener(this));
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""), e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("jpremium").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        this.getProxy().getEventManager().register((Object)this, (Object)new JPremiumListener(this));
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""), e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("librepremium").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        new LibrePremiumListener(this, (PluginContainer)c);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " hook", e);
                    }
                });
                this.getProxy().getPluginManager().getPlugin("librelogin").ifPresent(c -> {
                    this.log(Level.INFO, "Detected " + c.getDescription().getName().orElse(c.getDescription().getId()) + " " + c.getDescription().getVersion().orElse(""));
                    try {
                        new LibreLoginListener(this, (PluginContainer)c);
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "Could not create " + c.getDescription().getName().orElse(c.getDescription().getId()) + " hook", e);
                    }
                });
                if (this.isEnabled() && this.getConfig().getBoolean("autogeneratehashes", true)) {
                    this.getPackManager().generateHashes(null);
                }
                this.um = new UserManager(this);
                this.serverTracker = new CurrentServerTracker(this);
                this.getProxy().getEventManager().register((Object)this, (Object)this.serverTracker);
                this.getProxy().getEventManager().register((Object)this, (Object)new ConnectListener(this));
                this.getProxy().getEventManager().register((Object)this, (Object)new DisconnectListener(this));
                this.getProxy().getEventManager().register((Object)this, (Object)new ServerSwitchListener(this));
                this.getProxy().getEventManager().register((Object)this, (Object)this.messageChannelHandler);
                this.getProxy().getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.create((String)"rp", (String)"plugin")});
                if (!this.getConfig().getBoolean("disable-metrics", false)) {
                    // empty if block
                }
                if (firstStart) break block8;
                Random random = new Random();
                if (!(random.nextDouble() < 0.01)) break block9;
            }
            this.startupMessage();
        }
    }

    protected void registerCommand(PluginCommandExecutor executor) {
        this.getProxy().getCommandManager().register(this.getProxy().getCommandManager().metaBuilder(executor.getName()).aliases(executor.getAliases()).build(), (Command)new ForwardingCommand(executor));
    }

    @Override
    public boolean loadConfig() {
        String debugString;
        this.log(Level.INFO, "Loading config!");
        this.config = new PluginConfig(this, new File(this.getDataFolder(), "config.yml"), "velocity-config.yml");
        try {
            this.config.createDefaultConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (!this.config.load()) {
            return false;
        }
        this.storedPacks = new PluginConfig(this, new File(this.getDataFolder(), "players.conf"), null);
        if (!this.storedPacks.load()) {
            this.log(Level.SEVERE, "Unable to load players.conf! Stored player packs will not apply!");
        }
        if ((debugString = this.getConfig().getString("debug", "true")).equalsIgnoreCase("true")) {
            this.loglevel = Level.INFO;
        } else if (debugString.equalsIgnoreCase("false")) {
            this.loglevel = Level.FINE;
        } else {
            try {
                this.loglevel = Level.parse(debugString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log(Level.SEVERE, "Wrong config value for debug! To disable debugging just set it to \"false\"! (" + e.getMessage() + ")");
            }
        }
        this.log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        this.messageChannelHandler.reload();
        if (this.getConfig().getBoolean("use-auth-plugin", this.getConfig().getBoolean("useauth", false))) {
            this.log(Level.INFO, "Compatibility with backend authentication plugin ('use-auth-plugin') is enabled.");
        }
        this.lm = new LanguageManager((Languaged)this, this.getConfig().getString("default-language"), new VelocityLanguageConfig[0]);
        this.getPackManager().init();
        if (this.getConfig().isSection("packs")) {
            this.log(Level.INFO, "Loading packs:");
            Map<String, Object> packs = this.getConfig().getSection("packs");
            for (Map.Entry<String, Object> s : packs.entrySet()) {
                Object packSection = s.getValue();
                try {
                    ResourcePack pack = this.getPackManager().loadPack(s.getKey(), this.getConfigMap(packSection));
                    this.log(Level.INFO, pack.getName() + " - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                    ResourcePack previous = this.getPackManager().addPack(pack);
                    if (previous != null) {
                        this.log(Level.WARNING, "Multiple resource packs with name '" + previous.getName().toLowerCase() + "' found!");
                    }
                    this.logDebug(pack.serialize().toString());
                }
                catch (IllegalArgumentException e) {
                    this.log(Level.SEVERE, "Error while loading pack " + String.valueOf(s), e);
                }
            }
        } else {
            this.logDebug("No packs defined!");
        }
        if (this.getConfig().isSection("empty")) {
            Map<String, Object> packSection = this.getConfig().getSection("empty");
            try {
                ResourcePack pack = this.getPackManager().loadPack("empty", this.getConfigMap(packSection));
                this.log(Level.INFO, "Empty pack - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                this.getPackManager().addPack(pack);
                this.getPackManager().setEmptyPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.log(Level.SEVERE, "Error while loading empty pack", e);
            }
        } else {
            String emptypackname = this.getConfig().getString("empty");
            if (emptypackname != null && !emptypackname.isEmpty()) {
                ResourcePack ep = this.getPackManager().getByName(emptypackname);
                if (ep != null) {
                    this.log(Level.INFO, "Empty pack: " + ep.getName());
                    this.getPackManager().setEmptyPack(ep);
                } else {
                    this.log(Level.WARNING, "Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
                }
            } else {
                this.log(Level.WARNING, "No empty pack defined!");
            }
        }
        if (this.getConfig().isSection("global")) {
            this.log(Level.INFO, "Loading global assignment...");
            Map<String, Object> globalSection = this.getConfig().getSection("global");
            PackAssignment globalAssignment = this.getPackManager().loadAssignment("global", globalSection);
            this.getPackManager().setGlobalAssignment(globalAssignment);
            this.logDebug("Loaded " + globalAssignment.toString());
        } else {
            this.logDebug("No global assignment defined!");
        }
        if (this.getConfig().isSection("servers")) {
            this.log(Level.INFO, "Loading server assignments...");
            Map<String, Object> servers = this.getConfig().getSection("servers");
            for (Map.Entry<String, Object> server : servers.entrySet()) {
                Object serverSection = server.getValue();
                if (serverSection instanceof Map) {
                    this.log(Level.INFO, "Loading assignment for server " + server.getKey() + "...");
                    PackAssignment serverAssignment = this.getPackManager().loadAssignment(server.getKey(), (Map)serverSection);
                    this.getPackManager().addAssignment(serverAssignment);
                    this.logDebug("Loaded server assignment " + serverAssignment.toString());
                    continue;
                }
                this.log(Level.WARNING, "Config has entry for server " + server.getKey() + " but it is not a configuration section?");
            }
        } else {
            this.logDebug("No server assignments defined!");
        }
        this.getPackManager().setStoredPacksOverride(this.getConfig().getBoolean("stored-packs-override-assignments"));
        this.logDebug("Stored packs override assignments: " + this.getPackManager().getStoredPacksOverride());
        this.getPackManager().setAppendHashToUrl(this.getConfig().getBoolean("append-hash-to-url"));
        this.logDebug("Append hash to pack URL: " + this.getPackManager().shouldAppendHashToUrl());
        return true;
    }

    @Override
    public Map<String, Object> getConfigMap(Object configuration) {
        return PluginConfig.getConfigMap(configuration);
    }

    @Override
    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.log(Level.INFO, "Resending packs for all online players!");
            this.getUserManager().clearUserPacks();
            for (Player p : this.getProxy().getAllPlayers()) {
                this.resendPack(p);
            }
        }
    }

    @Override
    public void saveConfigChanges() {
        this.getConfig().set("packs", null);
        for (ResourcePack resourcePack : this.getPackManager().getPacks()) {
            Object path = "packs." + resourcePack.getName();
            if (resourcePack.equals(this.getPackManager().getEmptyPack()) && this.getConfig().isSection("empty")) {
                path = "empty";
            }
            this.setConfigFlat((String)path, resourcePack.serialize());
        }
        this.setConfigFlat(this.getPackManager().getGlobalAssignment().getName(), this.getPackManager().getGlobalAssignment().serialize());
        for (PackAssignment packAssignment : this.getPackManager().getAssignments()) {
            this.setConfigFlat("servers." + packAssignment.getName(), packAssignment.serialize());
        }
        this.getConfig().save();
    }

    private boolean setConfigFlat(String rootKey, Map<String, Object> map) {
        boolean isEmpty = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                isEmpty &= this.setConfigFlat(rootKey + "." + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof List) {
                ((List)entry.getValue()).removeIf(e -> {
                    if (e instanceof Map) {
                        ((Map)e).entrySet().removeIf(le -> le.getValue() == null);
                        return ((Map)e).isEmpty();
                    }
                    return false;
                });
            }
            this.getConfig().set(rootKey + "." + entry.getKey(), entry.getValue());
            if (entry.getValue() == null || entry.getValue() instanceof Collection && ((Collection)entry.getValue()).isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            this.getConfig().remove(rootKey);
        }
        return isEmpty;
    }

    @Override
    public void setStoredPack(UUID playerId, String packName) {
        if (this.storedPacks != null) {
            this.storedPacks.set("players." + String.valueOf(playerId), packName);
            this.storedPacks.save();
        }
    }

    @Override
    public String getStoredPack(UUID playerId) {
        return this.storedPacks != null ? this.storedPacks.getString("players." + playerId.toString(), null) : null;
    }

    public Map<String, Object> getStoredPacks() {
        return this.storedPacks.getSection("players");
    }

    @Override
    public boolean isUsepackTemporary() {
        return this.getConfig().getBoolean("usepack-is-temporary");
    }

    @Override
    public boolean areSelectedPacksRemovingExisting() {
        return this.getConfig().getBoolean("selected-packs-remove-existing");
    }

    @Override
    public int getPermanentPackRemoveTime() {
        return this.getConfig().getInt("permanent-pack-remove-time");
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.PROXY;
    }

    public PluginConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void resendPack(Player player) {
        String serverName = "";
        if (player.getCurrentServer().isPresent()) {
            serverName = ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName();
        }
        this.getPackManager().applyPack(this.getPlayer(player), serverName);
    }

    @Override
    public void resendPack(UUID playerId) {
        this.getProxy().getPlayer(playerId).ifPresent(this::resendPack);
    }

    protected void sendPack(Player player, ResourcePack pack) {
        int clientVersion = player.getProtocolVersion().getProtocol();
        if (clientVersion >= ProtocolVersion.MINECRAFT_1_8.getProtocol()) {
            if (clientVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber() && (pack == null || pack == this.getPackManager().getEmptyPack())) {
                this.sendPackClearRequest(player);
                return;
            }
            ResourcePackInfo.Builder packInfoBuilder = this.proxy.createResourcePackBuilder(this.getPackManager().getPackUrl(pack)).setId(pack.getUuid());
            if (pack.getRawHash().length == 20) {
                packInfoBuilder.setHash(pack.getRawHash());
            } else if (pack.getRawHash().length > 0) {
                this.log(Level.WARNING, "Invalid sha1 hash sum for pack " + pack.getName() + " detected! (It was '" + pack.getHash() + "')");
            }
            try {
                player.sendResourcePackOffer(packInfoBuilder.build());
                this.logDebug("Sent pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getUsername() + ".");
            }
            catch (IllegalStateException e) {
                this.logDebug("Not sending pack " + pack.getName() + "to " + player.getUsername() + ": " + e.getMessage());
            }
        } else {
            this.log(Level.WARNING, "Cannot send the pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getUsername() + " as he uses the unsupported protocol version " + clientVersion + "!");
            this.log(Level.WARNING, "Consider blocking access to your server for clients with version under 1.8 if you want this plugin to work for everyone!");
        }
    }

    @Override
    public void sendPackInfo(UUID playerId) {
        this.getProxy().getPlayer(playerId).ifPresent(player -> this.sendPackInfo((Player)player, this.getUserManager().getUserPacks(playerId)));
    }

    private void sendPackInfo(Player player, List<ResourcePack> packs) {
        RegisteredServer server = this.getCurrentServer(player);
        if (server == null) {
            this.logDebug("Tried to send pack info of " + packs.size() + " packs for player " + player.getUsername() + " but server was null!");
            return;
        }
        if (!packs.isEmpty()) {
            this.getMessageChannelHandler().sendMessage(server, "packsChange", (ByteArrayDataOutput out) -> {
                out.writeUTF(player.getUsername());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
                out.writeInt(packs.size());
                for (ResourcePack pack : packs) {
                    this.getMessageChannelHandler().writePack((ByteArrayDataOutput)out, pack);
                }
            });
        } else {
            this.getMessageChannelHandler().sendMessage(server, "clearPack", (ByteArrayDataOutput out) -> {
                out.writeUTF(player.getUsername());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
            });
        }
    }

    public RegisteredServer getCurrentServer(Player player) {
        String serverName = this.getCurrentServerTracker().getCurrentServer(player);
        if (serverName == null) {
            if (player.getProtocolState() != ProtocolState.CONFIGURATION) {
                this.logDebug("Tried to get current server for player " + player.getUsername() + " but server '" + serverName + "' doesn't exist?");
            }
            return null;
        }
        return this.proxy.getServer(serverName).orElse(null);
    }

    @Override
    public void sendPack(UUID playerId, ResourcePack pack) {
        this.getProxy().getPlayer(playerId).ifPresent(p -> this.sendPack((Player)p, pack));
    }

    @Override
    public void removePack(UUID playerId, ResourcePack pack) {
        this.getProxy().getPlayer(playerId).ifPresent(p -> this.removePack((Player)p, pack));
    }

    private void removePack(Player player, ResourcePack pack) {
        if (pack.getUuid() != null) {
            this.sendPackRemovalRequest(player, pack);
        }
        this.sendPackRemoveInfo(player, pack);
    }

    private void sendPackClearRequest(Player player) {
        try {
            player.clearResourcePacks();
            this.logDebug("Removed all packs from " + player.getUsername());
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            RegisteredServer server = this.getCurrentServer(player);
            if (server == null) {
                this.logDebug("Tried to send pack clear request for player " + player.getUsername() + " but server was null!");
                return;
            }
            this.getMessageChannelHandler().sendMessage(server, "removePackRequest", (ByteArrayDataOutput out) -> {
                out.writeUTF(player.getUsername());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
                this.getMessageChannelHandler().writePack((ByteArrayDataOutput)out, null);
            });
            this.logDebug("Removed all packs from " + player.getUsername());
            return;
        }
    }

    private void sendPackRemovalRequest(Player player, ResourcePack pack) {
        RegisteredServer server;
        if (pack.getUuid() != null) {
            try {
                player.removeResourcePacks(pack.getUuid(), new UUID[0]);
                this.logDebug("Removed pack " + pack.getName() + " (" + String.valueOf(pack.getUuid()) + ") from " + player.getUsername());
                return;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if ((server = this.getCurrentServer(player)) == null) {
            this.logDebug("Tried to send pack removal request of pack " + pack.getName() + " for player " + player.getUsername() + " but server was null!");
            return;
        }
        this.getMessageChannelHandler().sendMessage(server, "removePackRequest", (ByteArrayDataOutput out) -> {
            out.writeUTF(player.getUsername());
            out.writeLong(player.getUniqueId().getMostSignificantBits());
            out.writeLong(player.getUniqueId().getLeastSignificantBits());
            this.getMessageChannelHandler().writePack((ByteArrayDataOutput)out, pack);
        });
        this.logDebug("Removed pack " + pack.getName() + " (" + String.valueOf(pack.getUuid()) + ") from " + player.getUsername());
    }

    private void sendPackRemoveInfo(Player player, ResourcePack pack) {
        RegisteredServer server = this.getCurrentServer(player);
        if (server == null) {
            this.logDebug("Tried to send pack removal info of pack " + pack.getName() + " for player " + player.getUsername() + " but server was null!");
            return;
        }
        this.getMessageChannelHandler().sendMessage(server, "removePack", (ByteArrayDataOutput out) -> {
            out.writeUTF(player.getUsername());
            out.writeLong(player.getUniqueId().getMostSignificantBits());
            out.writeLong(player.getUniqueId().getLeastSignificantBits());
            this.getMessageChannelHandler().writePack((ByteArrayDataOutput)out, pack);
        });
    }

    public void clearPack(Player player) {
        this.getUserManager().clearUserPacks(player.getUniqueId());
    }

    @Override
    public void clearPack(UUID playerId) {
        this.getUserManager().clearUserPacks(playerId);
    }

    @Override
    public PackManager getPackManager() {
        return this.pm;
    }

    @Override
    public UserManager getUserManager() {
        return this.um;
    }

    public void setBackend(UUID playerId) {
        this.backendPackedPlayers.put(playerId, false);
    }

    public void unsetBackend(UUID playerId) {
        this.backendPackedPlayers.remove(playerId);
    }

    public boolean hasBackend(UUID playerId) {
        return this.backendPackedPlayers.containsKey(playerId);
    }

    @Override
    public String getMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        return LegacyComponentSerializer.legacySection().serialize(this.getComponents(sender, key, replacements));
    }

    public Component getComponents(ResourcepacksPlayer sender, String key, String ... replacements) {
        if (this.lm != null) {
            LanguageConfig config;
            Player player = null;
            if (sender != null) {
                player = this.getProxy().getPlayer(sender.getUniqueId()).orElse(null);
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return MineDown.parse(config.get(key), replacements);
            }
            return Component.text((String)("Missing language config! (default language: " + this.lm.getDefaultLocale() + ", key: " + key + ")"));
        }
        return Component.text((String)key);
    }

    @Override
    public boolean hasMessage(ResourcepacksPlayer sender, String key) {
        if (this.lm != null) {
            LanguageConfig config;
            Player player = null;
            if (sender != null) {
                player = this.getProxy().getPlayer(sender.getUniqueId()).orElse(null);
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return config.contains(key, true);
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.getDescription().getName().orElse(this.getDescription().getId());
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion().orElse("Unknown");
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public LangLogger getLangLogger() {
        return this.logger;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    public PluginDescription getDescription() {
        if (this.ownContainer == null) {
            this.ownContainer = this.proxy.getPluginManager().fromInstance((Object)this).orElse(null);
        }
        return this.ownContainer != null ? this.ownContainer.getDescription() : new PluginDescription(this){

            public String getId() {
                return this.getClass().getSimpleName();
            }
        };
    }

    @Override
    public void logDebug(String message) {
        this.logDebug(message, null);
    }

    @Override
    public void logDebug(String message, Throwable throwable) {
        if (this.getLogLevel() != Level.OFF) {
            this.log(this.getLogLevel(), "[DEBUG] " + message, throwable);
        }
    }

    @Override
    public Level getLogLevel() {
        return this.loglevel;
    }

    @Override
    public ResourcepacksPlayer getPlayer(UUID playerId) {
        return this.getPlayer((Player)this.getProxy().getPlayer(playerId).orElse(null));
    }

    @Override
    public ResourcepacksPlayer getPlayer(String playerName) {
        return this.getPlayer((Player)this.getProxy().getPlayer(playerName).orElse(null));
    }

    public ResourcepacksPlayer getPlayer(Player player) {
        return player != null ? new ResourcepacksPlayer(player.getUsername(), player.getUniqueId()) : null;
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, String key, String ... replacements) {
        return this.sendMessage(player, Level.INFO, key, replacements);
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, Level level, String key, String ... replacements) {
        Component message = this.getComponents(player, key, replacements);
        if (PlainTextComponentSerializer.plainText().serialize(message).isEmpty()) {
            return false;
        }
        if (player != null) {
            Optional proxyPlayer = this.getProxy().getPlayer(player.getUniqueId());
            if (proxyPlayer.isPresent()) {
                ((Player)proxyPlayer.get()).sendMessage(message);
                return true;
            }
        } else {
            this.log(level, PlainTextComponentSerializer.plainText().serialize(message));
        }
        return false;
    }

    @Override
    public void log(Level level, String message) {
        this.getPluginLogger().log(level, message);
    }

    @Override
    public void log(Level level, String message, Throwable throwable) {
        this.getPluginLogger().log(level, message, throwable);
    }

    @Override
    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    @Override
    public boolean checkPermission(UUID playerId, String perm) {
        return this.getProxy().getPlayer(playerId).map(p -> p.hasPermission(perm)).orElseGet(() -> perm == null);
    }

    @Override
    public int getPlayerProtocol(UUID playerId) {
        if (this.viaApi != null) {
            return this.viaApi.getPlayerVersion(playerId);
        }
        return this.getProxy().getPlayer(playerId).map(p -> p.getProtocolVersion().getProtocol()).orElse(-1);
    }

    @Override
    public ClientType getPlayerClientType(UUID playerId) {
        if (this.geyser != null && this.geyser.hasPlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.floodgate != null && this.floodgate.hasPlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.geyser != null || this.floodgate != null) {
            return ClientType.ORIGINAL;
        }
        return ResourcepacksPlugin.super.getPlayerClientType(playerId);
    }

    @Override
    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, List<ResourcePack> packs, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, packs, status);
        try {
            return (IResourcePackSelectEvent)this.getProxy().getEventManager().fire((Object)selectEvent).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getPluginLogger().log(Level.SEVERE, "Error while firing ResourcePackSelectEvent!", e);
            return null;
        }
    }

    @Override
    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        try {
            return (IResourcePackSendEvent)this.getProxy().getEventManager().fire((Object)sendEvent).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getPluginLogger().log(Level.SEVERE, "Error while firing ResourcePackSendEvent!", e);
            return null;
        }
    }

    @Override
    public boolean isAuthenticated(UUID playerId) {
        return !this.getConfig().getBoolean("use-auth-plugin", this.getConfig().getBoolean("useauth", false)) || this.authenticatedPlayers.contains(playerId);
    }

    @Override
    public int runTask(Runnable runnable) {
        this.getProxy().getScheduler().buildTask((Object)this, runnable).schedule();
        return 0;
    }

    @Override
    public int runAsyncTask(Runnable runnable) {
        return this.runTask(runnable);
    }

    public void setAuthenticated(UUID playerId, boolean b) {
        if (b) {
            this.authenticatedPlayers.add(playerId);
        } else {
            this.authenticatedPlayers.remove(playerId);
        }
    }

    public SubChannelHandler<RegisteredServer> getMessageChannelHandler() {
        return this.messageChannelHandler;
    }

    public CurrentServerTracker getCurrentServerTracker() {
        return this.serverTracker;
    }
}

