/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.velocity.listeners;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import de.themoep.resourcepacksplugin.velocity.PluginConfig;
import de.themoep.resourcepacksplugin.velocity.VelocityResourcepacks;
import de.themoep.resourcepacksplugin.velocity.listeners.AuthHandler;
import java.io.File;
import java.util.UUID;
import java.util.logging.Level;

public class PluginMessageListener
extends SubChannelHandler<RegisteredServer> {
    private static final ChannelIdentifier CHANNEL_IDENTIFIER = MinecraftChannelIdentifier.from((String)"rp:plugin");
    private final VelocityResourcepacks plugin;
    private final PluginConfig keyConfig;
    private final AuthHandler authHandler;

    public PluginMessageListener(VelocityResourcepacks plugin) {
        super(plugin);
        this.plugin = plugin;
        this.authHandler = new AuthHandler(plugin);
        this.keyConfig = new PluginConfig(plugin, new File(plugin.getDataFolder(), "key.yml"), null);
        this.registerSubChannel("authLogin", (s, in) -> {
            String playerName = in.readUTF();
            UUID playerId = UUID.fromString(in.readUTF());
            if (!plugin.isAuthenticated(playerId)) {
                plugin.getProxy().getPlayer(playerId).ifPresent(this.authHandler::onAuth);
            }
        });
    }

    @Subscribe(order=PostOrder.FIRST)
    public void pluginMessageReceived(PluginMessageEvent event) {
        if (!this.plugin.isEnabled() || !event.getIdentifier().equals((Object)CHANNEL_IDENTIFIER)) {
            return;
        }
        event.setResult(PluginMessageEvent.ForwardResult.handled());
        if (event.getSource() instanceof ServerConnection) {
            this.handleMessage(((ServerConnection)event.getSource()).getServer(), event.getData());
        } else {
            this.plugin.logDebug("Received plugin message from " + String.valueOf(event.getSource()) + " which is not a ServerConnection!");
        }
    }

    @Subscribe
    public void onServerSwitch(ServerPostConnectEvent event) {
        if (this.plugin.isEnabled()) {
            event.getPlayer().getCurrentServer().ifPresent(serverConnection -> this.sendKey(serverConnection.getServer()));
        }
    }

    @Override
    protected void sendPluginMessage(RegisteredServer target, byte[] data) {
        try {
            target.sendPluginMessage(CHANNEL_IDENTIFIER, data);
        }
        catch (Exception e) {
            this.plugin.log(Level.WARNING, "Failed to send plugin message to server " + target.getServerInfo().getName() + "! This is most likely because the player connection timed out. " + e.getMessage());
            this.plugin.logDebug("Plugin message sending error:", e);
        }
    }

    @Override
    protected void saveKey(String key) {
        this.keyConfig.set("key", key);
        this.keyConfig.save();
    }

    @Override
    protected String loadKey() {
        String key = null;
        if (this.keyConfig.load()) {
            key = this.keyConfig.getString("key", null);
        } else {
            this.plugin.log(Level.SEVERE, "Unable to load key.yml! Forwarding info to the plugin on the Minecraft server will not work!");
        }
        if (key == null) {
            key = this.generateKey();
            this.saveKey(key);
        }
        return key;
    }

    @Override
    protected String getTargetType() {
        return "Minecraft server";
    }
}

