/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.PlatformType;
import de.themoep.resourcepacksplugin.core.PluginLogger;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public interface ResourcepacksPlugin {
    default public void startupMessage() {
        this.log(this.getLogLevel(), "");
        this.log(this.getLogLevel(), "  If you enjoy my " + this.getName() + " plugin then you might also be");
        this.log(this.getLogLevel(), "  interested in the more advanced ForceResourcepacks version!");
        this.log(this.getLogLevel(), "");
        this.log(this.getLogLevel(), "  Besides getting additional features like WorldGuard support and");
        this.log(this.getLogLevel(), "  the ability to force a player to accept the resources pack you");
        this.log(this.getLogLevel(), "  will also support the continued development of this plugin!");
        this.log(this.getLogLevel(), "");
        this.log(this.getLogLevel(), "  Check it out here on spigotmc.org: https://s.moep.tv/frp");
        this.log(this.getLogLevel(), "");
        this.log(this.getLogLevel(), "  - Phoenix616");
        this.log(this.getLogLevel(), "");
    }

    public boolean loadConfig();

    public Map<String, Object> getConfigMap(Object var1);

    public void reloadConfig(boolean var1);

    public boolean isEnabled();

    public void resendPack(UUID var1);

    public void sendPackInfo(UUID var1);

    public void sendPack(UUID var1, ResourcePack var2);

    public void removePack(UUID var1, ResourcePack var2);

    public void clearPack(UUID var1);

    public PackManager getPackManager();

    public UserManager getUserManager();

    @Deprecated
    default public String getMessage(String key) {
        return this.getMessage(null, key, new String[0]);
    }

    @Deprecated
    default public String getMessage(String key, Map<String, String> replacements) {
        String[] repl = new String[replacements.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> e : replacements.entrySet()) {
            repl[i] = e.getKey();
            repl[i + 1] = e.getValue();
            i += 2;
        }
        return this.getMessage(null, key, repl);
    }

    public String getMessage(ResourcepacksPlayer var1, String var2, String ... var3);

    public boolean hasMessage(ResourcepacksPlayer var1, String var2);

    public String getName();

    public String getVersion();

    public PluginLogger getPluginLogger();

    public File getDataFolder();

    public void logDebug(String var1);

    public void logDebug(String var1, Throwable var2);

    public Level getLogLevel();

    public ResourcepacksPlayer getPlayer(UUID var1);

    public ResourcepacksPlayer getPlayer(String var1);

    public boolean sendMessage(ResourcepacksPlayer var1, String var2, String ... var3);

    public boolean sendMessage(ResourcepacksPlayer var1, Level var2, String var3, String ... var4);

    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public boolean checkPermission(ResourcepacksPlayer var1, String var2);

    public boolean checkPermission(UUID var1, String var2);

    public int getPlayerProtocol(UUID var1);

    default public int getPlayerPackFormat(UUID playerId) {
        int protocol = this.getPlayerProtocol(playerId);
        if (protocol > -1) {
            return this.getPackManager().getPackFormat(protocol);
        }
        return -1;
    }

    default public ClientType getPlayerClientType(UUID playerId) {
        if (playerId.toString().startsWith("00000000-0000-0000-")) {
            return ClientType.BEDROCK;
        }
        return ClientType.ORIGINAL;
    }

    public IResourcePackSelectEvent callPackSelectEvent(UUID var1, List<ResourcePack> var2, IResourcePackSelectEvent.Status var3);

    public IResourcePackSendEvent callPackSendEvent(UUID var1, ResourcePack var2);

    public boolean isAuthenticated(UUID var1);

    public int runTask(Runnable var1);

    public int runAsyncTask(Runnable var1);

    public void saveConfigChanges();

    public void setStoredPack(UUID var1, String var2);

    public String getStoredPack(UUID var1);

    public boolean isUsepackTemporary();

    public int getPermanentPackRemoveTime();

    default public boolean supportsMultiplePacks(UUID playerId) {
        return this.getPlayerProtocol(playerId) >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber();
    }

    public PlatformType getPlatformType();
}

