/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public abstract class SubChannelHandler<S> {
    public static final String MESSAGING_CHANNEL = "rp:plugin";
    private final long version = 1L;
    private final Map<String, BiConsumer<S, ByteArrayDataInput>> subChannels = new HashMap<String, BiConsumer<S, ByteArrayDataInput>>();
    private final ResourcepacksPlugin plugin;
    private String key;

    public SubChannelHandler(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
        this.registerSubChannel("key", (p, in) -> {
            String key;
            if (!this.trustsSender() && this.acceptsNewKey() && !(key = in.readUTF()).isEmpty()) {
                plugin.logDebug("New key was sent via connection of " + p + " (If you are not using a proxy, this is a bug or player trying to exploit your server!)");
                this.setKey(key);
            }
        });
        this.registerSubChannel("packsChange", (p, in) -> {
            String playerName = in.readUTF();
            UUID playerUuid = new UUID(in.readLong(), in.readLong());
            int packCount = in.readInt();
            ResourcepacksPlayer player = plugin.getPlayer(playerUuid);
            if (player == null) {
                plugin.logDebug("(proxy)server sent pack " + packCount + " packs to player " + playerName + " but they aren't online?");
            }
            plugin.getUserManager().clearUserPacks(playerUuid);
            for (int i = 0; i < packCount; ++i) {
                ResourcePack pack = this.readPack((ByteArrayDataInput)in);
                if (pack != null) {
                    plugin.logDebug("(proxy)server sent pack " + pack.getName() + " (" + pack.getUrl() + ") to player " + playerName);
                    plugin.getUserManager().addUserPack(playerUuid, pack);
                    continue;
                }
                plugin.logDebug("(proxy)server sent command to add an unknown pack to " + playerName + "?");
            }
        });
        this.registerSubChannel("clearPack", (p, in) -> {
            String playerName = in.readUTF();
            UUID playerUuid = new UUID(in.readLong(), in.readLong());
            ResourcepacksPlayer player = plugin.getPlayer(playerUuid);
            if (player == null) {
                plugin.logDebug("(proxy)server sent command to clear the pack of player " + playerName + " but they aren't online?");
            }
            plugin.logDebug("(proxy)server sent command to clear the pack of player " + playerName);
            plugin.clearPack(playerUuid);
        });
        this.registerSubChannel("removePack", (p, in) -> {
            String playerName = in.readUTF();
            UUID playerUuid = new UUID(in.readLong(), in.readLong());
            ResourcePack pack = this.readPack((ByteArrayDataInput)in);
            if (pack != null) {
                ResourcepacksPlayer player = plugin.getPlayer(playerUuid);
                if (player == null) {
                    plugin.logDebug("(proxy)server sent command to remove the pack " + pack.getName() + " of player " + playerName + " but they aren't online?");
                }
                plugin.logDebug("(proxy)server sent command to remove the pack " + pack.getName() + " from player " + playerName);
                plugin.getUserManager().removeUserPack(playerUuid, pack);
            } else {
                plugin.logDebug("(proxy)server sent command to remove an unknown pack from " + playerName + "?");
            }
        });
    }

    public BiConsumer<S, ByteArrayDataInput> registerSubChannel(String name, BiConsumer<S, ByteArrayDataInput> reaction) {
        return this.subChannels.put(name, reaction);
    }

    protected boolean handleMessage(S source, byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        BiConsumer<S, ByteArrayDataInput> reaction = this.subChannels.get(subChannel);
        if (reaction != null) {
            long version = in.readLong();
            if (version != this.version) {
                this.plugin.log(Level.SEVERE, "Received a message with an incompatible version by " + source + " on subchannel " + subChannel + "! Please make sure you are running the same plugin version on both your Minecraft server and the proxy!");
                return false;
            }
            String key = in.readUTF();
            if (!(this.trustsSender() || "key".equals(subChannel) || !key.isEmpty() && key.equals(this.key))) {
                this.plugin.log(Level.WARNING, "Received a message with an invalid key by " + source + " on subchannel " + subChannel + "! Please make sure the key on your proxy(s) and Minecraft servers match!");
                return false;
            }
            reaction.accept(source, in);
            return true;
        }
        this.plugin.log(Level.WARNING, "Unknown subchannel " + subChannel + "! Please make sure you are running a compatible plugin version on your Proxy!");
        return false;
    }

    protected void sendKey(S target) {
        if (this.key != null && !this.key.isEmpty()) {
            this.sendMessage(target, "key", out -> out.writeUTF(this.key));
        }
    }

    public void sendMessage(S target, String subChannel, Consumer<ByteArrayDataOutput> out) {
        if (this.key == null) {
            this.plugin.log(Level.WARNING, "Can't send data to " + this.getTargetType() + " on channel " + subChannel + " as no authentication key is set!\nIf you are using the plugin on both the proxy and the Minecraft servers as well then this is an error! Make sure the same key is set in the plugin's key.yml on the proxy and all your servers!\nIf you are not using the plugin on the proxy then you can just ignore this warning! The key should be set automatically to empty on the next join. (Otherwise just set an empty key yourself)");
            return;
        }
        if (this.key.isEmpty()) {
            this.plugin.logDebug("Not sending message to " + target + " on " + subChannel + " as we are not in an environment where we should (key is empty in key.yml)");
            return;
        }
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeUTF(subChannel);
        dataOutput.writeLong(1L);
        dataOutput.writeUTF(this.trustsSender() ? this.key : "");
        out.accept(dataOutput);
        this.sendPluginMessage(target, dataOutput.toByteArray());
    }

    public void writePack(ByteArrayDataOutput out, ResourcePack pack) {
        if (pack == null) {
            out.writeUTF("");
            return;
        }
        out.writeUTF(pack.getName());
        out.writeUTF(pack.getUrl());
        out.writeUTF(pack.getHash());
        out.writeLong(pack.getUuid() != null ? pack.getUuid().getMostSignificantBits() : 0L);
        out.writeLong(pack.getUuid() != null ? pack.getUuid().getLeastSignificantBits() : 0L);
    }

    protected ResourcePack readPack(ByteArrayDataInput in) {
        ResourcePack pack;
        block5: {
            String packName = in.readUTF();
            if (packName.isEmpty()) {
                return this.plugin.getPackManager().getEmptyPack();
            }
            String packUrl = in.readUTF();
            String packHash = in.readUTF();
            UUID packUuid = new UUID(in.readLong(), in.readLong());
            if (packUuid.getLeastSignificantBits() == 0L && packUuid.getMostSignificantBits() == 0L) {
                packUuid = null;
            }
            if ((pack = this.plugin.getPackManager().getByName(packName)) == null) {
                try {
                    pack = new ResourcePack(packName, packUuid, packUrl, packHash);
                    this.plugin.getPackManager().addPack(pack);
                }
                catch (IllegalArgumentException e) {
                    pack = this.plugin.getPackManager().getByHash(packHash);
                    if (pack != null) break block5;
                    pack = this.plugin.getPackManager().getByUrl(packUrl);
                }
            }
        }
        return pack;
    }

    protected abstract void sendPluginMessage(S var1, byte[] var2);

    public void reload() {
        this.key = this.loadKey();
    }

    protected String generateKey() {
        byte[] key;
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256);
            SecretKey secretKey = generator.generateKey();
            key = secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            this.plugin.log(Level.WARNING, "Unable to generate a new key with AES! Using a less-secure random one! " + e.getMessage());
            key = String.valueOf(new Random().nextLong()).getBytes();
        }
        this.plugin.logDebug("Generated new key! You can find it in the key.yml file.");
        return Base64.getEncoder().encodeToString(key);
    }

    protected void setKey(String key) {
        this.key = key;
        this.saveKey(key);
    }

    protected boolean acceptsNewKey() {
        return this.key == null;
    }

    protected boolean trustsSender() {
        return true;
    }

    protected abstract void saveKey(String var1);

    protected abstract String loadKey();

    protected abstract String getTargetType();
}

