/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee.packets;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import de.themoep.resourcepacksplugin.bungee.BungeeResourcepacks;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ResourcePackSendPacket
extends DefinedPacket {
    private Optional<UUID> uuid = Optional.empty();
    private String url;
    private Optional<String> hash = Optional.empty();
    private Optional<Boolean> required = Optional.empty();
    private Optional<BaseComponent[]> promptMessage = Optional.empty();
    private static Field conField = null;

    public ResourcePackSendPacket() {
    }

    @ConstructorProperties(value={"url", "hash"})
    public ResourcePackSendPacket(String url, String hash) {
        this.url = url;
        this.hash = hash != null ? Optional.of(hash.toLowerCase(Locale.ROOT)) : Optional.of(Hashing.sha1().hashString((CharSequence)this.getUrl(), Charsets.UTF_8).toString().toLowerCase(Locale.ROOT));
    }

    @ConstructorProperties(value={"url", "hash"})
    public ResourcePackSendPacket(UUID uuid, String url, String hash) {
        this(url, hash);
        this.uuid = Optional.of(uuid);
    }

    @ConstructorProperties(value={"url", "hash", "force", "promptMessage"})
    public ResourcePackSendPacket(String url, String hash, boolean required, BaseComponent[] promptMessage) {
        this(url, hash);
        this.required = Optional.of(required);
        this.promptMessage = Optional.ofNullable(promptMessage);
    }

    @ConstructorProperties(value={"uuid", "url", "hash", "force", "promptMessage"})
    public ResourcePackSendPacket(UUID uuid, String url, String hash, boolean required, BaseComponent[] promptMessage) {
        this(url, hash, required, promptMessage);
        this.uuid = Optional.of(uuid);
    }

    public void handle(AbstractPacketHandler handler) throws Exception {
        if (handler instanceof DownstreamBridge) {
            if (conField != null) {
                DownstreamBridge bridge = (DownstreamBridge)handler;
                try {
                    UserConnection userConnection = (UserConnection)conField.get(bridge);
                    this.updatePlayer(userConnection);
                    PacketWrapper packetWrapper = new PacketWrapper((DefinedPacket)this, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocate(Integer.toString(this.getUrl().length()).length())), userConnection.getCh().getEncodeProtocol());
                    userConnection.getPendingConnection().handle(packetWrapper);
                }
                catch (IllegalAccessException e) {
                    BungeeResourcepacks.getInstance().getLogger().log(Level.WARNING, "Sorry but you are not allowed to do this.", e);
                }
            }
        } else {
            BungeeResourcepacks.getInstance().logDebug("Sending ResourcePackSend packets to " + handler.getClass().getName() + " is not properly supported by this plugin! (Only players) Trying to handle anyways...");
            if (handler instanceof PacketHandler) {
                ((PacketHandler)handler).handle(new PacketWrapper((DefinedPacket)this, Unpooled.copiedBuffer((ByteBuffer)ByteBuffer.allocate(Integer.toString(this.getUrl().length()).length())), Protocol.GAME));
            } else if (BungeeResourcepacks.getInstance().getLogLevel().intValue() >= Level.INFO.intValue()) {
                new UnsupportedOperationException("Unsupported handler type " + handler.getClass().getName()).fillInStackTrace().printStackTrace();
            }
        }
    }

    private void updatePlayer(UserConnection usercon) {
        BungeeResourcepacks plugin = BungeeResourcepacks.getInstance();
        if (plugin.isEnabled()) {
            ResourcePack pack = plugin.getPackManager().getByHash(this.getHash());
            String url = this.getUrl();
            if (url.endsWith("#" + this.getHash())) {
                url = url.substring(0, url.lastIndexOf(35));
            }
            if (pack == null) {
                pack = plugin.getPackManager().getByUrl(url);
            }
            if (pack == null) {
                try {
                    pack = new ResourcePack("backend-" + this.getUrl().substring(url.lastIndexOf(47) + 1).replace(".zip", "").toLowerCase(Locale.ROOT), url, this.getHash());
                    plugin.getPackManager().addPack(pack);
                }
                catch (IllegalArgumentException e) {
                    pack = plugin.getPackManager().getByUrl(url);
                }
            }
            plugin.setBackend(usercon.getUniqueId());
            plugin.logDebug("Backend mc server sent pack " + pack.getName() + " (" + pack.getUrl() + ") to player " + usercon.getName());
            plugin.getUserManager().addUserPack(usercon.getUniqueId(), pack);
        }
    }

    public void read(ByteBuf buf) {
        this.url = ResourcePackSendPacket.readString((ByteBuf)buf);
        try {
            this.hash = Optional.of(ResourcePackSendPacket.readString((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber()) {
            this.uuid = Optional.of(ResourcePackSendPacket.readUUID((ByteBuf)buf));
        }
        this.read(buf);
        if (protocolVersion >= MinecraftVersion.MINECRAFT_1_17.getProtocolNumber()) {
            this.required = Optional.of(buf.readBoolean());
            boolean hasPromptMessage = buf.readBoolean();
            if (hasPromptMessage) {
                ByteBuf copy = buf.copy();
                try {
                    this.promptMessage = Optional.of(new BaseComponent[]{ResourcePackSendPacket.readBaseComponent((ByteBuf)buf, (int)protocolVersion)});
                }
                catch (Throwable t) {
                    String string = ResourcePackSendPacket.readString((ByteBuf)copy);
                    try {
                        this.promptMessage = Optional.of(ComponentSerializer.parse((String)string));
                    }
                    catch (Throwable t2) {
                        this.promptMessage = Optional.of(new BaseComponent[]{TextComponent.fromLegacy((String)string)});
                        BungeeResourcepacks.getInstance().logDebug("Unable to parse backend resource pack prompt message '" + string + "' as tag or json!");
                    }
                }
            }
        }
    }

    public void write(ByteBuf buf) {
        ResourcePackSendPacket.writeString((String)this.getUrl(), (ByteBuf)buf);
        ResourcePackSendPacket.writeString((String)this.hash.orElse(""), (ByteBuf)buf);
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber()) {
            if (this.uuid.isPresent()) {
                ResourcePackSendPacket.writeUUID((UUID)this.uuid.get(), (ByteBuf)buf);
            } else {
                ResourcePackSendPacket.writeUUID((UUID)UUID.nameUUIDFromBytes(this.url.getBytes(StandardCharsets.UTF_8)), (ByteBuf)buf);
            }
        }
        this.write(buf);
        if (protocolVersion >= MinecraftVersion.MINECRAFT_1_17.getProtocolNumber()) {
            buf.writeBoolean(this.required.orElse(false).booleanValue());
            if (this.promptMessage.isPresent()) {
                buf.writeBoolean(true);
                try {
                    ResourcePackSendPacket.writeBaseComponent((BaseComponent)TextComponent.fromArray((BaseComponent[])this.promptMessage.get()), (ByteBuf)buf, (int)protocolVersion);
                }
                catch (NoSuchMethodError e) {
                    ResourcePackSendPacket.writeString((String)ComponentSerializer.toString((BaseComponent[])this.promptMessage.get()), (ByteBuf)buf);
                }
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getHash() {
        return this.hash.filter(h -> !h.isEmpty() && !"null".equals(h)).orElse(null);
    }

    public String toString() {
        return "ResourcePackSendPacket{url='" + this.url + '\'' + ", uuid=" + this.uuid + ", hash=" + this.hash + ", required=" + this.required + ", promptMessage=" + this.promptMessage + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourcePackSendPacket that = (ResourcePackSendPacket)((Object)o);
        return Objects.equals(this.url, that.url) && Objects.equals(this.hash, that.hash) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.required, that.required) && Objects.equals(this.promptMessage, that.promptMessage);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.uuid, this.hash, this.required, this.promptMessage);
    }

    static {
        try {
            conField = DownstreamBridge.class.getDeclaredField("con");
            conField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            BungeeResourcepacks.getInstance().getLogger().log(Level.SEVERE, "Error while trying to get the UserConnection field from the DownstreamBridge object. Is the plugin up to date?");
        }
    }
}

