/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class FileConfiguration {
    protected static final ConfigurationProvider yml = ConfigurationProvider.getProvider(YamlConfiguration.class);
    private Plugin plugin;
    private final Configuration defaultCfg;
    private Configuration config;
    private File configFile;
    private String defaultFile;

    public FileConfiguration(Plugin plugin, String path) throws IOException {
        this(plugin, new File(plugin.getDataFolder(), path));
    }

    public FileConfiguration(Plugin plugin, File configFile) throws IOException {
        this(plugin, configFile, configFile.getName());
    }

    public FileConfiguration(Plugin plugin, File configFile, String defaultFile) throws IOException {
        this.plugin = plugin;
        this.configFile = configFile;
        this.defaultFile = defaultFile;
        InputStream stream = plugin.getResourceAsStream(defaultFile);
        if (stream != null) {
            Configuration jarConfig;
            try {
                jarConfig = yml.load((Reader)new InputStreamReader(stream));
            }
            catch (Exception e) {
                jarConfig = new Configuration();
                plugin.getLogger().log(Level.WARNING, "Could not load default config for " + configFile.getName() + " from jar!", e);
            }
            this.defaultCfg = jarConfig;
        } else {
            this.defaultCfg = new Configuration();
        }
        this.loadConfig();
    }

    public boolean loadConfig() throws IOException {
        if (this.configFile.exists()) {
            this.config = yml.load(this.configFile, this.defaultCfg);
            return true;
        }
        if (this.configFile.getParentFile().exists() || this.configFile.getParentFile().mkdirs()) {
            return this.createDefaultConfig();
        }
        return false;
    }

    public boolean saveConfig() {
        try {
            yml.save(this.config, this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save configuration to " + this.configFile.getAbsolutePath());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean createDefaultConfig() throws IOException {
        if (!this.configFile.exists()) {
            InputStream stream = this.plugin.getResourceAsStream(this.defaultFile);
            if (stream != null) {
                this.config = yml.load((Reader)new InputStreamReader(stream), this.defaultCfg);
                Files.copy(this.plugin.getResourceAsStream(this.defaultFile), this.configFile.toPath(), new CopyOption[0]);
            } else {
                this.config = new Configuration();
            }
            return true;
        }
        return false;
    }

    public boolean removeConfig() {
        return this.configFile.delete();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Configuration getDefaults() {
        return this.defaultCfg;
    }

    public boolean isSet(String path) {
        return this.isSet(path, false);
    }

    public boolean isSet(String path, boolean ignoreDefaults) {
        return (ignoreDefaults ? this.config.get(path, null) : this.config.get(path)) != null;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public Object get(String path) {
        return this.config.get(path);
    }

    public Object get(String path, Object def) {
        return this.config.get(path, def);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, this.defaultCfg.getBoolean(path));
    }

    public boolean getBoolean(String path, boolean def) {
        Object value = this.config.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (((String)value).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)value).equalsIgnoreCase("false")) {
                return false;
            }
        }
        return def;
    }

    public int getInt(String path) {
        return this.getInt(path, this.defaultCfg.getInt(path));
    }

    public int getInt(String path, int def) {
        Object value = this.config.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long getLong(String path) {
        return this.getLong(path, this.defaultCfg.getLong(path));
    }

    public long getLong(String path, long def) {
        Object value = this.config.get(path);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String path) {
        return this.getString(path, this.defaultCfg.getString(path));
    }

    public String getString(String path, String def) {
        Object value = this.config.get(path);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return value.toString();
        }
        return def;
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public Configuration getSection(String path) {
        return this.config.getSection(path);
    }

    public boolean isSection(String path) {
        return this.config.get(path) instanceof Configuration;
    }

    public boolean isList(String path) {
        return this.config.get(path) instanceof List;
    }

    public boolean isStringList(String path) {
        Object value = this.config.get(path);
        return value instanceof List && !((List)value).isEmpty() && ((List)value).get(0) instanceof String;
    }

    public boolean isString(String path) {
        return this.config.get(path) instanceof String;
    }

    public boolean isInt(String path) {
        return this.config.get(path) instanceof Integer;
    }

    public boolean isLong(String path) {
        return this.config.get(path) instanceof Long;
    }

    public boolean isDouble(String path) {
        return this.config.get(path) instanceof Double;
    }

    public boolean isBoolean(String path) {
        return this.config.get(path) instanceof Boolean;
    }
}

