/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bungee;

import com.google.common.io.ByteArrayDataOutput;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import de.themoep.resourcepacksplugin.bungee.FileConfiguration;
import de.themoep.resourcepacksplugin.bungee.ForwardingCommand;
import de.themoep.resourcepacksplugin.bungee.events.ResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.bungee.events.ResourcePackSendEvent;
import de.themoep.resourcepacksplugin.bungee.libs.bstats.MetricsLite;
import de.themoep.resourcepacksplugin.bungee.libs.lang.LanguageConfig;
import de.themoep.resourcepacksplugin.bungee.libs.lang.bungee.BungeeLanguageConfig;
import de.themoep.resourcepacksplugin.bungee.libs.lang.bungee.LanguageManager;
import de.themoep.resourcepacksplugin.bungee.listeners.ConnectListener;
import de.themoep.resourcepacksplugin.bungee.listeners.DisconnectListener;
import de.themoep.resourcepacksplugin.bungee.listeners.JPremiumListener;
import de.themoep.resourcepacksplugin.bungee.listeners.LibreLoginListener;
import de.themoep.resourcepacksplugin.bungee.listeners.LibrePremiumListener;
import de.themoep.resourcepacksplugin.bungee.listeners.NLoginListener;
import de.themoep.resourcepacksplugin.bungee.listeners.PluginMessageListener;
import de.themoep.resourcepacksplugin.bungee.listeners.ServerSwitchListener;
import de.themoep.resourcepacksplugin.bungee.packets.IdMapping;
import de.themoep.resourcepacksplugin.bungee.packets.ResourcePackRemovePacket;
import de.themoep.resourcepacksplugin.bungee.packets.ResourcePackSendPacket;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.PackManager;
import de.themoep.resourcepacksplugin.core.PlatformType;
import de.themoep.resourcepacksplugin.core.PluginLogger;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.SubChannelHandler;
import de.themoep.resourcepacksplugin.core.UserManager;
import de.themoep.resourcepacksplugin.core.commands.PluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResetPackCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.ResourcepacksPluginCommandExecutor;
import de.themoep.resourcepacksplugin.core.commands.UsePackCommandExecutor;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import de.themoep.resourcepacksplugin.libs.minedown.MineDown;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.geyser.api.GeyserApi;

public class BungeeResourcepacks
extends Plugin
implements ResourcepacksPlugin {
    private static BungeeResourcepacks instance;
    private FileConfiguration config;
    private FileConfiguration storedPacks;
    private FileConfiguration packetMap;
    private PackManager pm = new PackManager(this);
    private UserManager um;
    private LanguageManager lm;
    private Level loglevel = Level.INFO;
    private PluginLogger pluginLogger = new PluginLogger(){

        @Override
        public void log(Level level, String message) {
            BungeeResourcepacks.this.getLogger().log(level, message);
        }

        @Override
        public void log(Level level, String message, Throwable e) {
            BungeeResourcepacks.this.getLogger().log(level, message, e);
        }
    };
    protected ResourcepacksPluginCommandExecutor pluginCommand;
    private Map<UUID, Boolean> backendPackedPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private Set<UUID> authenticatedPlayers = new HashSet<UUID>();
    private boolean enabled = false;
    private int bungeeVersion = -1;
    private ViaAPI viaApi;
    private GeyserApi geyser;
    private FloodgateApi floodgate;
    private boolean appendHashToUrl;
    private PluginMessageListener messageChannelHandler;

    public void onEnable() {
        block33: {
            block32: {
                Plugin libreLoginPlugin;
                Plugin librePremiumPlugin;
                Plugin jPremiumPlugin;
                Plugin nLoginPlugin;
                Plugin floodgatePlugin;
                Plugin geyserPlugin;
                instance = this;
                boolean firstStart = !this.getDataFolder().exists();
                this.messageChannelHandler = new PluginMessageListener(this);
                if (!this.loadConfig()) {
                    return;
                }
                if (!this.registerPacket(Protocol.GAME, "TO_CLIENT", ResourcePackSendPacket.class, ResourcePackSendPacket::new)) {
                    this.getLogger().log(Level.SEVERE, "Disabling the plugin as it can't work without the ResourcePackSendPacket!");
                    return;
                }
                if (this.bungeeVersion >= MinecraftVersion.MINECRAFT_1_20_2.getProtocolNumber()) {
                    try {
                        this.registerPacket(Protocol.valueOf((String)"CONFIGURATION"), "TO_CLIENT", ResourcePackSendPacket.class, ResourcePackSendPacket::new);
                    }
                    catch (IllegalArgumentException e) {
                        this.getLogger().log(Level.WARNING, "Unable to register ResourcePackSendPacket in config phase?");
                    }
                }
                if (this.bungeeVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber()) {
                    this.registerPacket(Protocol.GAME, "TO_CLIENT", ResourcePackRemovePacket.class, ResourcePackRemovePacket::new);
                    this.registerPacket(Protocol.CONFIGURATION, "TO_CLIENT", ResourcePackRemovePacket.class, ResourcePackRemovePacket::new);
                }
                this.setEnabled(true);
                this.pluginCommand = new ResourcepacksPluginCommandExecutor(this);
                this.registerCommand(this.pluginCommand);
                this.registerCommand(new UsePackCommandExecutor(this));
                this.registerCommand(new ResetPackCommandExecutor(this));
                if (this.getProxy().getPluginManager().getPlugin("ViaVersion") != null) {
                    try {
                        this.viaApi = Via.getAPI();
                        this.getLogger().log(Level.INFO, "Detected ViaVersion " + this.viaApi.getVersion());
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create ViaVersion hook!", e);
                    }
                }
                if ((geyserPlugin = this.getProxy().getPluginManager().getPlugin("Geyser-BungeeCord")) != null) {
                    try {
                        this.geyser = GeyserApi.api();
                        this.getLogger().log(Level.INFO, "Detected " + geyserPlugin.getDescription().getName() + " " + geyserPlugin.getDescription().getVersion());
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create Geyser hook!", e);
                    }
                }
                if ((floodgatePlugin = this.getProxy().getPluginManager().getPlugin("floodgate")) != null) {
                    try {
                        this.floodgate = FloodgateApi.getInstance();
                        this.getLogger().log(Level.INFO, "Detected " + floodgatePlugin.getDescription().getName() + " " + floodgatePlugin.getDescription().getVersion());
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create floodgate hook!", e);
                    }
                }
                if ((nLoginPlugin = this.getProxy().getPluginManager().getPlugin("nLogin")) != null) {
                    this.getLogger().log(Level.INFO, "Detected nLogin " + nLoginPlugin.getDescription().getVersion());
                    try {
                        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new NLoginListener(this));
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create nLogin hook!", e);
                    }
                }
                if ((jPremiumPlugin = this.getProxy().getPluginManager().getPlugin("JPremium")) != null) {
                    this.getLogger().log(Level.INFO, "Detected JPremium " + jPremiumPlugin.getDescription().getVersion());
                    try {
                        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new JPremiumListener(this));
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create JPremium hook!", e);
                    }
                }
                if ((librePremiumPlugin = this.getProxy().getPluginManager().getPlugin("LibrePremium")) != null) {
                    this.getLogger().log(Level.INFO, "Detected LibrePremium " + librePremiumPlugin.getDescription().getVersion());
                    try {
                        new LibrePremiumListener(this, librePremiumPlugin);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create LibrePremium hook!", e);
                    }
                }
                if ((libreLoginPlugin = this.getProxy().getPluginManager().getPlugin("LibreLogin")) != null) {
                    this.getLogger().log(Level.INFO, "Detected LibreLogin " + libreLoginPlugin.getDescription().getVersion());
                    try {
                        new LibreLoginListener(this, libreLoginPlugin);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(Level.SEVERE, "Could not create LibreLogin hook!", e);
                    }
                }
                if (this.isEnabled() && this.getConfig().getBoolean("autogeneratehashes", true)) {
                    this.getPackManager().generateHashes(null);
                }
                this.um = new UserManager(this);
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ConnectListener(this));
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new DisconnectListener(this));
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerSwitchListener(this));
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this.messageChannelHandler);
                this.getProxy().registerChannel("rp:plugin");
                if (!this.getConfig().getBoolean("disable-metrics", false)) {
                    new MetricsLite(this);
                }
                if (firstStart) break block32;
                Random random = new Random();
                if (!(random.nextDouble() < 0.01)) break block33;
            }
            this.startupMessage();
        }
    }

    protected boolean registerPacket(Protocol protocol, String directionName, Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor) {
        try {
            block33: {
                List<IdMapping> idMappings;
                Field directionField;
                try {
                    directionField = Protocol.class.getField(directionName);
                }
                catch (NoSuchFieldException e) {
                    directionField = Protocol.class.getDeclaredField(directionName);
                    directionField.setAccessible(true);
                }
                Object direction = directionField.get(protocol);
                List supportedVersions = new ArrayList();
                try {
                    Field svField = Protocol.class.getField("supportedVersions");
                    supportedVersions = (List)svField.get(null);
                }
                catch (Exception svField) {
                    // empty catch block
                }
                if (supportedVersions.size() == 0) {
                    Field svIdField = ProtocolConstants.class.getField("SUPPORTED_VERSION_IDS");
                    supportedVersions = (List)svIdField.get(null);
                }
                if ((idMappings = this.getIdMappings(protocol, packetClass)).isEmpty()) {
                    this.getLogger().log(Level.SEVERE, "No mappings set in packetmap.yml for " + protocol + " " + packetClass.getSimpleName() + "!");
                    return false;
                }
                this.logDebug("Registering " + packetClass.getSimpleName() + " in " + protocol + " phase...");
                if (this.bungeeVersion == -1) {
                    for (int i = supportedVersions.size() - 1; i > -1; --i) {
                        this.bungeeVersion = (Integer)supportedVersions.get(i);
                        if (this.bungeeVersion < 0x4000000) break;
                    }
                }
                if (this.bungeeVersion == 47) {
                    this.logDebug("BungeeCord 1.8 (" + this.bungeeVersion + ") detected!");
                    Method reg = direction.getClass().getDeclaredMethod("registerPacket", Integer.TYPE, Class.class);
                    reg.setAccessible(true);
                    int id = -1;
                    for (IdMapping mapping : idMappings) {
                        if (mapping.getProtocolVersion() != 47) continue;
                        id = mapping.getPacketId();
                        break;
                    }
                    if (id == -1) {
                        this.getLogger().log(Level.SEVERE, packetClass.getSimpleName() + " does not contain an ID for 1.8!");
                        return false;
                    }
                    reg.invoke(direction, id, packetClass);
                } else if (this.bungeeVersion >= 107 && this.bungeeVersion < 110) {
                    this.logDebug("BungeeCord 1.9-1.9.3 (" + this.bungeeVersion + ") detected!");
                    Method reg = direction.getClass().getDeclaredMethod("registerPacket", Integer.TYPE, Integer.TYPE, Class.class);
                    reg.setAccessible(true);
                    int id18 = -1;
                    int id19 = -1;
                    for (IdMapping mapping : idMappings) {
                        if (mapping.getProtocolVersion() == 47) {
                            id18 = mapping.getPacketId();
                            continue;
                        }
                        if (mapping.getProtocolVersion() < 107 || mapping.getProtocolVersion() >= 110) continue;
                        id19 = mapping.getPacketId();
                    }
                    if (id18 == -1 || id19 == -1) {
                        this.getLogger().log(Level.SEVERE, packetClass.getSimpleName() + " does not contain an ID for 1.8 or 1.9!");
                        return false;
                    }
                    reg.invoke(direction, id18, id19, packetClass);
                } else {
                    if (this.bungeeVersion >= 110) {
                        this.logDebug("BungeeCord 1.9.4+ (" + this.bungeeVersion + ") detected!");
                        Method map = Protocol.class.getDeclaredMethod("map", Integer.TYPE, Integer.TYPE);
                        map.setAccessible(true);
                        LinkedHashMap<String, Object> mappings = new LinkedHashMap<String, Object>();
                        ArrayDeque<IdMapping> additionalMappings = new ArrayDeque<IdMapping>();
                        HashSet<Integer> registeredVersions = new HashSet<Integer>();
                        for (IdMapping mapping : idMappings) {
                            if (ProtocolConstants.SUPPORTED_VERSION_IDS.contains(mapping.getProtocolVersion())) {
                                mappings.put(mapping.getName(), map.invoke(null, mapping.getProtocolVersion(), mapping.getPacketId()));
                                registeredVersions.add(mapping.getProtocolVersion());
                                continue;
                            }
                            additionalMappings.addFirst(mapping);
                        }
                        block18: for (IdMapping mapping : additionalMappings) {
                            Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
                            while (iterator.hasNext()) {
                                int id = (Integer)iterator.next();
                                if (id >= 0x4000000 || registeredVersions.contains(id) || id <= mapping.getProtocolVersion()) continue;
                                this.logDebug("Using unregistered mapping " + mapping.getName() + "/" + mapping.getProtocolVersion() + " for unregistered version " + id);
                                mappings.put(mapping.getName(), map.invoke(null, id, mapping.getPacketId()));
                                registeredVersions.add(id);
                                continue block18;
                            }
                        }
                        Object mappingsObject = Array.newInstance(mappings.values().iterator().next().getClass(), mappings.size());
                        int i = 0;
                        for (Map.Entry entry : mappings.entrySet()) {
                            Array.set(mappingsObject, i, entry.getValue());
                            this.logDebug("Found mapping for " + (String)entry.getKey() + "+ " + protocol + " " + entry.getValue());
                            ++i;
                        }
                        Object[] mappingsArray = (Object[])mappingsObject;
                        try {
                            Method reg = direction.getClass().getDeclaredMethod("registerPacket", Class.class, Supplier.class, mappingsArray.getClass());
                            reg.setAccessible(true);
                            try {
                                reg.invoke(direction, packetClass, constructor, mappingsArray);
                                break block33;
                            }
                            catch (Throwable t) {
                                this.getLogger().log(Level.SEVERE, "Protocol version " + this.bungeeVersion + " is not supported! Please look for an update!", t);
                                return false;
                            }
                        }
                        catch (NoSuchMethodException e) {
                            Method reg = direction.getClass().getDeclaredMethod("registerPacket", Class.class, mappingsArray.getClass());
                            reg.setAccessible(true);
                            try {
                                reg.invoke(direction, packetClass, mappingsArray);
                                break block33;
                            }
                            catch (Throwable t) {
                                this.getLogger().log(Level.SEVERE, "Protocol version " + this.bungeeVersion + " is not supported! Please look for an update!", t);
                                return false;
                            }
                        }
                    }
                    this.getLogger().log(Level.SEVERE, "Unsupported BungeeCord version (" + this.bungeeVersion + ") found! You need at least 1.8 for this plugin to work!");
                    return false;
                }
            }
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find a required method! Please update this plugin or downgrade BungeeCord!", e);
        }
        catch (NoSuchFieldException e) {
            this.getLogger().log(Level.SEVERE, "Couldn't find a required field! Please update this plugin or downgrade BungeeCord!", e);
        }
        return false;
    }

    private List<IdMapping> getIdMappings(Protocol protocol, Class<? extends DefinedPacket> packetClass) {
        Configuration packetConfig;
        Configuration directionConfig = this.packetMap.getConfiguration();
        if (protocol != null) {
            directionConfig = this.packetMap.getSection(protocol.name());
        }
        if ((packetConfig = directionConfig.getSection(packetClass.getSimpleName())).getKeys().isEmpty()) {
            packetConfig = directionConfig.getSection(packetClass.getSimpleName().toLowerCase(Locale.ROOT));
        }
        TreeMap<Integer, IdMapping> protocolVersionMap = new TreeMap<Integer, IdMapping>();
        for (MinecraftVersion value : MinecraftVersion.values()) {
            Object defaultId = packetConfig.getDefault(value.toConfigString().replace('.', '_'));
            int packetId = defaultId instanceof Integer ? ((Integer)defaultId).intValue() : packetConfig.getInt(value.toConfigString().replace('.', '_'));
            if (packetId <= 0) continue;
            protocolVersionMap.put(value.getProtocolNumber(), new IdMapping(value.toConfigString(), value.getProtocolNumber(), packetId));
        }
        for (String key : packetConfig.getKeys()) {
            Object defaultId;
            int packetId;
            int protocolId = -1;
            try {
                protocolId = MinecraftVersion.parseVersion(key).getProtocolNumber();
            }
            catch (IllegalArgumentException e1) {
                try {
                    protocolId = Integer.parseInt(key);
                }
                catch (NumberFormatException e2) {
                    this.getLogger().log(Level.WARNING, key + " in packetmap.yml for " + packetClass.getSimpleName() + " is not a known version!");
                }
            }
            if (protocolId <= 0 || (packetId = (defaultId = packetConfig.getDefault(key)) instanceof Integer ? ((Integer)defaultId).intValue() : packetConfig.getInt(key)) <= 0) continue;
            protocolVersionMap.put(protocolId, new IdMapping(key.replace('_', '.'), protocolId, packetId));
        }
        if (protocol != null && protocolVersionMap.isEmpty()) {
            return this.getIdMappings(null, packetClass);
        }
        return new ArrayList<IdMapping>(protocolVersionMap.values());
    }

    protected void registerCommand(PluginCommandExecutor executor) {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ForwardingCommand(executor));
    }

    @Override
    public boolean loadConfig() {
        try {
            this.config = new FileConfiguration(this, new File(this.getDataFolder(), "config.yml"), "bungee-config.yml");
            this.getLogger().log(Level.INFO, "Loading config!");
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load configuration! " + this.getDescription().getName() + " will not be enabled!", e);
            return false;
        }
        try {
            this.storedPacks = new FileConfiguration((Plugin)this, new File(this.getDataFolder(), "players.yml"));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load players.yml! Stored player packs will not work!", e);
        }
        try {
            this.packetMap = new FileConfiguration((Plugin)this, new File(this.getDataFolder(), "packetmap.yml"));
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to load packetmap.yml! The plugin will not work!", e);
            return false;
        }
        String debugString = this.getConfig().getString("debug");
        if (debugString.equalsIgnoreCase("true")) {
            this.loglevel = Level.INFO;
        } else if (debugString.equalsIgnoreCase("false")) {
            this.loglevel = Level.FINE;
        } else {
            try {
                this.loglevel = Level.parse(debugString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Wrong config value for debug! To disable debugging just set it to \"false\"! (" + e.getMessage() + ")");
            }
        }
        this.getLogger().log(Level.INFO, "Debug level: " + this.getLogLevel().getName());
        this.messageChannelHandler.reload();
        if (this.getConfig().getBoolean("use-auth-plugin", this.getConfig().getBoolean("useauth", false))) {
            this.getLogger().log(Level.INFO, "Compatibility with backend authentication plugin ('use-auth-plugin') is enabled.");
        }
        this.lm = new LanguageManager((Plugin)this, this.getConfig().getString("default-language"), new BungeeLanguageConfig[0]);
        this.getPackManager().init();
        if (this.getConfig().isSet("packs", true) && this.getConfig().isSection("packs")) {
            this.getLogger().log(Level.INFO, "Loading packs:");
            Configuration packs = this.getConfig().getSection("packs");
            for (String s : packs.getKeys()) {
                if (!(packs.get(s) instanceof Configuration)) continue;
                Configuration packSection = packs.getSection(s);
                try {
                    ResourcePack pack = this.getPackManager().loadPack(s, this.getConfigMap(packSection));
                    this.getLogger().log(Level.INFO, pack.getName() + " - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                    ResourcePack previous = this.getPackManager().addPack(pack);
                    if (previous != null) {
                        this.getLogger().log(Level.WARNING, "Multiple resource packs with name '" + previous.getName().toLowerCase() + "' found!");
                    }
                    this.logDebug(pack.serialize().toString());
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().log(Level.SEVERE, "Error while loading pack " + s, e);
                }
            }
        } else {
            this.logDebug("No packs defined!");
        }
        if (this.getConfig().isSection("empty")) {
            Configuration packSection = this.getConfig().getSection("empty");
            try {
                ResourcePack pack = this.getPackManager().loadPack("empty", this.getConfigMap(packSection));
                this.getLogger().log(Level.INFO, "Empty pack - " + (pack.getVariants().isEmpty() ? pack.getUrl() + " - " + pack.getHash() : pack.getVariants().size() + " variants"));
                this.getPackManager().addPack(pack);
                this.getPackManager().setEmptyPack(pack);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Error while loading empty pack", e);
            }
        } else {
            String emptypackname = this.getConfig().getString("empty");
            if (emptypackname != null && !emptypackname.isEmpty()) {
                ResourcePack ep = this.getPackManager().getByName(emptypackname);
                if (ep != null) {
                    this.getLogger().log(Level.INFO, "Empty pack: " + ep.getName());
                    this.getPackManager().setEmptyPack(ep);
                } else {
                    this.getLogger().log(Level.WARNING, "Cannot set empty resourcepack as there is no pack with the name " + emptypackname + " defined!");
                }
            } else {
                this.getLogger().log(Level.WARNING, "No empty pack defined!");
            }
        }
        if (this.getConfig().isSet("global", true) && this.getConfig().isSection("global")) {
            this.getLogger().log(Level.INFO, "Loading global assignment...");
            Configuration globalSection = this.getConfig().getSection("global");
            PackAssignment globalAssignment = this.getPackManager().loadAssignment("global", this.getValues(globalSection));
            this.getPackManager().setGlobalAssignment(globalAssignment);
            this.logDebug("Loaded " + globalAssignment.toString());
        } else {
            this.logDebug("No global assignment defined!");
        }
        if (this.getConfig().isSet("servers", true) && this.getConfig().isSection("servers")) {
            this.getLogger().log(Level.INFO, "Loading server assignments...");
            Configuration servers = this.getConfig().getSection("servers");
            for (String server : servers.getKeys()) {
                if (!(servers.get(server) instanceof Configuration)) continue;
                Configuration serverSection = servers.getSection(server);
                if (!serverSection.getKeys().isEmpty()) {
                    this.getLogger().log(Level.INFO, "Loading assignment for server " + server + "...");
                    PackAssignment serverAssignment = this.getPackManager().loadAssignment(server, this.getValues(serverSection));
                    this.getPackManager().addAssignment(serverAssignment);
                    this.logDebug("Loaded server assignment " + serverAssignment.toString());
                    continue;
                }
                this.getLogger().log(Level.WARNING, "Config has entry for server " + server + " but it is not a configuration section?");
            }
        } else {
            this.logDebug("No server assignments defined!");
        }
        this.getPackManager().setStoredPacksOverride(this.getConfig().getBoolean("stored-packs-override-assignments"));
        this.logDebug("Stored packs override assignments: " + this.getPackManager().getStoredPacksOverride());
        this.getPackManager().setAppendHashToUrl(this.getConfig().getBoolean("append-hash-to-url"));
        this.logDebug("Append hash to pack URL: " + this.getPackManager().shouldAppendHashToUrl());
        return true;
    }

    @Override
    public Map<String, Object> getConfigMap(Object configuration) {
        if (configuration instanceof Map) {
            return (Map)configuration;
        }
        if (configuration instanceof Configuration) {
            return this.getValues((Configuration)configuration);
        }
        return null;
    }

    private Map<String, Object> getValues(Configuration config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : config.getKeys()) {
            Object value = config.get(key);
            if (value instanceof Configuration) {
                map.put(key, this.getValues((Configuration)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void reloadConfig(boolean resend) {
        this.loadConfig();
        this.getLogger().log(Level.INFO, "Reloaded config.");
        if (this.isEnabled() && resend) {
            this.getLogger().log(Level.INFO, "Resending packs for all online players!");
            this.getUserManager().clearUserPacks();
            for (ProxiedPlayer p : this.getProxy().getPlayers()) {
                this.resendPack(p);
            }
        }
    }

    @Override
    public void saveConfigChanges() {
        this.getConfig().set("packs", null);
        for (ResourcePack resourcePack : this.getPackManager().getPacks()) {
            if (resourcePack.getName().startsWith("backend-")) continue;
            String path = "packs." + resourcePack.getName();
            if (resourcePack.equals(this.getPackManager().getEmptyPack()) && this.getConfig().isSection("empty")) {
                path = "empty";
            }
            this.setConfigFlat(path, resourcePack.serialize());
        }
        this.setConfigFlat(this.getPackManager().getGlobalAssignment().getName(), this.getPackManager().getGlobalAssignment().serialize());
        for (PackAssignment packAssignment : this.getPackManager().getAssignments()) {
            this.setConfigFlat("servers." + packAssignment.getName(), packAssignment.serialize());
        }
        this.getConfig().saveConfig();
    }

    private boolean setConfigFlat(String rootKey, Map<String, Object> map) {
        boolean isEmpty = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                isEmpty &= this.setConfigFlat(rootKey + "." + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof List) {
                ((List)entry.getValue()).removeIf(e -> {
                    if (e instanceof Map) {
                        ((Map)e).entrySet().removeIf(le -> le.getValue() == null);
                        return ((Map)e).isEmpty();
                    }
                    return false;
                });
            }
            this.getConfig().set(rootKey + "." + entry.getKey(), entry.getValue());
            if (entry.getValue() == null || entry.getValue() instanceof Collection && ((Collection)entry.getValue()).isEmpty()) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            this.getConfig().set(rootKey, null);
        }
        return isEmpty;
    }

    @Override
    public void setStoredPack(UUID playerId, String packName) {
        if (this.storedPacks != null) {
            this.storedPacks.set("players." + playerId, packName);
            this.storedPacks.saveConfig();
        }
    }

    @Override
    public String getStoredPack(UUID playerId) {
        return this.storedPacks != null ? this.storedPacks.getString("players." + playerId.toString(), null) : null;
    }

    public Configuration getStoredPacks() {
        return this.storedPacks.getSection("players");
    }

    @Override
    public boolean isUsepackTemporary() {
        return this.getConfig().getBoolean("usepack-is-temporary");
    }

    @Override
    public boolean areSelectedPacksRemovingExisting() {
        return this.getConfig().getBoolean("selected-packs-remove-existing");
    }

    @Override
    public int getPermanentPackRemoveTime() {
        return this.getConfig().getInt("permanent-pack-remove-time");
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.PROXY;
    }

    public static BungeeResourcepacks getInstance() {
        return instance;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void resendPack(ProxiedPlayer player) {
        String serverName = "";
        if (player.getServer() != null) {
            serverName = player.getServer().getInfo().getName();
        }
        this.getPackManager().applyPack(this.getPlayer(player), serverName);
    }

    @Override
    public void resendPack(UUID playerId) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.resendPack(player);
        }
    }

    protected void sendPack(ProxiedPlayer player, ResourcePack pack) {
        int clientVersion = player.getPendingConnection().getVersion();
        if (clientVersion >= MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber() && (pack == null || pack == this.getPackManager().getEmptyPack())) {
            ResourcePackRemovePacket packet = new ResourcePackRemovePacket();
            try {
                ((UserConnection)player).sendPacketQueued((DefinedPacket)packet);
            }
            catch (Throwable t) {
                player.unsafe().sendPacket((DefinedPacket)packet);
            }
            this.logDebug("Cleared all packs of " + player.getName());
        } else if (clientVersion >= MinecraftVersion.MINECRAFT_1_8.getProtocolNumber()) {
            try {
                ResourcePackSendPacket packet = new ResourcePackSendPacket(pack.getUuid(), this.getPackManager().getPackUrl(pack), pack.getHash());
                try {
                    ((UserConnection)player).sendPacketQueued((DefinedPacket)packet);
                }
                catch (Throwable t) {
                    player.unsafe().sendPacket((DefinedPacket)packet);
                }
                this.logDebug("Send pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName());
            }
            catch (BadPacketException e) {
                this.getLogger().log(Level.SEVERE, e.getMessage() + " Please check for updates!");
            }
            catch (ClassCastException e) {
                this.getLogger().log(Level.SEVERE, "Packet defined was not ResourcePackSendPacket? Please check for updates!");
            }
        } else {
            this.getLogger().log(Level.WARNING, "Cannot send the pack " + pack.getName() + " (" + pack.getUrl() + ") to " + player.getName() + " as he uses the unsupported protocol version " + clientVersion + "!");
            this.getLogger().log(Level.WARNING, "Consider blocking access to your server for clients with version under 1.8 if you want this plugin to work for everyone!");
        }
    }

    @Override
    public void sendPackInfo(UUID playerId) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.sendPackInfo(player, this.getUserManager().getUserPacks(playerId));
        }
    }

    private void sendPackInfo(ProxiedPlayer player, List<ResourcePack> packs) {
        if (player.getServer() == null) {
            this.logDebug("Tried to send pack info of " + packs.size() + " packs for player " + player.getName() + " but server was null!");
            return;
        }
        if (!packs.isEmpty()) {
            this.getMessageChannelHandler().sendMessage(player.getServer(), "packsChange", (ByteArrayDataOutput out) -> {
                out.writeUTF(player.getName());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
                out.writeInt(packs.size());
                for (ResourcePack pack : packs) {
                    out.writeUTF(pack.getName());
                    out.writeUTF(pack.getUrl());
                    out.writeUTF(pack.getHash());
                    out.writeLong(pack.getUuid().getMostSignificantBits());
                    out.writeLong(pack.getUuid().getLeastSignificantBits());
                }
            });
        } else {
            this.getMessageChannelHandler().sendMessage(player.getServer(), "clearPack", (ByteArrayDataOutput out) -> {
                out.writeUTF(player.getName());
                out.writeLong(player.getUniqueId().getMostSignificantBits());
                out.writeLong(player.getUniqueId().getLeastSignificantBits());
            });
        }
    }

    @Override
    public void sendPack(UUID playerId, ResourcePack pack) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.sendPack(player, pack);
        }
    }

    @Override
    public void removePack(UUID playerId, ResourcePack pack) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerId);
        if (player != null) {
            this.removePack(player, pack);
        }
    }

    private void removePack(ProxiedPlayer player, ResourcePack pack) {
        if (pack.getUuid() != null) {
            ResourcePackRemovePacket packet = new ResourcePackRemovePacket(pack.getUuid());
            try {
                ((UserConnection)player).sendPacketQueued((DefinedPacket)packet);
            }
            catch (Throwable t) {
                player.unsafe().sendPacket((DefinedPacket)packet);
            }
            this.logDebug("Removed pack " + pack.getName() + " (" + pack.getUuid() + ") from " + player.getName());
        }
        this.sendPackRemoveInfo(player, pack);
    }

    private void sendPackRemoveInfo(ProxiedPlayer player, ResourcePack pack) {
        if (player.getServer() == null) {
            this.logDebug("Tried to send pack removal info of pack " + pack.getName() + " for player " + player.getName() + " but server was null!");
            return;
        }
        this.getMessageChannelHandler().sendMessage(player.getServer(), "removePack", (ByteArrayDataOutput out) -> {
            out.writeUTF(player.getName());
            out.writeLong(player.getUniqueId().getMostSignificantBits());
            out.writeLong(player.getUniqueId().getLeastSignificantBits());
            this.getMessageChannelHandler().writePack((ByteArrayDataOutput)out, pack);
        });
    }

    public void clearPack(ProxiedPlayer player) {
        this.getUserManager().clearUserPacks(player.getUniqueId());
    }

    @Override
    public void clearPack(UUID playerId) {
        this.getUserManager().clearUserPacks(playerId);
    }

    @Override
    public PackManager getPackManager() {
        return this.pm;
    }

    @Override
    public UserManager getUserManager() {
        return this.um;
    }

    public void setBackend(UUID playerId) {
        this.backendPackedPlayers.put(playerId, false);
    }

    public void unsetBackend(UUID playerId) {
        this.backendPackedPlayers.remove(playerId);
    }

    public boolean hasBackend(UUID playerId) {
        return this.backendPackedPlayers.containsKey(playerId);
    }

    @Override
    public String getMessage(ResourcepacksPlayer sender, String key, String ... replacements) {
        return TextComponent.toLegacyText((BaseComponent[])this.getComponents(sender, key, replacements));
    }

    public BaseComponent[] getComponents(ResourcepacksPlayer sender, String key, String ... replacements) {
        if (this.lm != null) {
            LanguageConfig config;
            ProxiedPlayer player = null;
            if (sender != null) {
                player = this.getProxy().getPlayer(sender.getUniqueId());
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return MineDown.parse(config.get(key), replacements);
            }
            return TextComponent.fromLegacyText((String)("Missing language config! (default language: " + this.lm.getDefaultLocale() + ", key: " + key + ")"));
        }
        return TextComponent.fromLegacyText((String)key);
    }

    @Override
    public boolean hasMessage(ResourcepacksPlayer sender, String key) {
        if (this.lm != null) {
            LanguageConfig config;
            ProxiedPlayer player = null;
            if (sender != null) {
                player = this.getProxy().getPlayer(sender.getUniqueId());
            }
            if ((config = this.lm.getConfig(player)) != null) {
                return config.contains(key, true);
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.getDescription().getName();
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.pluginLogger;
    }

    @Override
    public void logDebug(String message) {
        this.logDebug(message, null);
    }

    @Override
    public void logDebug(String message, Throwable throwable) {
        if (this.getLogLevel() != Level.OFF) {
            this.getLogger().log(this.getLogLevel(), "[DEBUG] " + message, throwable);
        }
    }

    @Override
    public Level getLogLevel() {
        return this.loglevel;
    }

    @Override
    public ResourcepacksPlayer getPlayer(UUID playerId) {
        return this.getPlayer(this.getProxy().getPlayer(playerId));
    }

    @Override
    public ResourcepacksPlayer getPlayer(String playerName) {
        return this.getPlayer(this.getProxy().getPlayer(playerName));
    }

    public ResourcepacksPlayer getPlayer(ProxiedPlayer player) {
        return player != null ? new ResourcepacksPlayer(player.getName(), player.getUniqueId()) : null;
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, String key, String ... replacements) {
        return this.sendMessage(player, Level.INFO, key, replacements);
    }

    @Override
    public boolean sendMessage(ResourcepacksPlayer player, Level level, String key, String ... replacements) {
        BaseComponent[] message = this.getComponents(player, key, replacements);
        if (message.length == 0) {
            return false;
        }
        if (player != null) {
            ProxiedPlayer proxyPlayer = this.getProxy().getPlayer(player.getUniqueId());
            if (proxyPlayer != null) {
                proxyPlayer.sendMessage(message);
                return true;
            }
        } else {
            this.log(level, TextComponent.toLegacyText((BaseComponent[])message));
        }
        return false;
    }

    @Override
    public void log(Level level, String message) {
        this.getLogger().log(level, ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    @Override
    public void log(Level level, String message, Throwable throwable) {
        this.getLogger().log(level, ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)), throwable);
    }

    @Override
    public boolean checkPermission(ResourcepacksPlayer player, String perm) {
        if (player == null) {
            return true;
        }
        return this.checkPermission(player.getUniqueId(), perm);
    }

    @Override
    public boolean checkPermission(UUID playerId, String perm) {
        ProxiedPlayer proxiedPlayer = this.getProxy().getPlayer(playerId);
        if (proxiedPlayer != null) {
            return proxiedPlayer.hasPermission(perm);
        }
        return perm == null;
    }

    @Override
    public int getPlayerProtocol(UUID playerId) {
        if (this.viaApi != null) {
            return this.viaApi.getPlayerVersion(playerId);
        }
        ProxiedPlayer proxiedPlayer = this.getProxy().getPlayer(playerId);
        if (proxiedPlayer != null) {
            return proxiedPlayer.getPendingConnection().getVersion();
        }
        return -1;
    }

    @Override
    public ClientType getPlayerClientType(UUID playerId) {
        if (this.geyser != null && this.geyser.isBedrockPlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.floodgate != null && this.floodgate.isFloodgatePlayer(playerId)) {
            return ClientType.BEDROCK;
        }
        if (this.geyser != null || this.floodgate != null) {
            return ClientType.ORIGINAL;
        }
        return ResourcepacksPlugin.super.getPlayerClientType(playerId);
    }

    @Override
    public IResourcePackSelectEvent callPackSelectEvent(UUID playerId, List<ResourcePack> packs, IResourcePackSelectEvent.Status status) {
        ResourcePackSelectEvent selectEvent = new ResourcePackSelectEvent(playerId, packs, status);
        this.getProxy().getPluginManager().callEvent((Event)selectEvent);
        return selectEvent;
    }

    @Override
    public IResourcePackSendEvent callPackSendEvent(UUID playerId, ResourcePack pack) {
        ResourcePackSendEvent sendEvent = new ResourcePackSendEvent(playerId, pack);
        this.getProxy().getPluginManager().callEvent((Event)sendEvent);
        return sendEvent;
    }

    @Override
    public boolean isAuthenticated(UUID playerId) {
        return !this.getConfig().getBoolean("use-auth-plugin", this.getConfig().getBoolean("useauth", false)) || this.authenticatedPlayers.contains(playerId);
    }

    @Override
    public int runTask(Runnable runnable) {
        return this.getProxy().getScheduler().schedule((Plugin)this, runnable, 0L, TimeUnit.MICROSECONDS).getId();
    }

    @Override
    public int runAsyncTask(Runnable runnable) {
        return this.getProxy().getScheduler().runAsync((Plugin)this, runnable).getId();
    }

    public void setAuthenticated(UUID playerId, boolean b) {
        if (b) {
            this.authenticatedPlayers.add(playerId);
        } else {
            this.authenticatedPlayers.remove(playerId);
        }
    }

    public int getBungeeVersion() {
        return this.bungeeVersion;
    }

    public SubChannelHandler<Server> getMessageChannelHandler() {
        return this.messageChannelHandler;
    }
}

