/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import de.themoep.resourcepacksplugin.core.ClientType;
import de.themoep.resourcepacksplugin.core.MinecraftVersion;
import de.themoep.resourcepacksplugin.core.PackAssignment;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlayer;
import de.themoep.resourcepacksplugin.core.ResourcepacksPlugin;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSelectEvent;
import de.themoep.resourcepacksplugin.core.events.IResourcePackSendEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PackManager {
    public static final String EMPTY_IDENTIFIER = "empty";
    public static final String HASH_KEY = "#hash=";
    private static final String[] URL_DENY_LIST = new String[]{"drive.google.com", "mediafire.com"};
    private static final String[] URL_WARN_LIST = new String[]{"dropbox.com"};
    private static final int[] PACK_FORMATS = new int[]{MinecraftVersion.MINECRAFT_1_21_7.getProtocolNumber(), 64, MinecraftVersion.MINECRAFT_1_21_6.getProtocolNumber(), 63, MinecraftVersion.MINECRAFT_1_21_5.getProtocolNumber(), 55, MinecraftVersion.MINECRAFT_1_21_4.getProtocolNumber(), 46, MinecraftVersion.MINECRAFT_1_21_2.getProtocolNumber(), 42, MinecraftVersion.MINECRAFT_1_21.getProtocolNumber(), 34, MinecraftVersion.MINECRAFT_1_20_5.getProtocolNumber(), 32, MinecraftVersion.MINECRAFT_1_20_3.getProtocolNumber(), 22, MinecraftVersion.MINECRAFT_1_20_2.getProtocolNumber(), 18, MinecraftVersion.MINECRAFT_1_20.getProtocolNumber(), 15, MinecraftVersion.MINECRAFT_1_19_4.getProtocolNumber(), 13, MinecraftVersion.MINECRAFT_1_19_3.getProtocolNumber(), 12, MinecraftVersion.MINECRAFT_1_19.getProtocolNumber(), 9, MinecraftVersion.MINECRAFT_1_18.getProtocolNumber(), 8, MinecraftVersion.MINECRAFT_1_17.getProtocolNumber(), 7, 749, 6, 565, 5, 348, 4, 210, 3, 49, 2, 47, 1, 0, 0};
    private final ResourcepacksPlugin plugin;
    private WatchService watchService = null;
    private Multimap<WatchKey, BiConsumer<Path, WatchEvent.Kind<Path>>> fileWatchers;
    private Map<String, ResourcePack> packNames;
    private Map<UUID, ResourcePack> packUuids;
    private Map<String, ResourcePack> packHashes;
    private Map<String, ResourcePack> packUrls;
    private ResourcePack empty = null;
    private PackAssignment global = new PackAssignment("global");
    private Map<String, PackAssignment> literalAssignments;
    private Map<String, PackAssignment> regexAssignments;
    private boolean dirty = false;
    private boolean storedPacksOverride;
    private boolean appendHashToUrl = true;

    public PackManager(ResourcepacksPlugin plugin) {
        this.plugin = plugin;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            plugin.log(Level.WARNING, "Unable to create file watcher!", e);
        }
    }

    public void init() {
        this.packNames = new LinkedHashMap<String, ResourcePack>();
        this.packUuids = new HashMap<UUID, ResourcePack>();
        this.packHashes = new HashMap<String, ResourcePack>();
        this.packUrls = new HashMap<String, ResourcePack>();
        this.empty = null;
        this.global = new PackAssignment("global");
        this.literalAssignments = new LinkedHashMap<String, PackAssignment>();
        this.regexAssignments = new LinkedHashMap<String, PackAssignment>();
        this.fileWatchers = MultimapBuilder.hashKeys().linkedListValues().build();
        this.plugin.runAsyncTask(() -> {
            try {
                while (true) {
                    WatchKey key = this.watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Collection watchers = this.fileWatchers.get((Object)key);
                        this.plugin.logDebug("Received file change event " + event.kind() + " of " + event.context() + " with " + watchers.size() + " watchers!");
                        WatchEvent<?> watchEvent = event;
                        for (BiConsumer watcher : watchers) {
                            watcher.accept((Path)watchEvent.context(), watchEvent.kind());
                        }
                    }
                    key.reset();
                }
            }
            catch (InterruptedException | ClosedWatchServiceException ignored) {
                return;
            }
        });
    }

    private void registerFileWatcher(Path path, Consumer<Path> consumer) {
        consumer.accept(path);
        if (this.watchService == null) {
            return;
        }
        Path dir = path;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            dir = path.toAbsolutePath().getParent();
        }
        try {
            WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.fileWatchers.put((Object)key, (p, k) -> {
                if (path.getFileName().equals(p.getFileName())) {
                    consumer.accept(path);
                }
            });
        }
        catch (IOException e) {
            try {
                this.watchService.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.watchService = null;
            this.plugin.log(Level.WARNING, "Unable to register file watcher. Falling back to manual calculation!", e);
        }
    }

    private void registerPackHashWatcher(ResourcePack pack) {
        if (pack.getLocalPath() == null || pack.getLocalPath().isEmpty()) {
            return;
        }
        Path path = Paths.get(pack.getLocalPath(), new String[0]);
        this.registerFileWatcher(path, p -> {
            try {
                if (Files.isRegularFile(p, new LinkOption[0])) {
                    byte[] bytes = Files.readAllBytes(p);
                    HashCode hash = Hashing.sha1().hashBytes(bytes);
                    this.setPackHash(pack, hash.toString());
                }
            }
            catch (IOException e) {
                this.plugin.getPluginLogger().log(Level.WARNING, "Unable to create hash of " + path, e);
            }
        });
    }

    public ResourcePack loadPack(String name, Map<String, Object> config) throws IllegalArgumentException {
        return this.loadPack(null, name, config);
    }

    private ResourcePack loadPack(ResourcePack parent, String name, Map<String, Object> config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("Pack " + name + " had a null config?");
        }
        String url = PackManager.get(config, "url", "");
        this.validateUrl(url);
        List variantsList = PackManager.get(config, "variants", new ArrayList());
        if (url.isEmpty() && variantsList.isEmpty()) {
            throw new IllegalArgumentException("Pack " + name + " does not have an url defined!");
        }
        String uuidStr = PackManager.get(config, "uuid", "");
        UUID uuid = uuidStr.isEmpty() ? UUID.nameUUIDFromBytes(url.getBytes()) : UUID.fromString(uuidStr);
        String hash = PackManager.get(config, "hash", "");
        String localPath = PackManager.get(config, "local-path", "");
        int format = PackManager.get(config, "format", 0);
        String mcVersion = PackManager.get(config, "version", String.valueOf(PackManager.get(config, "version", 0)));
        boolean restricted = PackManager.get(config, "restricted", false);
        String perm = PackManager.get(config, "permission", this.plugin.getName().toLowerCase(Locale.ROOT) + ".pack." + name);
        ClientType type = ClientType.valueOf(PackManager.get(config, "type", "original").toUpperCase(Locale.ROOT));
        ResourcePack pack = new ResourcePack(parent, name, uuid, url, hash, localPath, format, 0, restricted, perm, type);
        try {
            pack.setVersion(mcVersion);
        }
        catch (IllegalArgumentException e) {
            this.plugin.log(Level.WARNING, "Unable to set version of pack " + name + ". " + e.getMessage());
        }
        for (int i = 0; i < variantsList.size(); ++i) {
            pack.getVariants().add(this.loadPack(pack, name + "-variant-" + (i + 1), this.plugin.getConfigMap(variantsList.get(i))));
        }
        return pack;
    }

    private static <T> T get(Map<String, Object> config, String path, T def) {
        Object o = config.getOrDefault(path, def);
        if (o != null && def != null && def.getClass().isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return def;
    }

    private void validateUrl(String url) throws IllegalArgumentException {
        for (String deny : URL_DENY_LIST) {
            if (!url.contains(deny)) continue;
            throw new IllegalArgumentException("URL " + url + " is not allowed! " + deny + " does not work for hosting packs as they either block downloads from the Minecraft client or do not provide permanent direct links! Use your own webserver or https://mc-packs.net to host the pack instead!");
        }
        for (String warn : URL_WARN_LIST) {
            if (!url.contains(warn)) continue;
            this.plugin.log(Level.WARNING, "Detected a potential issue with pack URL " + url + ": " + warn + " might not reliably work for hosting packs as they tend to eventually block downloads from the Minecraft client! Use your own webserver or https://mc-packs.net to host the pack instead!");
        }
    }

    public ResourcePack addPack(ResourcePack pack) throws IllegalArgumentException {
        if (pack.getVariants().isEmpty()) {
            this.cacheVariant(pack, pack);
        } else {
            for (ResourcePack variant : pack.getVariants()) {
                this.cacheVariant(variant, pack);
            }
        }
        return this.packNames.put(pack.getName().toLowerCase(Locale.ROOT), pack);
    }

    public boolean removePack(ResourcePack pack) {
        boolean known = false;
        if (pack.getVariants().isEmpty()) {
            if (pack.getUrl() != null && pack.getUrl().isEmpty()) {
                known |= this.packUrls.remove(pack.getUrl(), pack);
            }
            if (pack.getUuid() != null) {
                known |= this.packUuids.remove(pack.getUuid(), pack);
            }
            if (pack.getHash().length() > 0) {
                known |= this.packHashes.remove(pack.getHash(), pack);
            }
        } else {
            for (ResourcePack variant : pack.getVariants()) {
                known |= this.uncacheVariant(variant, pack);
            }
        }
        return this.packNames.remove(pack.getName().toLowerCase(Locale.ROOT), pack) || known;
    }

    private void cacheVariant(ResourcePack variant, ResourcePack pack) throws IllegalArgumentException {
        if (variant.getVariants().isEmpty()) {
            try {
                this.ensureUniqueData(variant, pack.getName());
                if (variant.getUrl() != null && !variant.getUrl().isEmpty()) {
                    this.packUrls.putIfAbsent(variant.getUrl(), pack);
                }
                if (variant.getHash().length() > 0) {
                    this.packHashes.put(variant.getHash(), pack);
                }
                if (variant.getUuid() != null) {
                    this.packUuids.put(variant.getUuid(), pack);
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.log(Level.WARNING, e.getMessage() + " This might cause issues in some cases especially when sending packs from a Minecraft server with this plugin on the proxy!");
            }
            this.registerPackHashWatcher(variant);
        } else {
            for (ResourcePack variantVariant : variant.getVariants()) {
                this.cacheVariant(variantVariant, pack);
            }
        }
    }

    private void ensureUniqueData(ResourcePack pack, String packName) {
        ResourcePack byUrl;
        ResourcePack byHash = this.getByHash(pack.getHash());
        if (byHash != null && !byHash.getName().equalsIgnoreCase(packName)) {
            throw new IllegalArgumentException("There is already a pack with same hash '" + pack.getHash() + "' as pack '" + packName + "' (" + pack.getName() + ") defined: " + byHash.getName());
        }
        ResourcePack byUuid = this.getByUuid(pack.getUuid());
        if (byUuid != null && !byUuid.getName().equalsIgnoreCase(packName)) {
            throw new IllegalArgumentException("There is already a pack with same uuid '" + pack.getUuid() + "' as pack '" + packName + "' (" + pack.getName() + ") defined: " + byUuid.getName());
        }
        if (pack.getUrl() != null && !pack.getUrl().isEmpty() && (byUrl = this.getByUrl(pack.getUrl())) != null && !byUrl.getName().equalsIgnoreCase(packName)) {
            throw new IllegalArgumentException("There is already a pack with same url '" + pack.getUrl() + "' as pack '" + packName + "' (" + pack.getName() + ") defined: " + byUrl.getName());
        }
    }

    private boolean uncacheVariant(ResourcePack variant, ResourcePack pack) {
        boolean known = false;
        if (variant.getVariants().isEmpty()) {
            known |= this.packUrls.remove(variant.getUrl(), pack);
            known |= this.packHashes.remove(variant.getHash(), pack);
            known |= this.packUuids.remove(variant.getUuid(), pack);
        } else {
            for (ResourcePack variantVariant : variant.getVariants()) {
                known |= this.uncacheVariant(variantVariant, pack);
            }
        }
        return known;
    }

    public boolean setPackUuid(ResourcePack pack, UUID uuid) {
        if (pack.getUuid().equals(uuid)) {
            return false;
        }
        this.packUuids.remove(pack.getUuid());
        pack.setUuid(uuid);
        this.packUuids.put(pack.getUuid(), pack);
        return true;
    }

    public boolean setPackHash(ResourcePack pack, String hash) {
        if (pack.getHash().equals(hash)) {
            return false;
        }
        this.packHashes.remove(pack.getHash());
        pack.setHash(hash);
        this.packHashes.put(pack.getHash(), pack);
        return true;
    }

    public boolean setPackUrl(ResourcePack pack, String url) {
        if (pack.getUrl().equals(url)) {
            return false;
        }
        this.packUrls.remove(pack.getUrl());
        pack.setUrl(url);
        this.packUrls.put(pack.getUrl(), pack);
        return true;
    }

    public boolean setPackPath(ResourcePack pack, String path) {
        String oldPath = pack.getLocalPath();
        if (path == null && oldPath != null) {
            pack.setLocalPath(null);
            return true;
        }
        if (oldPath == null || oldPath.equals(path)) {
            return false;
        }
        pack.setLocalPath(path);
        this.registerPackHashWatcher(pack);
        return true;
    }

    public ResourcePack getByName(String name) {
        return name != null ? this.packNames.get(name.toLowerCase(Locale.ROOT)) : null;
    }

    public ResourcePack getByUuid(UUID uuid) {
        return this.packUuids.get(uuid);
    }

    public ResourcePack getByHash(String hash) {
        return this.packHashes.get(hash);
    }

    public ResourcePack getByHash(byte[] hash) {
        return this.packHashes.get(BaseEncoding.base16().lowerCase().encode(hash));
    }

    public ResourcePack getByUrl(String url) {
        if (url.contains(HASH_KEY)) {
            url = url.substring(0, url.lastIndexOf(HASH_KEY));
        }
        return this.packUrls.get(url);
    }

    public ResourcePack setEmptyPack(ResourcePack pack) {
        ResourcePack rp = this.getEmptyPack();
        this.empty = pack;
        return rp;
    }

    public ResourcePack setEmptyPack(String packname) {
        return this.setEmptyPack(this.getByName(packname));
    }

    public ResourcePack getEmptyPack() {
        return this.empty;
    }

    public void setStoredPacksOverride(boolean playerPacksOverride) {
        this.storedPacksOverride = playerPacksOverride;
    }

    public boolean getStoredPacksOverride() {
        return this.storedPacksOverride;
    }

    public PackAssignment getGlobalAssignment() {
        return this.global;
    }

    public void setGlobalAssignment(PackAssignment assignment) {
        this.global = assignment;
    }

    public PackAssignment addAssignment(PackAssignment assignment) {
        PackAssignment previous = assignment.getRegex() != null ? this.regexAssignments.put(assignment.getName().toLowerCase(Locale.ROOT), assignment) : this.literalAssignments.put(assignment.getName().toLowerCase(Locale.ROOT), assignment);
        this.checkDirty();
        return previous;
    }

    public @NonNull PackAssignment getAssignment(String server) {
        PackAssignment assignment = this.literalAssignments.get(server.toLowerCase(Locale.ROOT));
        if (assignment != null) {
            return assignment;
        }
        for (PackAssignment regexAssignment : this.regexAssignments.values()) {
            if (!regexAssignment.getRegex().matcher(server).matches()) continue;
            return regexAssignment;
        }
        return new PackAssignment(EMPTY_IDENTIFIER);
    }

    public PackAssignment getAssignmentByName(String name) {
        PackAssignment assignment = this.literalAssignments.get(name.toLowerCase(Locale.ROOT));
        if (assignment == null) {
            assignment = this.regexAssignments.get(name.toLowerCase(Locale.ROOT));
        }
        return assignment;
    }

    public Collection<? extends PackAssignment> getAssignments() {
        ArrayList<PackAssignment> assignments = new ArrayList<PackAssignment>(this.literalAssignments.values());
        assignments.addAll(this.regexAssignments.values());
        return assignments;
    }

    public PackAssignment loadAssignment(String name, Map<String, Object> config) {
        Object optionalPacks;
        ArrayList packs;
        PackAssignment assignment = new PackAssignment(name);
        if (config.get("regex") != null) {
            if (!(config.get("regex") instanceof String)) {
                this.plugin.log(Level.WARNING, "'regex' option has to be a String!");
            } else {
                try {
                    assignment.setRegex(Pattern.compile((String)config.get("regex")));
                    this.plugin.logDebug("Regex: " + assignment.getRegex().toString());
                }
                catch (PatternSyntaxException e) {
                    this.plugin.log(Level.WARNING, "The assignment's regex '" + config.get("regex") + "' isn't valid! Using the key name literally! (" + e.getMessage() + ")");
                }
            }
        }
        if (config.get("pack") != null) {
            if (!(config.get("pack") instanceof String)) {
                this.plugin.log(Level.WARNING, "'pack' option has to be a String!");
            } else if (!((String)config.get("pack")).isEmpty()) {
                ResourcePack pack = this.getByName((String)config.get("pack"));
                if (pack != null) {
                    assignment.addPack(pack);
                    this.plugin.logDebug("Pack: " + pack.getName());
                } else {
                    this.plugin.log(Level.WARNING, "No pack with the name " + config.get("pack") + " defined?");
                }
            }
        }
        if ((packs = config.getOrDefault("packs", new ArrayList())) != null) {
            if (!(packs instanceof List) || !((List)packs).isEmpty() && !(((List)packs).get(0) instanceof String)) {
                this.plugin.log(Level.WARNING, "'packs' option has to be a String List!");
            } else if (!((List)packs).isEmpty()) {
                this.plugin.logDebug("Packs:");
                List packName = packs;
                for (String secondaryPack : packName) {
                    ResourcePack pack = this.getByName(secondaryPack);
                    if (pack != null) {
                        assignment.addPack(pack);
                        this.plugin.logDebug("- " + pack.getName());
                        continue;
                    }
                    this.plugin.log(Level.WARNING, "No pack with the name " + secondaryPack + " defined?");
                }
            }
        }
        if ((optionalPacks = config.getOrDefault("optional-packs", config.get("secondary"))) != null) {
            if (!(optionalPacks instanceof List) || !((List)optionalPacks).isEmpty() && !(((List)optionalPacks).get(0) instanceof String)) {
                this.plugin.log(Level.WARNING, "'optional-packs' option has to be a String List!");
            } else {
                this.plugin.logDebug("Optional packs:");
                List optionalName = (List)optionalPacks;
                for (String secondaryPack : optionalName) {
                    ResourcePack pack = this.getByName(secondaryPack);
                    if (pack != null) {
                        assignment.addOptionalPack(pack);
                        this.plugin.logDebug("- " + pack.getName());
                        continue;
                    }
                    this.plugin.log(Level.WARNING, "No pack with the name " + secondaryPack + " defined?");
                }
            }
        }
        if (config.get("send-delay") != null) {
            if (!(config.get("send-delay") instanceof Number)) {
                this.plugin.log(Level.WARNING, "'send-delay' option has to be a number!");
            } else {
                assignment.setSendDelay(((Number)config.get("send-delay")).longValue());
                this.plugin.logDebug("Send delay: " + assignment.getSendDelay());
            }
        }
        return assignment;
    }

    @Deprecated
    public boolean removeServer(String server) {
        return this.removeAssignment(server);
    }

    public boolean removeAssignment(String key) {
        if (this.literalAssignments.remove(key.toLowerCase(Locale.ROOT)) != null) {
            this.regexAssignments.remove(key.toLowerCase(Locale.ROOT));
            this.checkDirty();
            return true;
        }
        return false;
    }

    public boolean removeAssignment(PackAssignment assignment) {
        boolean removed = assignment.getRegex() != null ? this.regexAssignments.remove(assignment.getName().toLowerCase(Locale.ROOT)) != null : this.literalAssignments.remove(assignment.getName().toLowerCase(Locale.ROOT)) != null;
        this.checkDirty();
        return removed;
    }

    private void removePack(UUID playerId, ResourcePack pack) {
        if (!this.plugin.supportsMultiplePacks(playerId)) {
            throw new UnsupportedOperationException("The client version of " + playerId + " does not support pack removal!");
        }
        this.plugin.getUserManager().removeUserPack(playerId, pack);
        this.plugin.removePack(playerId, pack);
        for (ResourcePack variant : pack.getVariants()) {
            this.plugin.removePack(playerId, variant);
        }
    }

    public @NonNull PackSetResult setPack(UUID playerId, ResourcePack pack) {
        return this.setPack(playerId, pack, true);
    }

    public @NonNull PackSetResult setPack(UUID playerId, ResourcePack pack, boolean temporary) {
        return this.setPack(playerId, pack, temporary, pack == null || pack.equals(this.getEmptyPack()));
    }

    public @NonNull PackSetResult setPack(UUID playerId, ResourcePack pack, boolean temporary, boolean removeExisting) {
        Object stored;
        List<ResourcePack> prev = this.plugin.getUserManager().getUserPacks(playerId);
        if (!temporary) {
            if (pack == null) {
                this.plugin.setStoredPack(playerId, null);
            } else {
                this.plugin.setStoredPack(playerId, ((ResourcePack)pack).getName());
                this.plugin.getUserManager().updatePackTime(playerId);
            }
        }
        if (pack == null && (stored = this.getByName(this.plugin.getStoredPack(playerId))) != null && this.checkPack(playerId, (ResourcePack)stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            pack = stored;
            this.plugin.logDebug(playerId + " has the pack " + ((ResourcePack)stored).getName() + " stored!");
        }
        if (this.plugin.supportsMultiplePacks(playerId) && removeExisting) {
            for (ResourcePack existing : prev) {
                if (existing == pack) continue;
                this.removePack(playerId, existing);
            }
        }
        if (pack != null && prev.contains(pack)) {
            ResourcePack variant = this.getMatchingVariant(playerId, (ResourcePack)pack).getPack();
            return new PackSetResult((ResourcePack)(variant != null ? variant : pack), IResourcePackSelectEvent.Status.ALREADY_APPLIED);
        }
        if (prev.isEmpty() && (pack == null || ((ResourcePack)pack).equals(this.getEmptyPack()))) {
            return new PackSetResult(null, IResourcePackSelectEvent.Status.IS_EMPTY);
        }
        if (pack != null && ((ResourcePack)pack).getType() == ClientType.BEDROCK) {
            return new PackSetResult(null, IResourcePackSelectEvent.Status.UNKNOWN);
        }
        IResourcePackSendEvent sendEvent = this.plugin.callPackSendEvent(playerId, (ResourcePack)pack);
        if (sendEvent.isCancelled()) {
            this.plugin.logDebug("Pack send event for " + playerId + " was cancelled!");
            return new PackSetResult(null, IResourcePackSelectEvent.Status.UNKNOWN);
        }
        pack = this.processSendEvent(sendEvent, prev);
        if (pack != null) {
            PackSetResult variant = this.getMatchingVariant(playerId, (ResourcePack)pack);
            if (variant.getPack() != null) {
                this.sendPack(playerId, variant.getPack());
            }
            return variant;
        }
        return new PackSetResult(null, IResourcePackSelectEvent.Status.UNKNOWN);
    }

    private PackSetResult getMatchingVariant(UUID playerId, ResourcePack pack) {
        if (pack.getVariants().isEmpty()) {
            return new PackSetResult(pack, IResourcePackSelectEvent.Status.SUCCESS);
        }
        IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.SUCCESS;
        for (ResourcePack variant : pack.getVariants()) {
            IResourcePackSelectEvent.Status varStatus = this.checkPack(playerId, variant, IResourcePackSelectEvent.Status.UNKNOWN);
            if (varStatus == IResourcePackSelectEvent.Status.SUCCESS) {
                return new PackSetResult(variant, IResourcePackSelectEvent.Status.SUCCESS);
            }
            if (varStatus.ordinal() <= status.ordinal()) continue;
            status = varStatus;
        }
        return new PackSetResult(null, status);
    }

    private void sendPack(UUID playerId, ResourcePack pack) {
        Path path;
        if (this.watchService == null && pack.getLocalPath() != null && !pack.getLocalPath().isEmpty() && Files.exists(path = Paths.get(pack.getLocalPath(), new String[0]), new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            this.plugin.runAsyncTask(() -> {
                try {
                    byte[] bytes = Files.readAllBytes(path);
                    HashCode hash = Hashing.sha1().hashBytes(bytes);
                    this.setPackHash(pack, hash.toString());
                }
                catch (IOException e) {
                    this.plugin.log(Level.WARNING, "Error while trying to read resource pack " + pack.getName() + " file from local path " + path, e);
                }
                this.plugin.runTask(() -> this.plugin.sendPack(playerId, pack));
            });
            return;
        }
        this.plugin.sendPack(playerId, pack);
    }

    public ResourcePack processSendEvent(IResourcePackSendEvent event, List<ResourcePack> prev) {
        ResourcePack pack = event.getPack();
        if (pack == null && !prev.isEmpty()) {
            pack = this.getEmptyPack();
        }
        if (pack != null && !prev.contains(pack)) {
            if (!this.plugin.supportsMultiplePacks(event.getPlayerId())) {
                this.plugin.getUserManager().clearUserPacks(event.getPlayerId());
            }
            this.plugin.getUserManager().addUserPack(event.getPlayerId(), pack);
            return pack;
        }
        return null;
    }

    @Deprecated
    public void applyPack(UUID playerId, String serverName) {
        this.applyPack(this.plugin.getPlayer(playerId), serverName);
    }

    public Set<ResourcePack> applyPack(ResourcepacksPlayer player, String serverName) {
        ResourcePack sentPack;
        UUID playerId = player.getUniqueId();
        LinkedHashSet<ResourcePack> sentPacks = new LinkedHashSet<ResourcePack>();
        LinkedHashSet<ResourcePack> packs = this.getApplicablePacks(player, serverName);
        if (this.plugin.supportsMultiplePacks(playerId)) {
            PackAssignment assignment = this.getAssignment(serverName);
            boolean packWasRemoved = false;
            List<ResourcePack> userPacks = this.plugin.getUserManager().getUserPacks(playerId);
            for (ResourcePack pack : userPacks) {
                if (packs.contains(pack) || this.getGlobalAssignment().isOptionalPack(pack) || assignment.isOptionalPack(pack)) continue;
                this.removePack(playerId, pack);
                packWasRemoved = true;
            }
            boolean alreadyHadPack = false;
            ArrayList<PackSetResult> appliedResults = new ArrayList<PackSetResult>();
            for (ResourcePack pack : packs) {
                PackSetResult packSetResult = this.setPack(playerId, pack);
                if (packSetResult.getPack() == null) continue;
                alreadyHadPack |= packSetResult.getStatus() == IResourcePackSelectEvent.Status.ALREADY_APPLIED;
                appliedResults.add(packSetResult);
            }
            if (!alreadyHadPack || packWasRemoved) {
                for (PackSetResult appliedResult : appliedResults) {
                    sentPacks.add(appliedResult.getPack());
                }
            }
        } else if (!packs.isEmpty() && (sentPack = this.setPack(playerId, (ResourcePack)packs.iterator().next()).getPack()) != null) {
            sentPacks.add(sentPack);
        }
        this.plugin.sendPackInfo(playerId);
        return sentPacks;
    }

    @Deprecated
    public LinkedHashSet<ResourcePack> getApplicablePacks(UUID playerId, String serverName) {
        return this.getApplicablePacks(this.plugin.getPlayer(playerId), serverName);
    }

    public LinkedHashSet<ResourcePack> getApplicablePacks(ResourcepacksPlayer player, String serverName) {
        IResourcePackSelectEvent selectEvent;
        UUID playerId = player.getUniqueId();
        List<ResourcePack> previousPacks = this.plugin.getUserManager().getUserPacks(playerId);
        LinkedHashSet<ResourcePack> packs = new LinkedHashSet<ResourcePack>();
        ResourcePack stored = this.getByName(this.plugin.getStoredPack(playerId));
        if (this.getStoredPacksOverride() && stored != null && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            if (previousPacks.contains(stored)) {
                this.plugin.logDebug(player.getName() + " already uses the stored pack " + stored.getName());
            } else {
                this.plugin.logDebug(player.getName() + " had the pack " + stored.getName() + " stored, using that");
            }
            packs.add(stored);
            return packs;
        }
        for (ResourcePack prev : previousPacks) {
            if (!this.getGlobalAssignment().isOptionalPack(prev) || this.checkPack(playerId, prev, IResourcePackSelectEvent.Status.SUCCESS) != IResourcePackSelectEvent.Status.SUCCESS) continue;
            this.plugin.logDebug(player.getName() + " matched global as they already have the pack " + prev.getName());
            packs.add(prev);
            if (this.plugin.supportsMultiplePacks(playerId)) continue;
            return packs;
        }
        if (stored != null && this.getGlobalAssignment().isOptionalPack(stored) && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
            this.plugin.logDebug(player.getName() + " has stored pack which matches the optional packs in the global assignment");
            packs.add(stored);
            if (!this.plugin.supportsMultiplePacks(playerId)) {
                return packs;
            }
        }
        String matchReason = " due to ";
        IResourcePackSelectEvent.Status status = IResourcePackSelectEvent.Status.UNKNOWN;
        if (serverName != null && !serverName.isEmpty()) {
            PackAssignment assignment = this.getAssignment(serverName);
            for (ResourcePack resourcePack : previousPacks) {
                if (!assignment.isOptionalPack(resourcePack) || this.checkPack(playerId, resourcePack, IResourcePackSelectEvent.Status.SUCCESS) != IResourcePackSelectEvent.Status.SUCCESS) continue;
                this.plugin.logDebug(player.getName() + " matched assignment " + assignment.getName() + " as they already have the pack " + resourcePack.getName());
                packs.add(resourcePack);
                if (this.plugin.supportsMultiplePacks(playerId)) continue;
                return packs;
            }
            if (stored != null && assignment.isOptionalPack(stored) && this.checkPack(playerId, stored, IResourcePackSelectEvent.Status.SUCCESS) == IResourcePackSelectEvent.Status.SUCCESS) {
                this.plugin.logDebug(player.getName() + " matched assignment " + assignment.getName() + " as their stored pack is an optional packs");
                packs.add(stored);
                if (!this.plugin.supportsMultiplePacks(playerId)) {
                    return packs;
                }
            }
            List serverPacks = assignment.getPacks().stream().map(this::getByName).collect(Collectors.toCollection(ArrayList::new));
            status = this.checkPacks(playerId, serverPacks, IResourcePackSelectEvent.Status.SUCCESS);
            matchReason = assignment.getName() + matchReason;
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                packs.addAll(serverPacks);
                matchReason = matchReason + "main packs";
            } else if (!(this.plugin.supportsMultiplePacks(playerId) || previousPacks.isEmpty() && serverPacks.isEmpty())) {
                for (String secondaryName : assignment.getOptionalPacks()) {
                    ResourcePack secondaryPack = this.getByName(secondaryName);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    packs.add(secondaryPack);
                    matchReason = matchReason + "secondary pack";
                    break;
                }
            }
        }
        if (packs.isEmpty()) {
            List globalPacks = this.getGlobalAssignment().getPacks().stream().map(this::getByName).collect(Collectors.toCollection(ArrayList::new));
            status = this.checkPacks(playerId, globalPacks, IResourcePackSelectEvent.Status.SUCCESS);
            matchReason = "global due to ";
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                packs.addAll(globalPacks);
                matchReason = matchReason + "main packs";
            } else if (!(this.plugin.supportsMultiplePacks(playerId) || previousPacks.isEmpty() && globalPacks.isEmpty())) {
                for (String string : this.getGlobalAssignment().getOptionalPacks()) {
                    ResourcePack secondaryPack = this.getByName(string);
                    status = this.checkPack(playerId, secondaryPack, status);
                    if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                    packs.add(secondaryPack);
                    matchReason = matchReason + "secondary pack";
                    break;
                }
            }
        }
        if (status == IResourcePackSelectEvent.Status.SUCCESS) {
            if (!packs.isEmpty()) {
                block4: for (ResourcePack pack : packs) {
                    if (pack.getVariants().isEmpty()) continue;
                    status = IResourcePackSelectEvent.Status.UNKNOWN;
                    for (ResourcePack variant : pack.getVariants()) {
                        status = this.checkPack(playerId, variant, status);
                        if (status != IResourcePackSelectEvent.Status.SUCCESS) continue;
                        matchReason = matchReason + " variant";
                        continue block4;
                    }
                }
            }
            if (status == IResourcePackSelectEvent.Status.SUCCESS) {
                this.plugin.logDebug(player.getName() + " matched assignment " + matchReason);
            }
        }
        if (!packs.isEmpty()) {
            EnumSet<IResourcePackSelectEvent.Status> packStatuses = EnumSet.of(status);
            for (ResourcePack resourcePack : packs) {
                if (resourcePack.getUrl().isEmpty() || resourcePack.getRawHash().length <= 0) continue;
                packStatuses.add(IResourcePackSelectEvent.Status.SUCCESS);
            }
            status = packStatuses.stream().reduce((a, b) -> a.ordinal() > b.ordinal() ? a : b).orElse(IResourcePackSelectEvent.Status.UNKNOWN);
        }
        if ((selectEvent = this.plugin.callPackSelectEvent(playerId, new ArrayList<ResourcePack>(packs), status)).getStatus() != IResourcePackSelectEvent.Status.SUCCESS) {
            this.plugin.logDebug(player.getName() + " ResourcePackSelectEvent Status: " + (Object)((Object)selectEvent.getStatus()));
        }
        return new LinkedHashSet<ResourcePack>(selectEvent.getPacks());
    }

    protected IResourcePackSelectEvent.Status checkPacks(UUID playerId, List<ResourcePack> packs, IResourcePackSelectEvent.Status status) {
        EnumSet<IResourcePackSelectEvent.Status> packStatuses = EnumSet.noneOf(IResourcePackSelectEvent.Status.class);
        Iterator<ResourcePack> it = packs.iterator();
        while (it.hasNext()) {
            ResourcePack pack = it.next();
            IResourcePackSelectEvent.Status packStatus = this.checkPack(playerId, pack, status);
            packStatuses.add(packStatus);
            if (packStatus == IResourcePackSelectEvent.Status.SUCCESS) continue;
            it.remove();
        }
        if (packStatuses.contains((Object)IResourcePackSelectEvent.Status.SUCCESS)) {
            if (packStatuses.size() == 1) {
                return IResourcePackSelectEvent.Status.SUCCESS;
            }
            return status;
        }
        return packStatuses.stream().reduce((a, b) -> a.ordinal() > b.ordinal() ? a : b).orElse(IResourcePackSelectEvent.Status.UNKNOWN);
    }

    protected IResourcePackSelectEvent.Status checkPack(UUID playerId, ResourcePack pack, IResourcePackSelectEvent.Status status) {
        boolean hasPermission;
        if (pack == null) {
            return status;
        }
        boolean rightFormat = pack.getType() == this.plugin.getPlayerClientType(playerId) && (this.plugin.getPlayerProtocol(playerId) < 0 || pack.getFormat() <= this.plugin.getPlayerPackFormat(playerId) && pack.getVersion() <= this.plugin.getPlayerProtocol(playerId));
        boolean bl = hasPermission = !pack.isRestricted() || this.plugin.checkPermission(playerId, pack.getPermission());
        if (rightFormat && hasPermission) {
            return IResourcePackSelectEvent.Status.SUCCESS;
        }
        if (status != IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION) {
            if (!rightFormat) {
                status = !hasPermission || status == IResourcePackSelectEvent.Status.NO_PERMISSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.WRONG_VERSION;
            }
            if (!hasPermission) {
                status = !rightFormat || status == IResourcePackSelectEvent.Status.WRONG_VERSION ? IResourcePackSelectEvent.Status.NO_PERM_AND_WRONG_VERSION : IResourcePackSelectEvent.Status.NO_PERMISSION;
            }
        }
        return status;
    }

    public List<ResourcePack> getPacks() {
        return new ArrayList<ResourcePack>(this.packNames.values());
    }

    public void generateHashes(ResourcepacksPlayer sender) {
        List<ResourcePack> packs = this.getPacks();
        this.plugin.runAsyncTask(() -> {
            this.plugin.sendMessage(sender, "generate-hashes.generating", new String[0]);
            int changed = 0;
            for (ResourcePack pack : packs) {
                if (pack.getName().startsWith("backend-")) continue;
                if (pack.getVariants().isEmpty()) {
                    if (!this.generateHash(sender, pack, pack)) continue;
                    ++changed;
                    continue;
                }
                for (ResourcePack packVariant : pack.getVariants()) {
                    if (!this.generateHash(sender, packVariant, pack)) continue;
                    ++changed;
                }
            }
            if (changed > 0) {
                this.plugin.sendMessage(sender, "generate-hashes.changed", "amount", String.valueOf(changed));
                this.plugin.runTask(this.plugin::saveConfigChanges);
            } else {
                this.plugin.sendMessage(sender, "generate-hashes.none-changed", new String[0]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean generateHash(ResourcepacksPlayer sender, ResourcePack pack, ResourcePack packToCache) {
        boolean changed = false;
        Path target = new File(this.plugin.getDataFolder(), pack.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "_") + "-downloaded.zip").toPath();
        InputStream in = null;
        URL url = new URL(pack.getUrl());
        this.plugin.sendMessage(sender, "generate-hashes.downloading", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty("User-Agent", this.plugin.getName() + "/" + this.plugin.getVersion());
        in = con.getInputStream();
        Files.copy(in, target, StandardCopyOption.REPLACE_EXISTING);
        byte[] hash = Hashing.sha1().hashBytes(Files.readAllBytes(target)).asBytes();
        if (!Arrays.equals(pack.getRawHash(), hash)) {
            this.packHashes.remove(pack.getHash());
            pack.setRawHash(hash);
            this.packHashes.put(pack.getHash(), packToCache);
            changed = true;
        }
        this.plugin.sendMessage(sender, "generate-hashes.hash-sum", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash());
        Files.deleteIfExists(target);
        if (in == null) return changed;
        try {
            in.close();
            return changed;
        }
        catch (IOException e) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getClass().getSimpleName() + ": " + e.getMessage());
            this.plugin.getPluginLogger().log(Level.WARNING, "Error while trying to close the input stream for pack " + pack.getName() + " hash generation", e);
        }
        return changed;
        catch (MalformedURLException e) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.invalid-url", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e.getClass().getSimpleName() + ": " + e.getMessage());
            this.plugin.getPluginLogger().log(Level.WARNING, "Invalid URL while trying to generate hash of pack " + pack.getName() + " from url " + pack.getUrl(), e);
            if (in == null) return changed;
            try {
                in.close();
                return changed;
            }
            catch (IOException e2) {
                this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getClass().getSimpleName() + ": " + e2.getMessage());
                this.plugin.getPluginLogger().log(Level.WARNING, "Error while trying to close the input stream for pack " + pack.getName() + " hash generation", e2);
            }
            return changed;
        }
        catch (IOException e2) {
            this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e2.getClass().getSimpleName() + ": " + e2.getMessage());
            this.plugin.getPluginLogger().log(Level.WARNING, "IO error while trying to generate hash of pack " + pack.getName() + " from url " + pack.getUrl(), e2);
            if (in == null) return changed;
            {
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e3.getClass().getSimpleName() + ": " + e3.getMessage());
                        this.plugin.getPluginLogger().log(Level.WARNING, "Error while trying to close the input stream for pack " + pack.getName() + " hash generation", e3);
                    }
                    throw throwable;
                }
            }
            try {
                in.close();
                return changed;
            }
            catch (IOException e4) {
                this.plugin.sendMessage(sender, Level.SEVERE, "generate-hashes.failed-to-load-pack", "pack", pack.getName(), "url", pack.getUrl(), "hash", pack.getHash(), "error", e4.getClass().getSimpleName() + ": " + e4.getMessage());
                this.plugin.getPluginLogger().log(Level.WARNING, "Error while trying to close the input stream for pack " + pack.getName() + " hash generation", e4);
            }
            return changed;
        }
    }

    public String getPackUrl(ResourcePack pack) {
        if (!this.shouldAppendHashToUrl() || pack.getRawHash().length == 0) {
            return pack.getUrl();
        }
        return pack.getUrl() + HASH_KEY + pack.getHash();
    }

    public boolean shouldAppendHashToUrl() {
        return this.appendHashToUrl;
    }

    public void setAppendHashToUrl(boolean appendHashToUrl) {
        this.appendHashToUrl = appendHashToUrl;
    }

    public int getPackFormat(int version) {
        int i = 0;
        while (i + 1 < PACK_FORMATS.length) {
            if (version >= PACK_FORMATS[i]) {
                return PACK_FORMATS[i + 1];
            }
            i += 2;
        }
        return -1;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void checkDirty() {
        if (this.dirty) {
            this.dirty = false;
            this.plugin.saveConfigChanges();
        }
    }

    public static class PackSetResult {
        private final ResourcePack pack;
        private final IResourcePackSelectEvent.Status status;

        private PackSetResult(ResourcePack pack, IResourcePackSelectEvent.Status status) {
            this.pack = pack;
            this.status = status;
        }

        public ResourcePack getPack() {
            return this.pack;
        }

        public IResourcePackSelectEvent.Status getStatus() {
            return this.status;
        }
    }
}

