/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.core;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public enum MinecraftVersion {
    MINECRAFT_1_21_8(772),
    MINECRAFT_1_21_7(772),
    MINECRAFT_1_21_6(771),
    MINECRAFT_1_21_5(770),
    MINECRAFT_1_21_4(769),
    MINECRAFT_1_21_3(768),
    MINECRAFT_1_21_2(768),
    MINECRAFT_1_21_1(767),
    MINECRAFT_1_21(767),
    MINECRAFT_1_20_6(766),
    MINECRAFT_1_20_5(766),
    MINECRAFT_1_20_4(765),
    MINECRAFT_1_20_3(765),
    MINECRAFT_1_20_2(764),
    MINECRAFT_1_20(763),
    MINECRAFT_1_19_4(762),
    MINECRAFT_1_19_3(761),
    MINECRAFT_1_19_2(760),
    MINECRAFT_1_19_1(760),
    MINECRAFT_1_19(759),
    MINECRAFT_1_18_2(758),
    MINECRAFT_1_18_1(757),
    MINECRAFT_1_18(757),
    MINECRAFT_1_17_1(756),
    MINECRAFT_1_17(755),
    MINECRAFT_1_16_5(754),
    MINECRAFT_1_16_4(754),
    MINECRAFT_1_16_3(753),
    MINECRAFT_1_16_2(751),
    MINECRAFT_1_16_1(736),
    MINECRAFT_1_16(735),
    MINECRAFT_1_15_2(578),
    MINECRAFT_1_15_1(575),
    MINECRAFT_1_15(573),
    MINECRAFT_1_14_4(498),
    MINECRAFT_1_14_3(490),
    MINECRAFT_1_14_2(485),
    MINECRAFT_1_14_1(480),
    MINECRAFT_1_14(477),
    MINECRAFT_1_13_2(404),
    MINECRAFT_1_13_1(401),
    MINECRAFT_1_13(393),
    MINECRAFT_1_12_2(340),
    MINECRAFT_1_12_1(338),
    MINECRAFT_1_12(335),
    MINECRAFT_1_11_2(316),
    MINECRAFT_1_11_1(316),
    MINECRAFT_1_11(315),
    MINECRAFT_1_10(210),
    MINECRAFT_1_9_4(110),
    MINECRAFT_1_9_2(109),
    MINECRAFT_1_9_1(108),
    MINECRAFT_1_9(107),
    MINECRAFT_1_8_8(47),
    MINECRAFT_1_8(47),
    MINECRAFT_1_7_6(5),
    MINECRAFT_1_7_2(4),
    UNKNOWN(0);

    private final int number;
    private static Map<Integer, MinecraftVersion> numbers;

    private MinecraftVersion(int versionNumber) {
        this.number = versionNumber;
    }

    public static MinecraftVersion parseVersion(String versionString) throws IllegalArgumentException {
        try {
            int parsedVersion = Integer.parseInt(versionString);
            MinecraftVersion version = MinecraftVersion.getVersion(parsedVersion);
            if (parsedVersion == 0 || version != UNKNOWN) {
                return version;
            }
        }
        catch (NumberFormatException parsedVersion) {
            // empty catch block
        }
        String getVersion = versionString.toUpperCase().replace('.', '_');
        if (!getVersion.startsWith("MINECRAFT_")) {
            getVersion = "MINECRAFT_" + getVersion;
        }
        try {
            return MinecraftVersion.valueOf(getVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(versionString + " is not a valid MinecraftVersion definition!");
        }
    }

    public static MinecraftVersion getVersion(int protocolVersion) {
        MinecraftVersion minecraftVersion = numbers.get(protocolVersion);
        if (minecraftVersion != null) {
            return minecraftVersion;
        }
        return UNKNOWN;
    }

    public static MinecraftVersion getExactVersion(int protocolVersion) {
        return numbers.get(protocolVersion);
    }

    public String toConfigString() {
        return this == UNKNOWN ? this.name() : this.name().toLowerCase(Locale.ROOT).substring("MINECRAFT_".length()).replace('_', '.');
    }

    public int getProtocolNumber() {
        return this.number;
    }

    static {
        numbers = new LinkedHashMap<Integer, MinecraftVersion>();
        for (MinecraftVersion version : MinecraftVersion.values()) {
            numbers.put(version.number, version);
        }
    }
}

