/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit.internal;

import de.themoep.resourcepacksplugin.bukkit.WorldResourcepacks;
import de.themoep.resourcepacksplugin.bukkit.internal.InternalHelper;
import de.themoep.resourcepacksplugin.core.ResourcePack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class InternalHelper_fallback
implements InternalHelper {
    private final WorldResourcepacks plugin;
    private Method getHandle = null;
    private Method setResourcePack = null;
    private boolean hasAddResourcePack = false;
    private boolean hasSetIdResourcePack = false;
    private boolean hasSetResourcePack = false;
    private boolean hasRemoveResourcepacks = true;

    public InternalHelper_fallback(WorldResourcepacks plugin) {
        this.plugin = plugin;
        try {
            this.hasAddResourcePack = Player.class.getMethod("addResourcePack", UUID.class, String.class, byte[].class, String.class, Boolean.TYPE) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.hasSetIdResourcePack = Player.class.getMethod("setResourcePack", UUID.class, String.class, byte[].class) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.hasSetResourcePack = Player.class.getMethod("setResourcePack", String.class, byte[].class) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (!(this.hasAddResourcePack || this.hasSetIdResourcePack || this.hasSetResourcePack)) {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            try {
                Class<?> craftPlayer = Class.forName(packageName + ".entity.CraftPlayer");
                this.getHandle = craftPlayer.getDeclaredMethod("getHandle", new Class[0]);
                Class<?> entityPlayer = this.getHandle.getReturnType();
                this.setResourcePack = entityPlayer.getDeclaredMethod("setResourcePack", String.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                plugin.log(Level.SEVERE, "Unable to find method which enables us to efficiently send a resource pack!", e);
            }
        }
    }

    @Override
    public void setResourcePack(Player player, ResourcePack pack) {
        if (this.hasAddResourcePack) {
            player.addResourcePack(pack.getUuid(), this.plugin.getPackManager().getPackUrl(pack), pack.getRawHash(), null, false);
            return;
        }
        if (this.hasSetIdResourcePack) {
            player.setResourcePack(pack.getUuid(), this.plugin.getPackManager().getPackUrl(pack), pack.getRawHash(), null, false);
            return;
        }
        if (this.hasSetResourcePack) {
            player.setResourcePack(this.plugin.getPackManager().getPackUrl(pack), pack.getRawHash());
            return;
        }
        try {
            if (this.getHandle != null && this.setResourcePack != null) {
                Object entityPlayer = this.getHandle.invoke((Object)player, new Object[0]);
                this.setResourcePack.invoke(entityPlayer, this.plugin.getPackManager().getPackUrl(pack), pack.getHash());
                return;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        player.setResourcePack(this.plugin.getPackManager().getPackUrl(pack));
    }

    @Override
    public void removeResourcePack(Player player, ResourcePack pack) {
        try {
            if (this.hasRemoveResourcepacks) {
                player.removeResourcePack(pack.getUuid());
            }
        }
        catch (NoSuchMethodError e) {
            this.hasRemoveResourcepacks = false;
            throw new UnsupportedOperationException("This version does not support removing resourcepacks!");
        }
    }

    @Override
    public void removeResourcePacks(Player player) {
        try {
            if (this.hasRemoveResourcepacks) {
                player.removeResourcePacks();
            }
        }
        catch (NoSuchMethodError e) {
            this.hasRemoveResourcepacks = false;
            throw new UnsupportedOperationException("This version does not support removing resourcepacks!");
        }
    }
}

