/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.resourcepacksplugin.bukkit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigAccessor {
    private final String fileName;
    protected final Plugin plugin;
    private File configFile;
    private FileConfiguration fileConfiguration;
    private FileConfiguration defaults;

    public ConfigAccessor(Plugin plugin, String fileName) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin cannot be null");
        }
        this.plugin = plugin;
        this.fileName = fileName;
        File dataFolder = plugin.getDataFolder();
        if (dataFolder == null) {
            throw new IllegalStateException();
        }
        this.configFile = new File(plugin.getDataFolder(), fileName);
        this.defaults = this.getDefaults();
    }

    public void reloadConfig() {
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.defaults != null) {
            this.fileConfiguration.setDefaults((Configuration)this.defaults);
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            if (this.defaults != null) {
                return this.defaults;
            }
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public FileConfiguration getDefaults() {
        InputStream defConfigStream;
        if (this.defaults == null && (defConfigStream = this.plugin.getResource(this.fileName)) != null) {
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
        }
        return this.defaults;
    }

    public void saveConfig() {
        if (this.fileConfiguration != null && this.configFile != null) {
            try {
                this.getConfig().save(this.configFile);
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, ex);
            }
        }
    }

    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
    }
}

