/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.minedown.adventure;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.util.RGBLike;

public class Util {
    private static final Pattern WRAP_PATTERN = Pattern.compile(" ", 16);

    public static void validate(boolean value, String message) throws IllegalArgumentException {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Component applyFormat(Component component, Collection<TextDecoration> formats) {
        for (TextDecoration format : formats) {
            component.decoration(format, true);
        }
        if (!component.children().isEmpty()) {
            for (Component extra : component.children()) {
                Util.applyFormat(extra, formats);
            }
        }
        return component;
    }

    @Deprecated
    public static ComponentBuilder applyFormat(ComponentBuilder builder, Collection<TextDecoration> formats) {
        for (TextDecoration format : formats) {
            builder.decoration(format, true);
        }
        return builder;
    }

    public static ComponentBuilder applyFormat(ComponentBuilder builder, Map<TextDecoration, Boolean> formats) {
        for (Map.Entry<TextDecoration, Boolean> e : formats.entrySet()) {
            builder.decoration(e.getKey(), e.getValue().booleanValue());
        }
        return builder;
    }

    public static boolean isDouble(String string, int index) {
        return index + 1 < string.length() && string.charAt(index) == string.charAt(index + 1);
    }

    public static boolean isFormat(TextColor format) {
        return false;
    }

    public static Set<TextDecoration> getFormats(Component component, boolean ignoreParent) {
        return component.decorations().entrySet().stream().filter(e -> e.getValue() == TextDecoration.State.TRUE).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static int indexOfNotEscaped(String string, String chars) {
        return Util.indexOfNotEscaped(string, chars, 0);
    }

    public static int indexOfNotEscaped(String string, String chars, int fromIndex) {
        for (int i = fromIndex; i < string.length(); ++i) {
            int index = string.indexOf(chars, i);
            if (index == -1) {
                return -1;
            }
            if (Util.isEscaped(string, index)) continue;
            return index;
        }
        return -1;
    }

    public static boolean isEscaped(String string, int index) {
        int e;
        if (index - 1 > string.length()) {
            return false;
        }
        for (e = 0; index > e && string.charAt(index - e - 1) == '\\'; ++e) {
        }
        return e % 2 != 0;
    }

    public static int getUnescapedEndIndex(String string, char startChar, char endChar, int fromIndex) {
        int depth = 0;
        boolean innerEscaped = false;
        for (int i = fromIndex; i < string.length(); ++i) {
            if (innerEscaped) {
                innerEscaped = false;
                continue;
            }
            if (string.charAt(i) == '\\') {
                innerEscaped = true;
                continue;
            }
            if (string.charAt(i) == startChar) {
                ++depth;
                continue;
            }
            if (string.charAt(i) != endChar || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    public static String wrap(String string, int lineLength) {
        if (string.length() <= lineLength || string.contains("\n")) {
            return string;
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String s : WRAP_PATTERN.split(string)) {
            if (currentLine.length() + s.length() + 1 > lineLength) {
                int rest = lineLength - currentLine.length() - 1;
                if (rest > lineLength / 4 && s.length() > Math.min(rest * 2, lineLength / 4)) {
                    currentLine.append(" ").append(s, 0, rest);
                } else {
                    rest = 0;
                }
                lines.add(currentLine.toString());
                String restString = s.substring(rest);
                while (restString.length() >= lineLength) {
                    lines.add(restString.substring(0, lineLength));
                    restString = restString.substring(lineLength);
                }
                currentLine = new StringBuilder(restString);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(s);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static Component rgbColorsToLegacy(Component components) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(components)).mapChildrenDeep(buildableComponent -> buildableComponent.color() != null ? (BuildableComponent)buildableComponent.color((TextColor)NamedTextColor.nearestTo((TextColor)buildableComponent.color())) : buildableComponent)).build();
    }

    @Deprecated
    public static NamedTextColor getClosestLegacy(TextColor textColor) {
        return textColor != null ? NamedTextColor.nearestTo((TextColor)textColor) : null;
    }

    @Deprecated
    public static double distance(Color c1, Color c2) {
        if (c1.getRGB() == c2.getRGB()) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(c1.getRed() - c2.getRed(), 2.0) + Math.pow(c1.getGreen() - c2.getGreen(), 2.0) + Math.pow(c1.getBlue() - c2.getBlue(), 2.0));
    }

    public static TextFormat getFormatFromString(String formatString) throws IllegalArgumentException {
        TextColor format;
        if (formatString.charAt(0) == '#') {
            format = TextColor.fromCSSHexString((String)formatString);
        } else {
            format = (TextFormat)NamedTextColor.NAMES.value((Object)formatString.toLowerCase(Locale.ROOT));
            if (format == null) {
                format = (TextFormat)TextDecoration.NAMES.value((Object)formatString.toLowerCase(Locale.ROOT));
            }
            if (format == null) {
                switch (formatString.toLowerCase(Locale.ROOT)) {
                    case "underline": {
                        return TextDecoration.UNDERLINED;
                    }
                    case "magic": {
                        return TextDecoration.OBFUSCATED;
                    }
                }
            }
        }
        if (format != null) {
            return format;
        }
        throw new IllegalArgumentException("Unknown format: " + formatString);
    }

    public static TextFormat getFormatFromLegacy(char code) {
        switch (code) {
            case '0': {
                return NamedTextColor.BLACK;
            }
            case '1': {
                return NamedTextColor.DARK_BLUE;
            }
            case '2': {
                return NamedTextColor.DARK_GREEN;
            }
            case '3': {
                return NamedTextColor.DARK_AQUA;
            }
            case '4': {
                return NamedTextColor.DARK_RED;
            }
            case '5': {
                return NamedTextColor.DARK_PURPLE;
            }
            case '6': {
                return NamedTextColor.GOLD;
            }
            case '7': {
                return NamedTextColor.GRAY;
            }
            case '8': {
                return NamedTextColor.DARK_GRAY;
            }
            case '9': {
                return NamedTextColor.BLUE;
            }
            case 'a': {
                return NamedTextColor.GREEN;
            }
            case 'b': {
                return NamedTextColor.AQUA;
            }
            case 'c': {
                return NamedTextColor.RED;
            }
            case 'd': {
                return NamedTextColor.LIGHT_PURPLE;
            }
            case 'e': {
                return NamedTextColor.YELLOW;
            }
            case 'f': {
                return NamedTextColor.WHITE;
            }
            case 'k': {
                return TextDecoration.OBFUSCATED;
            }
            case 'l': {
                return TextDecoration.BOLD;
            }
            case 'm': {
                return TextDecoration.STRIKETHROUGH;
            }
            case 'n': {
                return TextDecoration.UNDERLINED;
            }
            case 'o': {
                return TextDecoration.ITALIC;
            }
            case 'r': {
                return TextControl.RESET;
            }
        }
        return null;
    }

    public static char getLegacyFormatChar(TextFormat format) {
        if (format == TextControl.RESET) {
            return 'r';
        }
        if (format instanceof NamedTextColor) {
            if (format == NamedTextColor.BLACK) {
                return '0';
            }
            if (format == NamedTextColor.DARK_BLUE) {
                return '1';
            }
            if (format == NamedTextColor.DARK_GREEN) {
                return '2';
            }
            if (format == NamedTextColor.DARK_AQUA) {
                return '3';
            }
            if (format == NamedTextColor.DARK_RED) {
                return '4';
            }
            if (format == NamedTextColor.DARK_PURPLE) {
                return '5';
            }
            if (format == NamedTextColor.GOLD) {
                return '6';
            }
            if (format == NamedTextColor.GRAY) {
                return '7';
            }
            if (format == NamedTextColor.DARK_GRAY) {
                return '8';
            }
            if (format == NamedTextColor.BLUE) {
                return '9';
            }
            if (format == NamedTextColor.GREEN) {
                return 'a';
            }
            if (format == NamedTextColor.AQUA) {
                return 'b';
            }
            if (format == NamedTextColor.RED) {
                return 'c';
            }
            if (format == NamedTextColor.LIGHT_PURPLE) {
                return 'd';
            }
            if (format == NamedTextColor.YELLOW) {
                return 'e';
            }
            if (format == NamedTextColor.WHITE) {
                return 'f';
            }
        } else if (format instanceof TextDecoration) {
            switch ((TextDecoration)format) {
                case OBFUSCATED: {
                    return 'k';
                }
                case BOLD: {
                    return 'l';
                }
                case STRIKETHROUGH: {
                    return 'm';
                }
                case UNDERLINED: {
                    return 'n';
                }
                case ITALIC: {
                    return 'o';
                }
            }
        } else if (format instanceof TextColor) {
            return Util.getLegacyFormatChar((TextFormat)NamedTextColor.nearestTo((TextColor)((TextColor)format)));
        }
        throw new IllegalArgumentException(String.valueOf(format) + " is not supported!");
    }

    @Deprecated
    public static List<TextColor> createRainbow(int length, int phase) {
        return Util.createRainbow((long)length, phase);
    }

    public static List<TextColor> createRainbow(long length, int phase) {
        ArrayList<TextColor> colors = new ArrayList<TextColor>();
        float fPhase = (float)phase / 10.0f;
        float center = 128.0f;
        float width = 127.0f;
        double frequency = Math.PI * 2 / (double)length;
        for (long i = 0L; i < length; ++i) {
            colors.add(TextColor.color((int)((int)(Math.sin(frequency * (double)i + 2.0 + (double)fPhase) * (double)width + (double)center)), (int)((int)(Math.sin(frequency * (double)i + 0.0 + (double)fPhase) * (double)width + (double)center)), (int)((int)(Math.sin(frequency * (double)i + 4.0 + (double)fPhase) * (double)width + (double)center))));
        }
        return colors;
    }

    @Deprecated
    public static List<TextColor> createGradient(int length, List<TextColor> gradient) {
        return Util.createGradient((long)length, gradient);
    }

    public static List<TextColor> createGradient(long length, List<TextColor> gradient) {
        ArrayList<TextColor> colors = new ArrayList<TextColor>();
        if (gradient.size() < 2 || length < 2L) {
            if (gradient.isEmpty()) {
                return gradient;
            }
            return Collections.singletonList(gradient.get(0));
        }
        float fPhase = 0.0f;
        float sectorLength = (float)(length - 1L) / (float)(gradient.size() - 1);
        float factorStep = 1.0f / sectorLength;
        long index = 0L;
        int colorIndex = 0;
        for (long i = 0L; i < length; ++i) {
            if (factorStep * (float)index > 1.0f) {
                ++colorIndex;
                index = 0L;
            }
            long l = index++;
            float factor = factorStep * ((float)l + fPhase);
            if (factor > 1.0f) {
                factor = 1.0f - (factor - 1.0f);
            }
            colors.add(TextColor.lerp((float)factor, (RGBLike)((RGBLike)gradient.get(colorIndex)), (RGBLike)((RGBLike)gradient.get(Math.min(gradient.size() - 1, colorIndex + 1)))));
        }
        return colors;
    }

    public static enum TextControl implements TextFormat
    {
        RESET('r');

        private char c;

        private TextControl(char c) {
            this.c = c;
        }

        public char getChar() {
            return this.c;
        }
    }
}

