/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.metrics;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MoepMetrics {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Plugin plugin;
    private boolean metricsOptOut;
    private boolean metricsAreDisabled;
    private boolean updateNotifications;
    private String platform;
    private String downloaderId;
    private String nonce;
    private String machine;
    private String toTheLeakers1;
    private String toTheLeakers2;
    private String thanksToTheLeakers1;
    private String thanksToTheLeakers2;
    private String thanksToTheLeakers3;
    private String thanksToTheLeakers4;
    private String thanksToTheLeakers5;
    private String leakerResponse;
    private String url;
    private final String userAgent;
    private String[] responseMsg;
    static final String HEXES = "0123456789ABCDEF";

    public MoepMetrics(Plugin plugin) {
        this(plugin, true);
    }

    public MoepMetrics(Plugin plugin, boolean updateNotifications) {
        this(plugin, false, updateNotifications);
    }

    public MoepMetrics(Plugin plugin, boolean disableMetrics, boolean updateNotifications) {
        block36: {
            this.metricsOptOut = false;
            this.metricsAreDisabled = false;
            this.updateNotifications = true;
            this.platform = "Unknown";
            this.downloaderId = "%%__USER__%%";
            this.nonce = "%%__NONCE__%%";
            this.machine = "0";
            this.toTheLeakers1 = "If you are leaking/cracking this plugin then please leave the Metrics and nonce intact and only change your user id.";
            this.toTheLeakers2 = "The metrics cannot disable the plugin or identify you as the leaker and are only used to track usage/settings and for update notifications.";
            this.thanksToTheLeakers1 = "BIG THANKS to those who already switched to keeping the metrics intact!";
            this.thanksToTheLeakers2 = "Feel free to replace the user id with your name, maybe I get around creating a statistic page and then I make a ranking for you guys separately. ;D (And maybe we can compare leak vs paid?)";
            this.thanksToTheLeakers3 = "In the end I care more about people using my work than money but getting something back for your work also feels nice.";
            this.thanksToTheLeakers4 = "So if people want to support me they have a good way of doing so with the premium purchase, otherwise they can just download the leak.";
            this.thanksToTheLeakers5 = "And as long as no malicious code gets included into leaks I wont bother doing any serious protection =D";
            this.leakerResponse = "If you want to tell me something, feel free to replace this string ;)";
            this.url = "http://m1.moep.tv/addentry?plugin=%plugin%&version=%version%";
            this.responseMsg = new String[0];
            this.plugin = plugin;
            try (JarFile jarFile2 = new JarFile(plugin.getFile());){
                String distributionType = jarFile2.getManifest().getMainAttributes().getValue("Distribution-Type");
                if (distributionType != null) {
                    this.platform = distributionType;
                }
            }
            catch (IOException jarFile2) {
                // empty catch block
            }
            this.metricsAreDisabled = disableMetrics;
            this.updateNotifications = updateNotifications;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(NetworkInterface.getNetworkInterfaces().nextElement().getHardwareAddress());
                this.machine = MoepMetrics.toHexString(md.digest()).toLowerCase();
            }
            catch (Exception md) {
                // empty catch block
            }
            try {
                this.url = this.url.replace("%plugin%", URLEncoder.encode(plugin.getName(), "UTF-8")).replace("%version%", URLEncoder.encode(plugin.getVersion(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                this.url = this.url.replace("%plugin%", plugin.getName().replace(" ", "%20")).replace("%version%", plugin.getVersion().replace(" ", "%20"));
            }
            this.userAgent = plugin.getName() + "/" + plugin.getVersion() + " MoepMetrics/1.2.3 " + this.platform + " " + this.downloaderId + " " + this.nonce + " " + this.machine;
            try {
                Stream<String> stream;
                File configFile;
                File configFolder;
                File configFile2;
                File pluginsFolder = plugin.getFile().getParentFile();
                if (!pluginsFolder.isDirectory()) break block36;
                boolean configExists = false;
                File moepMetricsFolder = new File(pluginsFolder, "MoepMetrics");
                if (moepMetricsFolder.isDirectory() && (configFile2 = new File(moepMetricsFolder, "config.yml")).exists()) {
                    configExists = true;
                    try (Stream<String> stream2 = Files.lines(configFile2.toPath());){
                        this.metricsOptOut = stream2.anyMatch(line -> line.startsWith("opt-out") && line.contains("true"));
                    }
                }
                if (configExists) break block36;
                if (!this.metricsOptOut && (configFolder = new File(pluginsFolder, "bStats")).isDirectory() && (configFile = new File(configFolder, "config.yml")).exists()) {
                    stream = Files.lines(configFile.toPath());
                    try {
                        this.metricsOptOut = stream.anyMatch(line -> line.startsWith("enabled:") && line.contains("false"));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (this.metricsOptOut || !(configFolder = new File(pluginsFolder, "PluginMetrics")).isDirectory() || !(configFile = new File(configFolder, "config.yml")).exists()) break block36;
                stream = Files.lines(configFile.toPath());
                try {
                    this.metricsOptOut = stream.anyMatch(line -> line.startsWith("opt-out:") && line.contains("true"));
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                plugin.log(Level.WARNING, "Error while trying to parse metrics config files");
            }
        }
        if (!this.areMetricsEnabled()) {
            plugin.log(Level.INFO, "Metrics are disabled.");
        }
    }

    public void postUpdate(String ... specials) {
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < specials.length) {
            args.put(specials[i], specials[i + 1]);
            i += 2;
        }
        this.postUpdate(args);
    }

    public void postUpdate(Map<String, String> specials) {
        if (!this.areMetricsEnabled() && !this.areUpdateNotificationsEnabled()) {
            return;
        }
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (this.areMetricsEnabled()) {
            String javaVendor;
            String javaVersion;
            args.put("platform", this.platform);
            args.put("id", this.downloaderId);
            args.put("version", this.plugin.getVersion());
            args.put("pass", "%%__NONCE__%%");
            args.put("hash", this.getHash());
            args.put("machine", this.machine);
            args.put("updatenotifications", String.valueOf(this.areUpdateNotificationsEnabled()));
            args.put("serverversion", this.plugin.getServerVersion());
            Properties prop = System.getProperties();
            String javaTitle = Runtime.class.getPackage().getSpecificationTitle();
            if (javaTitle == null) {
                javaTitle = prop.getProperty("java.title");
            }
            if ((javaVersion = Runtime.class.getPackage().getSpecificationVersion()) == null) {
                javaVersion = prop.getProperty("java.version");
            }
            if ((javaVendor = Runtime.class.getPackage().getSpecificationVendor()) == null) {
                javaVendor = prop.getProperty("java.vendor");
            }
            args.put("javatitle", javaTitle);
            args.put("javaversion", javaVersion);
            args.put("javavendor", javaVendor);
            if (specials != null) {
                args.putAll(specials);
            }
        }
        this.plugin.runAsyncTask(() -> {
            block12: {
                try {
                    String[] msg;
                    String response = this.request(this.url, args);
                    if (!response.toLowerCase().startsWith("json:")) break block12;
                    JsonObject responseJson = new JsonParser().parse(response.substring("json:".length())).getAsJsonObject();
                    Level level = Level.INFO;
                    boolean send = false;
                    try {
                        send = this.areUpdateNotificationsEnabled() || responseJson.has("forcesend") && responseJson.get("forcesend").getAsBoolean();
                    }
                    catch (JsonParseException | ClassCastException throwable) {
                        // empty catch block
                    }
                    if (!send || !responseJson.has("message")) break block12;
                    if (responseJson.has("level")) {
                        try {
                            level = Level.parse(responseJson.get("level").getAsString());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    for (String line : msg = responseJson.get("message").getAsString().split("\\r?\\n")) {
                        this.plugin.log(level, line);
                    }
                    if (!responseJson.has("loginnotice")) break block12;
                    try {
                        if (responseJson.get("loginnotice").getAsBoolean()) {
                            this.responseMsg = msg;
                        }
                    }
                    catch (JsonParseException | ClassCastException throwable) {}
                }
                catch (IOException e) {
                    this.plugin.log(Level.SEVERE, !this.areMetricsEnabled() ? "Error while searching for update." : (this.areUpdateNotificationsEnabled() ? "Error while searching for update/posting Metrics update." : "Error while posting Metrics update."));
                    this.plugin.log(Level.SEVERE, e.getMessage().substring(0, e.getMessage().contains(" for URL: ") ? e.getMessage().indexOf(" for URL: ") : e.getMessage().length()));
                }
                catch (JsonParseException | ClassCastException | IllegalStateException e) {
                    this.plugin.log(Level.SEVERE, "Error while parsing response json. " + e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String request(String urlString, Map<String, String> args) throws IOException {
        String msg = "";
        URL url = new URL(urlString);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        try {
            con.setRequestProperty("User-Agent", this.userAgent);
            if (args == null || args.size() == 0) {
                con.setRequestMethod("GET");
            } else {
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                String data = args.entrySet().stream().map(entry -> {
                    try {
                        return URLEncoder.encode(String.valueOf(entry.getKey()), "UTF-8") + "=" + URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if (Boolean.getBoolean("MoepMetrics.debug")) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.joining("&"));
                byte[] out = data.getBytes(UTF8);
                int length = out.length;
                con.setFixedLengthStreamingMode(length);
                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                try {
                    con.connect();
                    OutputStream os = con.getOutputStream();
                    os.write(out);
                }
                catch (IOException e) {
                    if (Boolean.getBoolean("MoepMetrics.debug")) {
                        e.printStackTrace();
                        this.plugin.log(Level.SEVERE, "Response: " + con.getResponseCode() + " " + con.getResponseMessage());
                    }
                    throw e;
                }
            }
            try {
                msg = this.getInputString(con);
            }
            catch (IOException e) {
                if (Boolean.getBoolean("MoepMetrics.debug")) {
                    e.printStackTrace();
                    this.plugin.log(Level.SEVERE, "Response: " + con.getResponseCode() + " " + con.getResponseMessage());
                }
                throw e;
            }
        }
        finally {
            con.disconnect();
        }
        return msg;
    }

    private String getInputString(HttpURLConnection con) throws IOException {
        String line;
        StringBuilder msg = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        while ((line = in.readLine()) != null) {
            if (msg.length() != 0) {
                msg.append("\n");
            }
            msg.append(line);
        }
        in.close();
        return msg.toString();
    }

    private String getHash() {
        try {
            String path = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(Files.readAllBytes(Paths.get(path.replaceFirst("^/(.:/)", "$1"), new String[0])));
            return MoepMetrics.toHexString(md.digest()).toLowerCase();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String toHexString(byte[] raw) {
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public void onPlayerJoin(UUID playerId) {
        if (this.areUpdateNotificationsEnabled() && this.getResponseMsg() != null && this.getResponseMsg().length > 0 && this.plugin.hasPermission(playerId, this.plugin.getName().toLowerCase() + ".updatenotification")) {
            this.plugin.runTaskLater(() -> {
                for (String line : this.getResponseMsg()) {
                    this.plugin.sendMessage(playerId, "&c" + line);
                }
            }, 5);
        }
    }

    public String[] getResponseMsg() {
        return this.responseMsg;
    }

    public boolean areMetricsEnabled() {
        return !this.metricsAreDisabled && !this.metricsOptOut;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        boolean bl = this.metricsAreDisabled = !metricsEnabled;
        if (this.metricsAreDisabled) {
            this.plugin.log(Level.INFO, "Metrics are disabled!");
        }
    }

    public boolean areUpdateNotificationsEnabled() {
        return this.updateNotifications;
    }

    public void setUpdateNotificationsEnabled(boolean updateNotifications) {
        this.updateNotifications = updateNotifications;
        this.plugin.log(Level.INFO, "Update notifications are " + (updateNotifications ? "enabled!" : "disabled!"));
    }

    public static interface Plugin {
        public String getName();

        public String getVersion();

        public String getServerVersion();

        public int runAsyncTask(Runnable var1);

        public int runTaskLater(Runnable var1, int var2);

        public void log(Level var1, String var2);

        public boolean sendMessage(UUID var1, String var2);

        public boolean hasPermission(UUID var1, String var2);

        public File getFile();
    }
}

