/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.inventorygui;

import de.themoep.inventorygui.InventoryGui;
import de.themoep.inventorygui.StaticGuiElement;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public class GuiBackElement
extends StaticGuiElement {
    private boolean close;

    public GuiBackElement(char slotChar, ItemStack item, String ... text) {
        this(slotChar, item, false, text);
    }

    public GuiBackElement(char slotChar, ItemStack item, boolean close, String ... text) {
        super(slotChar, item, text);
        this.close = close;
        this.setAction(click -> {
            if (this.canGoBack(click.getWhoClicked())) {
                InventoryGui.goBack(click.getWhoClicked());
            } else if (close) {
                click.getGui().close();
            }
            return true;
        });
    }

    @Override
    public ItemStack getItem(HumanEntity who, int slot) {
        if (!this.canGoBack(who) && !this.close) {
            return this.gui.getFiller() != null ? this.gui.getFiller().getItem(who, slot) : null;
        }
        return super.getItem(who, slot);
    }

    public boolean canClose() {
        return this.close;
    }

    private boolean canGoBack(HumanEntity who) {
        return InventoryGui.getHistory(who).size() > 1 || InventoryGui.getHistory(who).size() == 1 && InventoryGui.getHistory(who).peekLast() != this.gui;
    }
}

