/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.hook.velocity;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import de.themoep.hook.core.AbstractHookManager;
import de.themoep.hook.velocity.Hookable;
import de.themoep.hook.velocity.HookableWrapper;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HookManager
extends AbstractHookManager<Hookable> {
    private final Hookable parent;
    private ProxyServer proxy;

    public HookManager(Hookable parent, ProxyServer proxy, String hookPackage) {
        this(parent, proxy, hookPackage, false);
    }

    public HookManager(Hookable parent, ProxyServer proxy, String hookPackage, boolean onePackagePerHook) {
        super(Logger.getLogger(parent.getDescription().getId()), hookPackage, onePackagePerHook);
        this.parent = parent;
        this.proxy = proxy;
        this.registerExistingHookables();
        proxy.getEventManager().register((Object)parent, (Object)this);
    }

    @Subscribe
    public void onReload(ProxyReloadEvent event) {
        this.getHookables().forEach(x$0 -> this.onHookableDisable(x$0));
        this.registerExistingHookables();
    }

    protected String getName(Hookable plugin) {
        return plugin.getDescription().getName().orElse(plugin.getDescription().getId());
    }

    protected String getVersion(Hookable plugin) {
        return plugin.getDescription().getVersion().orElse("");
    }

    protected boolean isEnabled(Hookable plugin) {
        return this.proxy.getPluginManager().isLoaded(plugin.getDescription().getId());
    }

    protected Collection<Hookable> getHookables() {
        return this.proxy.getPluginManager().getPlugins().stream().map(HookableWrapper::new).collect(Collectors.toList());
    }
}

