/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.hook.core;

import de.themoep.hook.core.Hook;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public abstract class AbstractHookManager<H> {
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("\\W");
    private final Logger logger;
    private final String hookPackage;
    private String suffix = "Hook";
    private final boolean onePackagePerHook;
    private final Map<String, Hook<H>> hookMap = new LinkedHashMap<String, Hook<H>>();

    public AbstractHookManager(String hookPackage) {
        this(Logger.getLogger("HookManager"), hookPackage, false);
    }

    public AbstractHookManager(Logger logger, String hookPackage) {
        this(logger, hookPackage, false);
    }

    public AbstractHookManager(Logger logger, String hookPackage, boolean onePackagePerHook) {
        this.logger = logger;
        this.hookPackage = hookPackage;
        this.onePackagePerHook = onePackagePerHook;
    }

    protected void registerExistingHookables() {
        for (H hookable : this.getHookables()) {
            if (!this.isEnabled(hookable)) continue;
            this.registerHook(hookable);
        }
    }

    public Hook<H> getHook(H hookable) {
        for (String name : this.getNames(hookable)) {
            Hook<H> hook = this.getHook(name);
            if (hook == null) continue;
            return hook;
        }
        return null;
    }

    public Hook<H> getHook(String hookable) {
        return this.hookMap.get(hookable);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    private void registerHook(H hookable) {
        for (String name : this.getNames(hookable)) {
            if (this.registerHook(name, hookable)) break;
        }
    }

    private boolean registerHook(String name, H hookable) {
        String adjustedName = NON_WORD_PATTERN.matcher(name).replaceAll("_");
        String version = NON_WORD_PATTERN.matcher(this.getVersion(hookable)).replaceAll("_");
        String path = this.hookPackage + "." + (this.onePackagePerHook ? name.toLowerCase() : name);
        Class<?> hookClass = null;
        do {
            try {
                hookClass = Class.forName(path + (this.onePackagePerHook ? version.toLowerCase() + "." + adjustedName : version) + this.suffix);
                if (!Hook.class.isAssignableFrom(hookClass)) {
                    hookClass = null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!version.contains("_")) {
                try {
                    hookClass = Class.forName(path + (this.onePackagePerHook ? adjustedName : "") + this.suffix);
                    if (Hook.class.isAssignableFrom(hookClass)) break;
                    hookClass = null;
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break;
            }
            version = version.substring(0, version.lastIndexOf(95));
        } while (hookClass == null);
        if (hookClass != null) {
            try {
                Hook hook;
                try {
                    hook = (Hook)hookClass.getConstructor(hookable.getClass()).newInstance(hookable);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    hook = (Hook)hookClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                hook.register();
                this.hookMap.put(this.getName(hookable), hook);
                return true;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.logger.log(Level.SEVERE, "Could not hook into " + this.getName(hookable) + " " + this.getVersion(hookable) + "!", e);
            }
        }
        return false;
    }

    protected void onHookableEnable(H hookable) {
        if (this.getHook(hookable) == null) {
            this.registerHook(hookable);
        }
    }

    protected void onHookableDisable(H hookable) {
        for (String name : this.getNames(hookable)) {
            Hook<H> hook = this.hookMap.remove(name);
            if (hook == null) continue;
            hook.unregister();
            break;
        }
    }

    protected String[] getNames(H hookable) {
        return new String[]{this.getName(hookable)};
    }

    protected abstract String getName(H var1);

    protected abstract String getVersion(H var1);

    protected abstract boolean isEnabled(H var1);

    protected abstract Collection<H> getHookables();
}

