/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.hook.bukkit;

import de.themoep.hook.core.AbstractHookManager;
import de.themoep.hook.core.Hook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class HookManager
extends AbstractHookManager<Plugin>
implements Listener {
    private final Plugin parent;

    public HookManager(Plugin parent, String hookPackage) {
        this(parent, hookPackage, false);
    }

    public HookManager(Plugin parent, String hookPackage, boolean onePackagePerHook) {
        super(parent.getLogger(), hookPackage, onePackagePerHook);
        this.parent = parent;
        this.registerExistingHookables();
        parent.getServer().getPluginManager().registerEvents((Listener)this, parent);
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.onHookableEnable(event.getPlugin());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        Hook hook = this.getHook(event.getPlugin());
        if (hook instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)hook));
        }
        this.onHookableDisable(event.getPlugin());
    }

    protected String getName(Plugin plugin) {
        return plugin.getName();
    }

    protected String[] getNames(Plugin plugin) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(plugin.getName());
        names.addAll(plugin.getDescription().getProvides());
        return names.toArray(new String[0]);
    }

    protected String getVersion(Plugin plugin) {
        return plugin.getDescription().getVersion();
    }

    protected boolean isEnabled(Plugin plugin) {
        return plugin.isEnabled();
    }

    protected Collection<Plugin> getHookables() {
        return Arrays.asList(this.parent.getServer().getPluginManager().getPlugins());
    }
}

