/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.globalwarps.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.globalwarps.GlobalWarpsPlugin;
import de.themoep.globalwarps.Warp;
import de.themoep.globalwarps.commands.GlobalCommand;
import de.themoep.globalwarps.commands.GlobalCommandSender;
import java.util.List;
import java.util.stream.Collectors;

public class WarpsCommand<P extends GlobalWarpsPlugin<S>, S>
extends GlobalCommand<P, S> {
    public WarpsCommand(P plugin) {
        super(plugin, "gwarps", "globalwarps.command.warps", null, "Warp command", "/<command> <warp> [<player>]", "warps", "globalwarps");
    }

    @Override
    public boolean onCommand(GlobalCommandSender<S> sender, LocationInfo location, String label, String[] args) {
        if (args.length > 0 && "reload".equalsIgnoreCase(args[0]) && sender.hasPermission("globalwarps.command.reload")) {
            ((GlobalWarpsPlugin)this.getPlugin()).loadConfig();
            sender.sendMessage("Config reloaded!");
            return true;
        }
        List warps = ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().sorted().collect(Collectors.toList());
        ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.head", "count", String.valueOf(warps.size()));
        for (Warp warp : warps) {
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.entry", warp.getReplacements());
        }
        ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.footer", "count", String.valueOf(warps.size()));
        return true;
    }
}

