/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.globalwarps.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.globalwarps.GlobalWarpsPlugin;
import de.themoep.globalwarps.Warp;
import de.themoep.globalwarps.commands.GlobalCommand;
import de.themoep.globalwarps.commands.GlobalCommandSender;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class WarpCommand<P extends GlobalWarpsPlugin<S>, S>
extends GlobalCommand<P, S> {
    public WarpCommand(P plugin) {
        super(plugin, "gwarp", "globalwarps.command.warp", null, "Warp command", "/<command> <warp> [<player>]", "warp");
    }

    @Override
    public boolean onCommand(GlobalCommandSender<S> sender, LocationInfo location, String label, String[] args) {
        GlobalCommandSender<S> target;
        if (args.length < 1) {
            if (!sender.hasPermission("globalwarps.command.warps")) {
                return false;
            }
            List warps = ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().sorted().collect(Collectors.toList());
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.head", "count", String.valueOf(warps.size()));
            for (Warp warp : warps) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.entry", warp.getReplacements());
            }
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warps.footer", "count", String.valueOf(warps.size()));
            return true;
        }
        Warp warp = ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarp(args[0]);
        if (warp == null) {
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.invalid-warp", "warp", args[0]);
            return true;
        }
        if (args.length > 1 && sender.hasPermission(this.getPermission() + ".others")) {
            target = ((GlobalWarpsPlugin)this.getPlugin()).getPlayer(args[1]);
            if (target == null) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.player-not-found", "player", args[1]);
                return true;
            }
        } else if (sender.isPlayer()) {
            target = sender;
        } else {
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.console-missing-arguments", new String[0]);
            return false;
        }
        ((GlobalWarpsPlugin)this.getPlugin()).getBridge().teleport(target.getName(), (LocationInfo)warp, new Consumer[]{s -> {
            if (target != sender) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "reply", "value", (String)s);
            }
        }}).thenAccept(success -> {
            if (success.booleanValue()) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warped", "warp", warp.getName());
            } else {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.warping", "warp", warp.getName());
            }
        });
        return true;
    }

    @Override
    public List<String> onTabComplete(GlobalCommandSender<S> sender, String label, String[] args) {
        if (args.length == 0) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().map(Warp::getName).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().map(Warp::getName).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission(this.getPermission() + ".others")) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getOnlinePlayerNames().stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

