/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.globalwarps.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.globalwarps.GlobalWarpsPlugin;
import de.themoep.globalwarps.Warp;
import de.themoep.globalwarps.commands.GlobalCommand;
import de.themoep.globalwarps.commands.GlobalCommandSender;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class SetWarpCommand<P extends GlobalWarpsPlugin<S>, S>
extends GlobalCommand<P, S> {
    public SetWarpCommand(P plugin) {
        super(plugin, "gsetwarp", "globalwarps.command.setwarp", null, "Command to set a new warp", "/<command> <warp> [<server> <world> <x> <y> <z> [<yaw> [<pitch>]]", "setwarp", "gcreatewarp", "createwarp", "gaddwarp", "addwarp");
    }

    @Override
    public boolean onCommand(GlobalCommandSender<S> sender, LocationInfo location, String label, String[] args) {
        LocationInfo warpLocation;
        if (args.length < 1) {
            return false;
        }
        if (((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarp(args[0]) != null) {
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.warp-already-exists", "warp", args[0]);
            return true;
        }
        if (args.length > 5 && sender.hasPermission(this.getPermission() + ".location")) {
            if (!((GlobalWarpsPlugin)this.getPlugin()).serverExists(args[1])) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.invalid-server", "server", args[0]);
                return true;
            }
            float yaw = 0.0f;
            float pitch = 0.0f;
            try {
                if (args.length > 6) {
                    yaw = Float.parseFloat(args[6]);
                    if (args.length > 7) {
                        pitch = Float.parseFloat(args[7]);
                    }
                }
                warpLocation = new LocationInfo(args[1], args[2], Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5]), yaw, pitch);
            }
            catch (NumberFormatException e) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.invalid-input", "error", e.getMessage());
                return true;
            }
        } else {
            if (location == null) {
                ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.console-missing-arguments", new String[0]);
                return false;
            }
            warpLocation = location;
        }
        Warp warp = new Warp(args[0], warpLocation);
        ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().addWarp(warp);
        ((GlobalWarpsPlugin)this.getPlugin()).saveWarps();
        ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warp-added", "warp", warp.getName());
        return true;
    }

    @Override
    public List<String> onTabComplete(GlobalCommandSender<S> sender, String label, String[] args) {
        if (args.length == 0) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().map(Warp::getName).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission(this.getPermission() + ".location")) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getServers().stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

