/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.globalwarps.commands;

import de.themoep.connectorplugin.LocationInfo;
import de.themoep.globalwarps.GlobalWarpsPlugin;
import de.themoep.globalwarps.Warp;
import de.themoep.globalwarps.commands.GlobalCommand;
import de.themoep.globalwarps.commands.GlobalCommandSender;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class DelWarpCommand<P extends GlobalWarpsPlugin<S>, S>
extends GlobalCommand<P, S> {
    public DelWarpCommand(P plugin) {
        super(plugin, "gdelwarp", "globalwarps.command.delwarp", null, "Command to remove a warp", "/<command> <warp>", "delwarp", "gdeletewarp", "deletewarp", "gremovewarp", "removewarp");
    }

    @Override
    public boolean onCommand(GlobalCommandSender<S> sender, LocationInfo location, String label, String[] args) {
        if (args.length < 1) {
            return false;
        }
        Warp warp = ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().removeWarp(args[0]);
        if (warp == null) {
            ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "error.invalid-warp", "warp", args[0]);
            return true;
        }
        ((GlobalWarpsPlugin)this.getPlugin()).removeWarp(warp.getName());
        ((GlobalWarpsPlugin)this.getPlugin()).sendLang(sender, "warp-removed", "warp", warp.getName());
        return true;
    }

    @Override
    public List<String> onTabComplete(GlobalCommandSender<S> sender, String label, String[] args) {
        if (args.length == 0) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().map(Warp::getName).collect(Collectors.toList());
        }
        if (args.length == 1) {
            return ((GlobalWarpsPlugin)this.getPlugin()).getWarpManager().getWarps().stream().map(Warp::getName).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

