/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.globalwarps.bungee;

import de.themoep.bungeeplugin.BungeePlugin;
import de.themoep.bungeeplugin.FileConfiguration;
import de.themoep.connectorplugin.BridgedCommand;
import de.themoep.connectorplugin.LocationInfo;
import de.themoep.connectorplugin.ProxyBridgeCommon;
import de.themoep.connectorplugin.bungee.BungeeConnectorPlugin;
import de.themoep.globalwarps.GlobalWarpsPlugin;
import de.themoep.globalwarps.Warp;
import de.themoep.globalwarps.WarpManager;
import de.themoep.globalwarps.bungee.BungeeCommandSender;
import de.themoep.globalwarps.commands.DelWarpCommand;
import de.themoep.globalwarps.commands.GlobalCommandSender;
import de.themoep.globalwarps.commands.SetWarpCommand;
import de.themoep.globalwarps.commands.UpdateWarpCommand;
import de.themoep.globalwarps.commands.WarpCommand;
import de.themoep.globalwarps.commands.WarpsCommand;
import de.themoep.minedown.MineDown;
import de.themoep.utils.lang.bungee.BungeeLanguageConfig;
import de.themoep.utils.lang.bungee.LanguageManager;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public final class GlobalWarps
extends BungeePlugin
implements GlobalWarpsPlugin<CommandSender> {
    private LanguageManager lang;
    private WarpManager warpManager;
    private BungeeConnectorPlugin connector;
    private FileConfiguration warpsConfig;

    public void onEnable() {
        this.connector = (BungeeConnectorPlugin)this.getProxy().getPluginManager().getPlugin("ConnectorPlugin");
        this.connector.getBridge().registerServerCommand((BridgedCommand)new WarpsCommand((GlobalWarpsPlugin)this));
        this.connector.getBridge().registerServerCommand((BridgedCommand)new WarpCommand((GlobalWarpsPlugin)this));
        this.connector.getBridge().registerServerCommand((BridgedCommand)new SetWarpCommand((GlobalWarpsPlugin)this));
        this.connector.getBridge().registerServerCommand((BridgedCommand)new DelWarpCommand((GlobalWarpsPlugin)this));
        this.connector.getBridge().registerServerCommand((BridgedCommand)new UpdateWarpCommand((GlobalWarpsPlugin)this));
        this.loadConfig();
    }

    public void loadConfig() {
        try {
            this.getConfig().loadConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.lang = new LanguageManager((Plugin)this, this.getConfig().getString("default-language"), new BungeeLanguageConfig[0]);
        this.warpManager = new WarpManager();
        try {
            this.warpsConfig = new FileConfiguration((Plugin)this, "warps.yml");
            Configuration warpsSection = this.warpsConfig.getSection("warps");
            for (String warpName : warpsSection.getKeys()) {
                Configuration warpSection = warpsSection.getSection(warpName);
                Warp warp = new Warp(warpName, new LocationInfo(warpSection.getString("server"), warpSection.getString("world"), warpSection.getDouble("x"), warpSection.getDouble("y"), warpSection.getDouble("z"), warpSection.getFloat("yaw"), warpSection.getFloat("pitch")));
                this.warpManager.addWarp(warp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean serverExists(String serverName) {
        return this.getProxy().getServerInfo(serverName) != null;
    }

    public void saveWarps() {
        Configuration warpsSection = this.warpsConfig.getSection("warps");
        for (Warp warp : this.getWarpManager().getWarps()) {
            Configuration warpSection = warpsSection.getSection(warp.getName());
            warpSection.set("server", (Object)warp.getServer());
            warpSection.set("world", (Object)warp.getWorld());
            warpSection.set("x", (Object)warp.getX());
            warpSection.set("y", (Object)warp.getY());
            warpSection.set("z", (Object)warp.getZ());
            warpSection.set("yaw", (Object)Float.valueOf(warp.getYaw()));
            warpSection.set("pitch", (Object)Float.valueOf(warp.getPitch()));
        }
        this.warpsConfig.saveConfig();
    }

    public void removeWarp(String warpName) {
        this.warpsConfig.set("warps." + warpName, null);
        this.warpsConfig.saveConfig();
    }

    public BaseComponent[] getLang(CommandSender sender, String key, String ... replacements) {
        return MineDown.parse((String)this.lang.getConfig((Object)sender).get(key), (String[])replacements);
    }

    public void sendLang(GlobalCommandSender<CommandSender> sender, String key, String ... replacements) {
        ((CommandSender)sender.getSender()).sendMessage(this.getLang((CommandSender)sender.getSender(), key, replacements));
    }

    public Collection<String> getServers() {
        return this.getProxy().getServers().keySet();
    }

    public Collection<String> getOnlinePlayerNames() {
        return this.getProxy().getPlayers().stream().map(CommandSender::getName).collect(Collectors.toSet());
    }

    public GlobalCommandSender<CommandSender> getPlayer(String playerName) {
        ProxiedPlayer player = this.getProxy().getPlayer(playerName);
        return player != null ? this.getSender((CommandSender)player) : null;
    }

    public GlobalCommandSender<CommandSender> getSender(CommandSender sender) {
        return new BungeeCommandSender(sender);
    }

    public ProxyBridgeCommon<BungeeConnectorPlugin, ProxiedPlayer> getBridge() {
        return this.connector.getBridge();
    }

    public String getName() {
        return this.getDescription().getName();
    }

    public WarpManager getWarpManager() {
        return this.warpManager;
    }
}

