/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.libs.folialib.impl.PlatformScheduler;
import de.themoep.entitydetection.libs.folialib.wrapper.task.WrappedTask;
import de.themoep.entitydetection.searcher.ChunkSearchResult;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchType;
import de.themoep.entitydetection.searcher.WGSearchResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntitySearch
implements Consumer<WrappedTask> {
    private final EntityDetection plugin;
    private final PlatformScheduler scheduler;
    private final CommandSender owner;
    private SearchType type = SearchType.CUSTOM;
    private Set<EntityType> searchedEntities = new HashSet<EntityType>();
    private Set<Class<?>> searchedBlockStates = new HashSet();
    private Set<Material> searchedMaterial = new HashSet<Material>();
    private long startTime;
    private boolean running = true;
    private Multimap<EntityType, Location> entities = MultimapBuilder.hashKeys().arrayListValues().build();
    private Map<Material, Multimap<Class, Location>> blockStates = new HashMap<Material, Multimap<Class, Location>>();
    private boolean isWorldGuardRegion = false;
    private final AtomicInteger pending = new AtomicInteger(0);

    public EntitySearch(EntityDetection plugin, CommandSender sender) {
        this.plugin = plugin;
        this.scheduler = plugin.getScheduler();
        this.owner = sender;
    }

    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    public SearchType getType() {
        return this.type;
    }

    public void setType(SearchType type) {
        this.type = this.getSearchedEntities().size() == 0 && this.getSearchedBlockStates().size() == 0 && this.getSearchedMaterial().size() == 0 ? type : SearchType.CUSTOM;
        Collections.addAll(this.searchedEntities, type.getEntities());
        Collections.addAll(this.searchedBlockStates, type.getBlockStates());
    }

    public void addSearchedType(EntityType type) {
        this.searchedEntities.add(type);
        this.type = SearchType.CUSTOM;
    }

    public void addSearchedBlockState(Class<?> c) {
        this.searchedBlockStates.add(c);
        this.type = SearchType.CUSTOM;
    }

    public void addSearchedMaterial(Material material) {
        this.searchedMaterial.add(material);
        this.type = SearchType.CUSTOM;
    }

    public Set<EntityType> getSearchedEntities() {
        return this.searchedEntities;
    }

    public Set<Class<?>> getSearchedBlockStates() {
        return this.searchedBlockStates;
    }

    public Set<Material> getSearchedMaterial() {
        return this.searchedMaterial;
    }

    public String getOwner() {
        return this.owner.getName();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isWorldGuardRegion() {
        return this.isWorldGuardRegion;
    }

    public void setWorldGuardRegion(boolean value) {
        this.isWorldGuardRegion = value;
    }

    public long getDuration() {
        return (System.currentTimeMillis() - this.getStartTime()) / 1000L;
    }

    public void start() {
        int scheduled = 0;
        if (this.searchedEntities.size() > 0) {
            for (World world : this.plugin.getServer().getWorlds()) {
                this.pending.incrementAndGet();
                ++scheduled;
                this.scheduler.runAtLocation(world.getSpawnLocation(), task -> {
                    try {
                        for (Entity entity : world.getEntities()) {
                            this.entities.put((Object)entity.getType(), (Object)entity.getLocation());
                        }
                    }
                    finally {
                        if (this.pending.decrementAndGet() == 0) {
                            this.scheduler.runAsync(this);
                        }
                    }
                });
            }
        }
        if (this.searchedBlockStates.size() > 0 || this.searchedMaterial.size() > 0) {
            for (World world : this.plugin.getServer().getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    this.pending.incrementAndGet();
                    ++scheduled;
                    this.scheduler.runAtLocation(chunk.getBlock(0, 0, 0).getLocation(), task -> {
                        try {
                            for (BlockState state : chunk.getTileEntities()) {
                                ListMultimap multiMap = this.blockStates.get(state.getType());
                                if (multiMap == null) {
                                    multiMap = MultimapBuilder.hashKeys().arrayListValues().build();
                                    this.blockStates.put(state.getType(), (Multimap<Class, Location>)multiMap);
                                }
                                multiMap.put((Object)state.getClass(), (Object)state.getLocation());
                            }
                        }
                        finally {
                            if (this.pending.decrementAndGet() == 0) {
                                this.scheduler.runAsync(this);
                            }
                        }
                    });
                }
            }
        }
        if (scheduled == 0) {
            this.scheduler.runAsync(this);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop(String name) {
        this.running = false;
        if (!this.owner.getName().equals(name)) {
            this.owner.sendMessage(String.valueOf(ChatColor.YELLOW) + name + String.valueOf(ChatColor.RED) + " stopped your " + String.valueOf((Object)this.getType()) + " search after " + this.getDuration() + "s!");
        }
    }

    @Override
    public void accept(WrappedTask task) {
        this.startTime = System.currentTimeMillis();
        SearchResult result = this.isWorldGuardRegion ? new WGSearchResult(this) : new ChunkSearchResult(this);
        this.entities.forEach((type, location) -> {
            if (this.searchedEntities.contains(type)) {
                result.add((Location)location, type.toString());
            }
        });
        this.blockStates.forEach((type, blockLocations) -> blockLocations.forEach((clazz, location) -> {
            if (this.searchedBlockStates.contains(BlockState.class) || this.searchedMaterial.contains(type) || this.searchedBlockStates.contains(clazz)) {
                result.add((Location)location, type.toString());
            }
        }));
        if (!this.running) {
            return;
        }
        result.sort();
        this.plugin.addResult(result);
        this.plugin.send(this.owner, result);
        this.running = false;
        this.plugin.clearCurrentSearch();
    }
}

