/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import de.themoep.entitydetection.ChunkLocation;
import de.themoep.entitydetection.Utils;
import de.themoep.entitydetection.searcher.EntitySearch;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchResultEntry;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class ChunkSearchResult
extends SearchResult<ChunkLocation> {
    public ChunkSearchResult(EntitySearch search) {
        super(search);
    }

    @Override
    public void addEntity(Entity entity) {
        this.add(entity.getLocation(), entity.getType().toString());
    }

    @Override
    public void addBlockState(BlockState blockState) {
        this.add(blockState.getLocation(), blockState.getType().toString());
    }

    @Override
    public void add(Location location, String type) {
        ChunkLocation chunkLocation = new ChunkLocation(location);
        if (!this.resultEntryMap.containsKey(chunkLocation)) {
            this.resultEntryMap.put(chunkLocation, new SearchResultEntry<ChunkLocation>(chunkLocation));
        }
        ((SearchResultEntry)this.resultEntryMap.get(chunkLocation)).increment(type);
    }

    @Override
    public void teleport(Player sender, SearchResultEntry<ChunkLocation> entry, int i) {
        try {
            World targetWorld = Bukkit.getWorld((String)entry.getLocation().getWorld());
            if (targetWorld == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "World " + String.valueOf(ChatColor.WHITE) + entry.getLocation().getWorld() + String.valueOf(ChatColor.RED) + " is not loaded anymore.");
                return;
            }
            int cx = entry.getLocation().getX();
            int cz = entry.getLocation().getZ();
            int anchorX = (cx << 4) + 8;
            int anchorZ = (cz << 4) + 8;
            Location location = new Location(targetWorld, (double)anchorX, 64.0, (double)anchorZ);
            this.scheduler.runAtLocation(location, task -> targetWorld.getChunkAtAsync(cx, cz, false, chunk -> {
                Location loc = null;
                for (Entity entity : chunk.getEntities()) {
                    if (!entity.getType().toString().equals(entry.getEntryCount().get(0).getKey())) continue;
                    loc = entity.getLocation();
                    break;
                }
                for (Entity entity : chunk.getTileEntities()) {
                    if (!entity.getType().toString().equals(entry.getEntryCount().get(0).getKey())) continue;
                    loc = entity.getLocation().add(0.0, 1.0, 0.0);
                    break;
                }
                if (loc == null) {
                    loc = chunk.getWorld().getHighestBlockAt(anchorX, anchorZ).getLocation().add(0.0, 2.0, 0.0);
                }
                Location finalLoc = loc;
                this.scheduler.teleportAsync((Entity)sender, finalLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to entry " + String.valueOf(ChatColor.WHITE) + i + ": " + String.valueOf(ChatColor.YELLOW) + String.valueOf(entry.getLocation()) + " " + String.valueOf(ChatColor.RED) + entry.getSize() + " " + String.valueOf(ChatColor.GREEN) + Utils.enumToHumanName(entry.getEntryCount().get(0).getKey()) + "[" + String.valueOf(ChatColor.WHITE) + String.valueOf(entry.getEntryCount().get(0).getValue()) + String.valueOf(ChatColor.GREEN) + "]");
            }));
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + e.getMessage());
        }
    }
}

