/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.commands;

import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.commands.SubCommand;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchResultEntry;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpSubCommand
extends SubCommand {
    public TpSubCommand(EntityDetection plugin) {
        super(plugin, plugin.getName().toLowerCase(), "tp", "<#result>");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This sub command can only be run by a player!");
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        return this.teleport((Player)sender, args[0], this.getPlugin().getResult(sender));
    }

    private <T> boolean teleport(Player sender, String page, SearchResult<T> lastResult) {
        int i;
        if (lastResult == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You have to view a search result before teleporting to an entry! Use /detect search or /detect list [<type>]");
            return true;
        }
        try {
            i = Integer.parseInt(page);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + page + String.valueOf(ChatColor.RED) + " is not a proper number input!");
            return false;
        }
        if (i == 0 || lastResult.getSortedEntries().size() < i) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Result " + String.valueOf(ChatColor.YELLOW) + page + String.valueOf(ChatColor.RED) + " is not in the list!");
            return true;
        }
        SearchResultEntry<T> entry = lastResult.getSortedEntries().get(i - 1);
        lastResult.teleport(sender, entry, i);
        return true;
    }
}

