/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.commands;

import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.commands.SubCommand;
import de.themoep.entitydetection.searcher.EntitySearch;
import de.themoep.entitydetection.searcher.SearchType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class SearchSubCommand
extends SubCommand {
    public SearchSubCommand(EntityDetection plugin) {
        super(plugin, plugin.getName().toLowerCase(), "search", "[monster|passive|misc|block|tile|entity|all|<type>]");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        EntitySearch search = new EntitySearch(this.getPlugin(), sender);
        if (args.length > 0) {
            for (String arg : args) {
                boolean found;
                if ("--regions".equalsIgnoreCase(arg)) {
                    Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
                    if (plugin == null || !plugin.isEnabled() || !plugin.getDescription().getVersion().startsWith("7")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unable to start WorldGuard search. WorldGuard not enabled or outdated!");
                        return true;
                    }
                    search.setWorldGuardRegion(true);
                    if (args.length != 1) continue;
                    search.setType(SearchType.MONSTER);
                    continue;
                }
                if (arg.endsWith("s")) {
                    arg = arg.substring(0, arg.length() - 1);
                }
                if (!(found = false)) {
                    try {
                        search.addSearchedType(EntityType.valueOf((String)arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        search.addSearchedBlockState(Class.forName("org.bukkit.block." + arg, false, this.getPlugin().getServer().getClass().getClassLoader()));
                        found = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        search.setType(SearchType.valueOf(arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        search.setType(SearchType.getByAlias(arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        search.addSearchedMaterial(Material.valueOf((String)arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (found) continue;
                return false;
            }
        } else {
            search.setType(SearchType.MONSTER);
        }
        if (!this.getPlugin().startSearch(search)) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + search.getOwner() + String.valueOf(ChatColor.RED) + " already started a search!");
        }
        return true;
    }
}

