/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.commands;

import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.commands.SubCommand;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchType;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class ListSubCommand
extends SubCommand {
    public ListSubCommand(EntityDetection plugin) {
        super(plugin, plugin.getName().toLowerCase(), "list", "[<page> [monster|passive|misc|block|tile|all|<type>]]");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        SearchResult<?> result = this.getPlugin().getResult(sender);
        int page = 1;
        String lastName = sender.getName();
        String resultType = "";
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + args[0] + String.valueOf(ChatColor.RED) + " is not a proper number input!");
                return false;
            }
            if (args.length > 1) {
                boolean found;
                lastName = args[1];
                String arg = args[1];
                if (arg.endsWith("s")) {
                    arg = arg.substring(0, arg.length() - 1);
                }
                if (!(found = false)) {
                    try {
                        result = this.getPlugin().getResult(EntityType.valueOf((String)arg.toUpperCase()).toString());
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        result = this.getPlugin().getResult(Class.forName("org.bukkit.block." + arg, false, this.getPlugin().getServer().getClass().getClassLoader()).getSimpleName());
                        found = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        result = this.getPlugin().getResult(SearchType.valueOf(arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        result = this.getPlugin().getResult(SearchType.getByAlias(arg.toUpperCase()));
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    try {
                        result = this.getPlugin().getResult(Material.valueOf((String)arg.toUpperCase()).toString());
                        found = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (!found) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + arg + String.valueOf(ChatColor.RED) + " is neither a valid EntityType, Material, BlockState, SearchType or alias of a search type?");
                    return false;
                }
                resultType = lastName;
            }
        }
        if (result == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No previous result for " + lastName + " found!");
            return true;
        }
        if (page == 0 || result.getSortedEntries().size() < (page - 1) * 10) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "There is no page " + page + " in the last " + lastName + " result!");
            return true;
        }
        this.getPlugin().send(sender, result, resultType, page - 1);
        return true;
    }
}

