/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection;

import de.themoep.entitydetection.Utils;
import de.themoep.entitydetection.commands.ListSubCommand;
import de.themoep.entitydetection.commands.PluginCommandExecutor;
import de.themoep.entitydetection.commands.SearchSubCommand;
import de.themoep.entitydetection.commands.StopSubCommand;
import de.themoep.entitydetection.commands.TpSubCommand;
import de.themoep.entitydetection.libs.folialib.FoliaLib;
import de.themoep.entitydetection.libs.folialib.impl.PlatformScheduler;
import de.themoep.entitydetection.libs.lang.bukkit.BukkitLanguageConfig;
import de.themoep.entitydetection.libs.lang.bukkit.LanguageManager;
import de.themoep.entitydetection.libs.minedown.MineDown;
import de.themoep.entitydetection.libs.minedown.Replacer;
import de.themoep.entitydetection.searcher.EntitySearch;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchResultEntry;
import de.themoep.entitydetection.searcher.SearchType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EntityDetection
extends JavaPlugin {
    private PlatformScheduler scheduler;
    private LanguageManager lang;
    private EntitySearch currentSearch;
    private Map<SearchType, SearchResult<?>> results = new HashMap();
    private Map<String, SearchResult<?>> customResults = new HashMap();
    private Map<String, SearchResult<?>> lastResultViewed = new HashMap();

    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    public void onEnable() {
        FoliaLib foliaLib = new FoliaLib((Plugin)this);
        this.scheduler = foliaLib.getScheduler();
        this.lang = new LanguageManager((Plugin)this, System.getProperty("de.themoep.entitydetection.default-language", "en"), new BukkitLanguageConfig[0]);
        PluginCommandExecutor cmdEx = new PluginCommandExecutor(this);
        cmdEx.register(new SearchSubCommand(this));
        cmdEx.register(new TpSubCommand(this));
        cmdEx.register(new ListSubCommand(this));
        cmdEx.register(new StopSubCommand(this));
    }

    public String getRawMessage(CommandSender sender, String key, String ... replacements) {
        return this.lang.getConfig(sender).get(key, replacements);
    }

    public Component getMessage(CommandSender sender, String key, String ... replacements) {
        return MineDown.parse(this.getRawMessage(sender, key, replacements), new String[0]);
    }

    public boolean startSearch(EntitySearch search) {
        if (this.currentSearch != null && this.currentSearch.isRunning()) {
            return false;
        }
        this.currentSearch = search;
        search.start();
        return true;
    }

    public boolean stopSearch(String stopper) {
        if (this.currentSearch == null || !this.currentSearch.isRunning()) {
            return false;
        }
        this.currentSearch.stop(stopper);
        this.clearCurrentSearch();
        return true;
    }

    public void addResult(SearchResult<?> result) {
        if (result.getType() == SearchType.CUSTOM && result.getSearched().size() == 1) {
            Set<String> searchedEntities = result.getSearched();
            this.customResults.put(searchedEntities.toArray(new String[searchedEntities.size()])[0], result);
        } else {
            this.results.put(result.getType(), result);
        }
    }

    public void clearCurrentSearch() {
        this.currentSearch = null;
    }

    public EntitySearch getCurrentSearch() {
        return this.currentSearch;
    }

    public void send(CommandSender sender, SearchResult<?> result) {
        this.send(sender, result, "", 0);
    }

    public void send(CommandSender sender, SearchResult<?> result, String resultType, int page) {
        this.lastResultViewed.put(sender.getName(), result);
        String dateStr = new SimpleDateFormat(this.getRawMessage(sender, "result.time-format", new String[0])).format(new Date(result.getEndTime()));
        int start = page * 10;
        Component searchedTypes = this.getMessage(sender, "result.searched-types.head", new String[0]);
        Iterator<String> typeIter = result.getSearched().iterator();
        while (typeIter.hasNext()) {
            searchedTypes = searchedTypes.append((Component)Component.newline()).append(this.getMessage(sender, "result.searched-types.entry", "type", Utils.enumToHumanName(typeIter.next())));
        }
        Component message = this.getMessage(sender, "result.head", "type", Utils.enumToHumanName(result.getType()), "timestamp", dateStr, "duration", String.valueOf(result.getDuration()));
        message = Replacer.replaceIn(message, "searchedtypes", searchedTypes);
        List<SearchResultEntry<?>> results = result.getSortedEntries();
        if (results.size() > 0) {
            for (int line = start; line < start + 10 && line < results.size(); ++line) {
                SearchResultEntry<?> entry = results.get(line);
                Component resultLine = this.getMessage(sender, "result.entry", "line", String.valueOf(line + 1), "location", String.valueOf(entry.getLocation()), "size", String.valueOf(entry.getSize()));
                TextComponent entityCounts = Component.empty();
                int entitiesListed = 0;
                for (Map.Entry<String, Integer> entityEntry : entry.getEntryCount()) {
                    entityCounts = entityCounts.append(this.getMessage(sender, "result.entity-count", "type", Utils.enumToHumanName(entityEntry.getKey()), "count", String.valueOf(entityEntry.getValue())));
                    if (++entitiesListed < 3) continue;
                    break;
                }
                resultLine = Replacer.replaceIn(resultLine, "entitycounts", (Component)entityCounts);
                message = message.append((Component)Component.newline()).append(resultLine);
            }
            message = results.size() > start + 10 ? (page == 0 ? message.append((Component)Component.newline()).append(this.getMessage(sender, "result.footer.next-page-only", "page", String.valueOf(page + 1), "nextpage", String.valueOf(page + 2), "resulttype", resultType)) : message.append((Component)Component.newline()).append(this.getMessage(sender, "result.footer.pagination", "page", String.valueOf(page + 1), "previouspage", String.valueOf(page), "nextpage", String.valueOf(page + 2), "resulttype", resultType))) : (page > 0 ? message.append((Component)Component.newline()).append(this.getMessage(sender, "result.footer.previous-page-only", "page", String.valueOf(page + 1), "previouspage", String.valueOf(page), "resulttype", resultType)) : message.append((Component)Component.newline()).append(this.getMessage(sender, "result.footer.no-pages", "page", String.valueOf(page + 1))));
        } else {
            message = message.append((Component)Component.newline()).append(this.getMessage(sender, "result.no-entries", new String[0]));
        }
        sender.sendMessage(message);
    }

    public SearchResult<?> getResult(CommandSender sender) {
        return this.lastResultViewed.get(sender.getName());
    }

    public SearchResult<?> getResult(String type) {
        return this.customResults.get(type);
    }

    public SearchResult<?> getResult(SearchType type) {
        return this.results.get((Object)type);
    }
}

