/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.WaterMob;

public enum SearchType {
    MONSTER(new Class[]{Monster.class, Slime.class}),
    PASSIVE(new String[]{"ANIMAL"}, new Class[]{Animals.class, Ambient.class, NPC.class, WaterMob.class, Golem.class}),
    MISC(new EntityType[]{EntityType.FIREWORK, EntityType.ENDER_SIGNAL, EntityType.BOAT}, new Class[]{Projectile.class, Minecart.class, Item.class}),
    BLOCK(new EntityType[]{EntityType.ARMOR_STAND, EntityType.FALLING_BLOCK, EntityType.ENDER_CRYSTAL}, new Class[]{Hanging.class}),
    ENTITY(new String[]{"ENTITIES"}, EntityType.values()),
    TILE(new String[]{"BLOCKSTATE"}, new Class[]{BlockState.class}),
    ALL(EntityType.values(), new Class[]{BlockState.class}),
    CUSTOM;

    private String[] aliases;
    private EntityType[] entityTypes;
    private Class<?>[] blockStates;

    private SearchType(String[] aliases, EntityType[] eTypes, Class[] classes) {
        this.aliases = aliases;
        HashSet<EntityType> typeSet = new HashSet<EntityType>();
        Collections.addAll(typeSet, eTypes);
        LinkedList<Class> classList = new LinkedList<Class>(Arrays.asList(classes));
        if (classes.length > 0) {
            block0: for (EntityType et : EntityType.values()) {
                Class e;
                if (typeSet.contains(et) || (e = et.getEntityClass()) == null) continue;
                for (Class eClass : classList) {
                    if (!eClass.isAssignableFrom(e)) continue;
                    typeSet.add(et);
                    continue block0;
                }
            }
        }
        this.entityTypes = typeSet.toArray(new EntityType[typeSet.size()]);
        this.blockStates = classList.toArray(new Class[classList.size()]);
    }

    private SearchType(Class<? extends Entity>[] classes) {
        this(new String[0], new EntityType[0], classes);
    }

    private SearchType(EntityType[] types) {
        this(new String[0], types, new Class[0]);
    }

    private SearchType(String[] aliases, Class<? extends Entity>[] classes) {
        this(aliases, new EntityType[0], classes);
    }

    private SearchType(EntityType[] types, Class<? extends Entity>[] classes) {
        this(new String[0], types, classes);
    }

    private SearchType(String[] aliases, EntityType[] entityTypes) {
        this(aliases, entityTypes, new Class[0]);
    }

    private SearchType() {
        this(new String[0], new EntityType[0], new Class[0]);
    }

    public static SearchType getByAlias(String alias) throws IllegalArgumentException {
        for (SearchType type : SearchType.values()) {
            for (String a : type.aliases) {
                if (!a.equals(alias)) continue;
                return type;
            }
        }
        throw new IllegalArgumentException(alias + " is not an alias of any SearchType.");
    }

    public EntityType[] getEntities() {
        return this.entityTypes;
    }

    public Class<?>[] getBlockStates() {
        return this.blockStates;
    }
}

