/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchResultEntry<T>
implements Comparable<SearchResultEntry<T>> {
    private T location;
    private Map<String, Integer> entryCount = new HashMap<String, Integer>();
    private List<Map.Entry<String, Integer>> finalList = new ArrayList<Map.Entry<String, Integer>>();
    private int size = 0;

    SearchResultEntry(T location) {
        this.location = location;
    }

    public void increment(String type) {
        ++this.size;
        if (!this.entryCount.containsKey(type)) {
            this.entryCount.put(type, 1);
        } else {
            this.entryCount.put(type, this.entryCount.get(type) + 1);
        }
    }

    public int getSize() {
        return this.size;
    }

    public T getLocation() {
        return this.location;
    }

    public List<Map.Entry<String, Integer>> getEntryCount() {
        return this.finalList;
    }

    public void sort() {
        this.finalList = new ArrayList<Map.Entry<String, Integer>>(this.entryCount.entrySet());
        this.finalList.sort(Collections.reverseOrder(Comparator.comparingInt(Map.Entry::getValue)));
    }

    @Override
    public int compareTo(SearchResultEntry o) {
        return Integer.compare(this.size, o.getSize());
    }
}

