/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import de.themoep.entitydetection.searcher.EntitySearch;
import de.themoep.entitydetection.searcher.SearchResultEntry;
import de.themoep.entitydetection.searcher.SearchType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public abstract class SearchResult<T> {
    private SearchType type;
    private Set<String> searched;
    private long startTime;
    private long endTime = 0L;
    protected Map<T, SearchResultEntry<T>> resultEntryMap = new HashMap<T, SearchResultEntry<T>>();
    protected List<SearchResultEntry<T>> resultEntryList = new ArrayList<SearchResultEntry<T>>();

    public SearchResult(EntitySearch search) {
        this.type = search.getType();
        this.searched = new HashSet<String>();
        for (EntityType entityType : search.getSearchedEntities()) {
            this.searched.add(entityType.toString());
        }
        for (Material material : search.getSearchedMaterial()) {
            this.searched.add(material.toString());
        }
        for (Class clazz : search.getSearchedBlockStates()) {
            this.searched.add(clazz.getSimpleName());
        }
        this.startTime = search.getStartTime();
    }

    public abstract void addEntity(Entity var1);

    public abstract void addBlockState(BlockState var1);

    public abstract void add(Location var1, String var2);

    public SearchType getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime == 0L ? System.currentTimeMillis() : this.endTime;
    }

    public long getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    public Set<String> getSearched() {
        return this.searched;
    }

    public List<SearchResultEntry<T>> getSortedEntries() {
        return this.resultEntryList;
    }

    public void sort() {
        for (SearchResultEntry<T> chunkEntry : this.resultEntryMap.values()) {
            chunkEntry.sort();
        }
        this.resultEntryList = new ArrayList<SearchResultEntry<T>>(this.resultEntryMap.values());
        Collections.sort(this.resultEntryList, Collections.reverseOrder());
        this.endTime = System.currentTimeMillis();
    }

    public abstract void teleport(Player var1, SearchResultEntry<T> var2, int var3);
}

