/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.commands;

import de.themoep.entitydetection.EntityDetection;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class SubCommand {
    private final EntityDetection plugin;
    private final String command;
    private final String path;
    private final Permission permission;
    private final String arguments;

    public SubCommand(EntityDetection plugin, String command, String path, String arguments) {
        this.plugin = plugin;
        this.command = command;
        this.path = path;
        this.permission = new Permission(plugin.getName().toLowerCase() + ".command." + this.getPath().replace(' ', '.').toLowerCase(), "Get access to the /" + this.getCommand() + " " + this.getPath() + " subcommand.", PermissionDefault.OP);
        this.arguments = arguments;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public String getCommand() {
        return this.command;
    }

    public String getPath() {
        return this.path;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public EntityDetection getPlugin() {
        return this.plugin;
    }

    public String getUsage() {
        return this.getUsage(this.getCommand());
    }

    public String getUsage(String label) {
        return "/" + label + " " + this.getPath() + " " + this.arguments;
    }
}

