/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.commands;

import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.commands.SubCommand;
import de.themoep.entitydetection.libs.minedown.Replacer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class PluginCommandExecutor
implements CommandExecutor {
    private final EntityDetection plugin;
    private final Map<String, Map<String, SubCommand>> subCommands = new HashMap<String, Map<String, SubCommand>>();
    private final Component header;

    public PluginCommandExecutor(EntityDetection plugin) {
        this.plugin = plugin;
        this.header = ((TextComponent)((TextComponent)Component.text((String)((String)plugin.getDescription().getAuthors().get(0) + "'s ")).color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)plugin.getName()).color((TextColor)NamedTextColor.RED))).append(Component.text((String)(" v" + plugin.getDescription().getVersion())).color((TextColor)NamedTextColor.GRAY));
        plugin.getCommand(plugin.getName().toLowerCase()).setExecutor((CommandExecutor)this);
    }

    public void register(SubCommand sub) {
        if (!this.subCommands.containsKey(sub.getCommand())) {
            this.subCommands.put(sub.getCommand(), new LinkedHashMap());
        }
        if (this.subCommands.get(sub.getCommand()).containsKey(sub.getPath())) {
            throw new IllegalArgumentException("A sub command with the path '" + sub.getPath() + "' is already defined for command '" + sub.getCommand() + "'!");
        }
        this.subCommands.get(sub.getCommand()).put(sub.getPath(), sub);
        try {
            this.plugin.getServer().getPluginManager().addPermission(sub.getPermission());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int pathPartCount;
        if (args.length == 0) {
            Component helpText = Component.empty().append(this.header);
            if (this.subCommands.containsKey(cmd.getName())) {
                for (SubCommand sub : this.subCommands.get(cmd.getName()).values()) {
                    if (!sender.hasPermission(sub.getPermission())) continue;
                    Component commandHelp = this.plugin.getMessage(sender, "help.sub-command.usage", "usage", sub.getUsage(label));
                    commandHelp = Replacer.replaceIn(commandHelp, "description", this.plugin.getMessage(sender, "help." + sub.getPath().replace(' ', '.'), new String[0]));
                    helpText = helpText.append((Component)Component.newline()).append(commandHelp);
                }
            } else {
                helpText = helpText.append((Component)Component.newline()).append(this.plugin.getMessage(sender, "help.sub-command.none", "command", cmd.getName()));
            }
            sender.sendMessage(helpText);
            return true;
        }
        SubCommand sub = null;
        if (this.subCommands.containsKey(cmd.getName())) {
            String path = args[0];
            for (pathPartCount = 1; !this.subCommands.get(cmd.getName()).containsKey(path) && pathPartCount < args.length; ++pathPartCount) {
                path = path + " " + args[pathPartCount].toLowerCase();
            }
            sub = this.subCommands.get(cmd.getName()).get(path);
        }
        if (sub == null) {
            if (this.subCommands.containsKey(cmd.getName())) {
                Set<String> subCmdsStr = this.subCommands.get(cmd.getName()).keySet();
                sender.sendMessage(this.plugin.getMessage(sender, "help.usage", "usage", "/" + label + " " + Arrays.toString(subCmdsStr.toArray(new String[subCmdsStr.size()]))));
                return true;
            }
            return false;
        }
        if (!sender.hasPermission(sub.getPermission())) {
            sender.sendMessage(this.plugin.getMessage(sender, "error.no-permission", "action", sub.getPath(), "permission", sub.getPermission().getName()));
            return true;
        }
        String[] subArgs = new String[]{};
        if (args.length > pathPartCount) {
            subArgs = Arrays.copyOfRange(args, pathPartCount, args.length);
        }
        if (!sub.execute(sender, subArgs)) {
            sender.sendMessage(this.plugin.getMessage(sender, "help.usage", "usage", sub.getUsage(label)));
        }
        return true;
    }
}

