/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import de.themoep.entitydetection.Utils;
import de.themoep.entitydetection.searcher.EntitySearch;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchResultEntry;
import java.lang.ref.WeakReference;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public class WGSearchResult
extends SearchResult<ProtectedRegionEntry> {
    public WGSearchResult(EntitySearch search) {
        super(search);
    }

    @Override
    public void addEntity(Entity entity) {
        this.add(entity.getLocation(), entity.getType().toString());
    }

    @Override
    public void addBlockState(BlockState blockState) {
        this.add(blockState.getLocation(), blockState.getType().toString());
    }

    @Override
    public void add(Location location, String type) {
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        ApplicableRegionSet applicableRegions = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
        applicableRegions.forEach(region -> {
            ProtectedRegionEntry protectedRegionEntry = new ProtectedRegionEntry(location.getWorld(), (ProtectedRegion)region);
            if (!this.resultEntryMap.containsKey(protectedRegionEntry)) {
                this.resultEntryMap.put(protectedRegionEntry, new SearchResultEntry<ProtectedRegionEntry>(protectedRegionEntry));
            }
            ((SearchResultEntry)this.resultEntryMap.get(protectedRegionEntry)).increment(type);
        });
    }

    @Override
    public void teleport(Player sender, SearchResultEntry<ProtectedRegionEntry> entry, int i) {
        com.sk89q.worldedit.util.Location wgLocation = (com.sk89q.worldedit.util.Location)entry.getLocation().region.getFlag((Flag)Flags.TELE_LOC);
        try {
            Location loc;
            World world = (World)entry.getLocation().world.get();
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "World " + ChatColor.WHITE + entry.getLocation().worldName + ChatColor.RED + " is not loaded anymore.");
                return;
            }
            Location location = loc = wgLocation != null ? BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)wgLocation) : null;
            if (loc == null) {
                loc = BukkitAdapter.adapt((World)world, (BlockVector3)entry.getLocation().region.getMinimumPoint().add(entry.getLocation().region.getMaximumPoint().subtract(entry.getLocation().region.getMinimumPoint()).divide(2)));
            }
            sender.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            sender.sendMessage(ChatColor.GREEN + "Teleported to entry " + ChatColor.WHITE + i + ": " + ChatColor.YELLOW + entry.getLocation().region.getId() + " " + ChatColor.RED + entry.getSize() + " " + ChatColor.GREEN + Utils.enumToHumanName(entry.getEntryCount().get(0).getKey()) + "[" + ChatColor.WHITE + entry.getEntryCount().get(0).getValue() + ChatColor.GREEN + "]");
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
        }
    }

    public static class ProtectedRegionEntry {
        String worldName;
        WeakReference<World> world;
        ProtectedRegion region;

        public ProtectedRegionEntry(World world, ProtectedRegion region) {
            this.worldName = world.getName();
            this.world = new WeakReference<World>(world);
            this.region = region;
        }

        public String toString() {
            World w = (World)this.world.get();
            return "w: " + this.worldName + (w == null ? " (unloaded)" : "") + ", r: " + this.region.getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProtectedRegionEntry that = (ProtectedRegionEntry)o;
            return Objects.equals(this.world, that.world) && Objects.equals(this.region, that.region);
        }

        public int hashCode() {
            return Objects.hash(this.world, this.region);
        }
    }
}

