/*
 * Decompiled with CFR 0.152.
 */
package de.themoep.entitydetection.searcher;

import de.themoep.entitydetection.EntityDetection;
import de.themoep.entitydetection.searcher.ChunkSearchResult;
import de.themoep.entitydetection.searcher.SearchResult;
import de.themoep.entitydetection.searcher.SearchType;
import de.themoep.entitydetection.searcher.WGSearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EntitySearch
extends BukkitRunnable {
    private final EntityDetection plugin;
    private final CommandSender owner;
    private SearchType type = SearchType.CUSTOM;
    private Set<EntityType> searchedEntities = new HashSet<EntityType>();
    private Set<Class<?>> searchedBlockStates = new HashSet();
    private Set<Material> searchedMaterial = new HashSet<Material>();
    private long startTime;
    private boolean running = true;
    private List<Entity> entities = new ArrayList<Entity>();
    private List<BlockState> blockStates = new ArrayList<BlockState>();
    private boolean isWorldGuardRegion = false;

    public EntitySearch(EntityDetection plugin, CommandSender sender) {
        this.plugin = plugin;
        this.owner = sender;
    }

    public SearchType getType() {
        return this.type;
    }

    public void setType(SearchType type) {
        this.type = this.getSearchedEntities().size() == 0 && this.getSearchedBlockStates().size() == 0 && this.getSearchedMaterial().size() == 0 ? type : SearchType.CUSTOM;
        Collections.addAll(this.searchedEntities, type.getEntities());
        Collections.addAll(this.searchedBlockStates, type.getBlockStates());
    }

    public void addSearchedType(EntityType type) {
        this.searchedEntities.add(type);
        this.type = SearchType.CUSTOM;
    }

    public void addSearchedBlockState(Class<?> c) {
        this.searchedBlockStates.add(c);
        this.type = SearchType.CUSTOM;
    }

    public void addSearchedMaterial(Material material) {
        this.searchedMaterial.add(material);
        this.type = SearchType.CUSTOM;
    }

    public Set<EntityType> getSearchedEntities() {
        return this.searchedEntities;
    }

    public Set<Class<?>> getSearchedBlockStates() {
        return this.searchedBlockStates;
    }

    public Set<Material> getSearchedMaterial() {
        return this.searchedMaterial;
    }

    public String getOwner() {
        return this.owner.getName();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isWorldGuardRegion() {
        return this.isWorldGuardRegion;
    }

    public void setWorldGuardRegion(boolean value) {
        this.isWorldGuardRegion = value;
    }

    public long getDuration() {
        return (System.currentTimeMillis() - this.getStartTime()) / 1000L;
    }

    public BukkitTask start() {
        if (this.searchedEntities.size() > 0) {
            for (World world : this.plugin.getServer().getWorlds()) {
                this.entities.addAll(world.getEntities());
            }
        }
        if (this.searchedBlockStates.size() > 0 || this.searchedMaterial.size() > 0) {
            for (World world : this.plugin.getServer().getWorlds()) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    this.blockStates.addAll(Arrays.asList(chunk.getTileEntities()));
                }
            }
        }
        return this.runTaskAsynchronously((Plugin)this.plugin);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop(String name) {
        this.running = false;
        this.cancel();
        if (!this.owner.getName().equals(name)) {
            this.owner.sendMessage(ChatColor.YELLOW + name + ChatColor.RED + " stopped your " + (Object)((Object)this.getType()) + " search after " + this.getDuration() + "s!");
        }
    }

    public void run() {
        this.startTime = System.currentTimeMillis();
        SearchResult result = this.isWorldGuardRegion ? new WGSearchResult(this) : new ChunkSearchResult(this);
        for (Entity e : this.entities) {
            if (!this.running) {
                return;
            }
            if (!this.searchedEntities.contains(e.getType())) continue;
            result.addEntity(e);
        }
        for (BlockState blockState : this.blockStates) {
            if (!this.running) {
                return;
            }
            if (!this.searchedBlockStates.contains(BlockState.class) && !this.searchedMaterial.contains(blockState.getType()) && !this.searchedBlockStates.contains(blockState.getClass())) continue;
            result.addBlockState(blockState);
        }
        result.sort();
        this.plugin.addResult(result);
        this.plugin.send(this.owner, result);
        this.running = false;
        this.plugin.clearCurrentSearch();
    }
}

